/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import y.base.Node;
import y.base.NodeCursor;
import y.layout.organic.InteractiveOrganicLayouter;
import y.view.MoveSelectionMode;
import y.view.NodeRealizer;

public class InteractiveMoveSelectionMode
extends MoveSelectionMode {
    private InteractiveOrganicLayouter _layouter;

    public InteractiveMoveSelectionMode(InteractiveOrganicLayouter layouter) {
        if (layouter == null) {
            throw new IllegalArgumentException("layouter must not be null");
        }
        this._layouter = layouter;
    }

    protected void selectionMoveStarted(double x, double y) {
        this.view.setDrawingMode(0);
        NodeCursor nodeCursor = this.getGraph2D().selectedNodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            NodeRealizer realizer = this.getGraph2D().getRealizer(node);
            this._layouter.setCenter(node, realizer.getCenterX(), realizer.getCenterY());
            this._layouter.setInertia(node, 1.0);
            this.increaseNeighborsHeat(node);
            nodeCursor.next();
        }
        this._layouter.wakeUp();
    }

    protected void selectionOnMove(double dx, double dy, double x, double y) {
        NodeCursor nodeCursor = this.getGraph2D().selectedNodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            NodeRealizer realizer = this.getGraph2D().getRealizer(node);
            this._layouter.setCenter(node, realizer.getCenterX(), realizer.getCenterY());
            this.increaseNeighborsHeat(node);
            nodeCursor.next();
        }
        this._layouter.wakeUp();
    }

    protected void selectionMovedAction(double dx, double dy, double x, double y) {
        NodeCursor nodeCursor = this.getGraph2D().selectedNodes();
        while (nodeCursor.ok()) {
            Node node = nodeCursor.node();
            NodeRealizer realizer = this.getGraph2D().getRealizer(node);
            this._layouter.setCenter(node, realizer.getCenterX(), realizer.getCenterY());
            this._layouter.setInertia(node, 0.0);
            this.increaseNeighborsHeat(node);
            nodeCursor.next();
        }
        this._layouter.wakeUp();
    }

    protected void increaseNeighborsHeat(Node originalNode) {
        NodeCursor cursor = originalNode.neighbors();
        while (cursor.ok()) {
            Node neighbor = cursor.node();
            double oldStress = this._layouter.getStress(neighbor);
            this._layouter.setStress(neighbor, Math.min(1.0, oldStress + 0.5));
            cursor.next();
        }
    }
}

