/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.HitInfo;

public class HitInfoCache {
    private static final boolean DEBUG = false;
    private static HitInfoCache _instance = null;
    private final Map<HitTypes, HitInfo> _hitInfos = new HashMap<HitTypes, HitInfo>();
    private double _x = Double.NaN;
    private double _y = Double.NaN;
    private Graph2DView _view;
    private int _hitRequests = 0;

    private HitInfoCache() {
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphID graphID;
                GraphID closedGraphID;
                if (HitInfoCache.this._view != null && "graphClosed".equals(evt.getPropertyName()) && (closedGraphID = (GraphID)evt.getNewValue()).equals((Object)(graphID = GraphIDProvider.forGraph((Graph2D)HitInfoCache.this._view.getGraph2D())))) {
                    HitInfoCache.this._view = null;
                    HitInfoCache.this._hitInfos.clear();
                }
            }
        });
    }

    public static synchronized HitInfoCache getDefault() {
        if (_instance == null) {
            _instance = new HitInfoCache();
        }
        return _instance;
    }

    public HitInfo getStandardHitInfo(Graph2DView view, double x, double y) {
        return this.getOrCreateHitInfo(view, x, y, true, 19);
    }

    public HitInfo getOrCreateHitInfo(Graph2DView view, double x, double y, boolean firstHitOnly, int types) {
        if (!view.equals(this._view) || this._x != x || this._y != y) {
            this._hitInfos.clear();
            this._hitRequests = 0;
            this._view = view;
            this._x = x;
            this._y = y;
        }
        ++this._hitRequests;
        HitTypes hitTypes = new HitTypes(types, firstHitOnly);
        return this.getOrCreate(hitTypes);
    }

    private HitInfo getOrCreate(HitTypes hitTypes) {
        HitInfo hitInfo = this._hitInfos.get(hitTypes);
        if (hitInfo == null) {
            hitInfo = this.calcHitInfo(hitTypes);
            this._hitInfos.put(hitTypes, hitInfo);
        }
        return hitInfo;
    }

    private HitInfo calcHitInfo(HitTypes hitTypes) {
        return this._view.getHitInfoFactory().createHitInfo(this._x, this._y, hitTypes.getTypes(), hitTypes.isFirstHitOnly());
    }

    private static class HitTypes {
        private final int _types;
        private final boolean _firstHitOnly;

        public HitTypes(int types, boolean firstHitOnly) {
            this._types = types;
            this._firstHitOnly = firstHitOnly;
        }

        public int getTypes() {
            return this._types;
        }

        public boolean isFirstHitOnly() {
            return this._firstHitOnly;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + this._types;
            hash = 89 * hash + (this._firstHitOnly ? 1 : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HitTypes other = (HitTypes)obj;
            if (this._types != other._types) {
                return false;
            }
            return this._firstHitOnly == other._firstHitOnly;
        }
    }
}

