/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.mode.A;
import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.openide.util.ImageUtilities;

public class GraphViewOptions {
    public static final String PROP_BACKGROUND = "background";
    private static GraphViewOptions _default;
    private PropertyChangeSupport _pcs;
    private Image _background;

    public static synchronized GraphViewOptions getDefault() {
        if (_default == null) {
            _default = new GraphViewOptions();
        }
        return _default;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this._pcs == null) {
            this._pcs = new PropertyChangeSupport(this);
        }
        this._pcs.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this._pcs != null) {
            this._pcs.addPropertyChangeListener(pcl);
        }
    }

    protected void firePropertyChange(String name, Object old, Object nue) {
        if (this._pcs != null) {
            this._pcs.firePropertyChange(name, old, nue);
        }
    }

    public Image getBackground() {
        if (this._background == null) {
            this.loadBackground();
            LicenseManager.A().A(ignored -> this.loadBackground());
        }
        return this._background;
    }

    private void loadBackground() {
        A licenseMode = LicenseManager.A().A(false);
        String filename = licenseMode.B() || licenseMode.E() ? "Background.jpg" : (licenseMode.G() ? "BackgroundKali.jpg" : "BackgroundCE.jpg");
        Image oldBackground = this._background;
        this._background = ImageUtilities.loadImage((String)("com/paterva/maltego/ui/graph/view2d/" + filename), (boolean)true);
        this.firePropertyChange(PROP_BACKGROUND, oldBackground, this._background);
    }
}

