/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.view2d.Graph2DPrintPreviewPanel;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRenderer;
import com.paterva.maltego.ui.graph.view2d.PrintOptions;
import com.paterva.maltego.ui.graph.view2d.PrintOptionsForm;
import com.paterva.maltego.ui.graph.view2d.PrintPreviewCookie;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.Version;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.lang.ref.WeakReference;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.swing.JLabel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.PrintCookie;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DPrinter;
import y.view.Graph2DRenderer;
import y.view.Graph2DView;
import y.view.View;

public class Graph2DViewPrinter
implements PrintCookie,
PrintPreviewCookie {
    WeakReference<Graph2DView> _view;

    public Graph2DViewPrinter(Graph2DView view) {
        this._view = new WeakReference<Graph2DView>(view);
    }

    public void print() {
        try {
            Graph2DPrinter gprinter = this.getGraphPrinter();
            if (Graph2DViewPrinter.showOptions(gprinter)) {
                Graph2DViewPrinter.print(gprinter, PrintOptions.get().getPageFormat());
            }
        }
        finally {
            this.restoreOriginalView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printPreview() {
        try {
            PrinterJob printJob = PrinterJob.getPrinterJob();
            Graph2DPrinter gprinter = this.getGraphPrinter();
            PrintOptions printOptions = PrintOptions.get();
            Graph2DViewPrinter.applyPrintOptions(gprinter, printOptions);
            Graph2DPrintPreviewPanel preview = new Graph2DPrintPreviewPanel(printJob, gprinter, printOptions.getPageFormat());
            DialogDescriptor descriptor = new DialogDescriptor((Object)preview, "Print Preview", true, (Object[])new String[]{"Close"}, null, 0, HelpCtx.DEFAULT_HELP, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
            dialog.setVisible(true);
            printOptions.setPageFormat(preview.getPageFormat());
        }
        finally {
            this.restoreOriginalView();
        }
    }

    public static void print(Graph2DPrinter gprinter, PageFormat pageFormat) {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable((Printable)gprinter);
        PrintRequestAttributeSet attr = Graph2DViewPrinter.getAttributeSetFromPageFormat(pageFormat);
        attr.add(new PageRanges(1, gprinter.getPosterColumns() * gprinter.getPosterRows()));
        if (printJob.printDialog(attr)) {
            try {
                printJob.print(attr);
            }
            catch (PrinterException ex) {
                NotifyDescriptor.Exception nd = new NotifyDescriptor.Exception((Throwable)ex, (Object)"An error occurred while trying to print.");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }

    private static PrintRequestAttributeSet getAttributeSetFromPageFormat(PageFormat pageFormat) {
        HashPrintRequestAttributeSet attr = new HashPrintRequestAttributeSet();
        if (pageFormat.getOrientation() == 0) {
            attr.add(OrientationRequested.LANDSCAPE);
        } else if (pageFormat.getOrientation() == 1) {
            attr.add(OrientationRequested.PORTRAIT);
        } else if (pageFormat.getOrientation() == 2) {
            attr.add(OrientationRequested.REVERSE_LANDSCAPE);
        }
        Paper paper = pageFormat.getPaper();
        attr.add(new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400));
        attr.add(MediaSize.findMedia((float)(paper.getWidth() / 72.0), (float)(paper.getHeight() / 72.0), 25400));
        return attr;
    }

    public static boolean showOptions(Graph2DPrinter gprinter) {
        PrintOptions printOptions = PrintOptions.get();
        PrintOptionsForm printOptionsForm = new PrintOptionsForm();
        printOptionsForm.setPrintOptions(printOptions);
        DialogDescriptor dd = new DialogDescriptor((Object)printOptionsForm, "Print Options");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            printOptionsForm.getPrintOptions(printOptions);
            Graph2DViewPrinter.applyPrintOptions(gprinter, printOptions);
            return true;
        }
        return false;
    }

    private static void applyPrintOptions(Graph2DPrinter gprinter, PrintOptions printOptions) {
        gprinter.setPosterRows(printOptions.getRows());
        gprinter.setPosterColumns(printOptions.getColumns());
        gprinter.setPrintPosterCoords(printOptions.getShowPosterCoords());
        if (printOptions.getClipVisible()) {
            gprinter.setClipType((byte)0);
        } else {
            gprinter.setClipType((byte)1);
        }
        if (printOptions.getShowFooter()) {
            gprinter.setFooterDrawable((Graph2DPrinter.FooterDrawable)new MaltegoFooter());
        } else {
            gprinter.setFooterDrawable(null);
        }
        if (printOptions.getTitle() != null && !printOptions.getTitle().isEmpty()) {
            Graph2DPrinter.DefaultTitleDrawable title = new Graph2DPrinter.DefaultTitleDrawable();
            title.setText(printOptions.getTitle());
            title.setTitleBarColor(null);
            title.setFont(new Font(new JLabel().getFont().getFamily(), 1, 20));
            gprinter.setTitleDrawable((Graph2DPrinter.TitleDrawable)title);
        } else {
            gprinter.setTitleDrawable(null);
        }
    }

    private Graph2DPrinter getGraphPrinter() {
        Graph2DView printingView = this.replaceCurrentWithPrintingView();
        Graph2DPrinter gprinter = new Graph2DPrinter(printingView);
        return gprinter;
    }

    private Graph2DView getView() {
        return this._view != null ? (Graph2DView)this._view.get() : null;
    }

    private Graph2DView replaceCurrentWithPrintingView() {
        Graph2DView view = this.getView();
        if (view == null) {
            return null;
        }
        Graph2D graph = view.getGraph2D();
        Graph2DView printingView = new Graph2DView(graph);
        MaltegoGraph2DRenderer renderer = new MaltegoGraph2DRenderer(printingView, false);
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        renderer.setGraphID(graphID);
        EntityPainterSettings.getDefault().getEntityPainter(graphID).setOptimizationsEnabled(false);
        printingView.setGraph2DRenderer((Graph2DRenderer)renderer);
        printingView.setBounds(view.getBounds());
        printingView.setZoom(view.getZoom());
        printingView.setCenter(view.getCenter().getX(), view.getCenter().getY());
        printingView.setBackgroundRenderer((BackgroundRenderer)new DefaultBackgroundRenderer(printingView));
        graph.setCurrentView((View)printingView);
        return printingView;
    }

    private void restoreOriginalView() {
        Graph2DView view = this.getView();
        if (view != null) {
            Graph2D graph = view.getGraph2D();
            graph.removeView(graph.getCurrentView());
            graph.setCurrentView((View)view);
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
            EntityPainterSettings.getDefault().getEntityPainter(graphID).setOptimizationsEnabled(true);
        }
    }

    private static class MaltegoFooter
    implements Graph2DPrinter.FooterDrawable {
        Image _footerImg = null;
        Rectangle _bounds = null;
        boolean _drawFooter = true;
        final int _textMargin = 2;
        final String _text = "Printed with " + Version.getCurrent().toString(true, false, true);

        public MaltegoFooter() {
            this._footerImg = ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/view2d/PrintFooter.png");
        }

        public void setContext(Graph2DPrinter.PrintContext pc) {
            Graphics2D g2D = pc.getGraphics2D();
            g2D.setFont(this.getFont());
            FontMetrics fm = g2D.getFontMetrics();
            Rectangle2D fontRect = fm.getStringBounds(this._text, g2D);
            Point2D.Double totalSize = new Point2D.Double(fontRect.getWidth() + 2.0 + (double)this._footerImg.getWidth(null), Math.max(fontRect.getHeight() + 2.0, (double)this._footerImg.getHeight(null)));
            Paper paper = pc.getPageFormat().getPaper();
            double paperX = paper.getImageableX();
            double paperY = paper.getImageableY();
            double paperWidth = paper.getImageableWidth();
            double paperHeight = paper.getImageableHeight();
            if (pc.getPageFormat().getOrientation() == 0) {
                paperY = paper.getImageableX();
                paperX = paper.getHeight() - (paper.getImageableY() + paper.getImageableHeight());
                paperWidth = paper.getImageableHeight();
                paperHeight = paper.getImageableWidth();
            } else if (pc.getPageFormat().getOrientation() == 2) {
                paperX = paper.getImageableY();
                paperY = paper.getWidth() - (paper.getImageableX() + paper.getImageableWidth());
                paperWidth = paper.getImageableHeight();
                paperHeight = paper.getImageableWidth();
            }
            this._bounds = new Rectangle((int)(paperX + paperWidth - totalSize.x), (int)(paperY + paperHeight - totalSize.y), (int)totalSize.x, (int)totalSize.y);
            this._drawFooter = pc.getCurrentPageNumber() + 1 == pc.getPosterRows() * pc.getPosterColumns();
        }

        public void paint(Graphics2D g2D) {
            if (this._drawFooter) {
                g2D.drawImage(this._footerImg, this._bounds.x + this._bounds.width - this._footerImg.getWidth(null), this._bounds.y, null);
                g2D.setColor(Color.LIGHT_GRAY);
                g2D.setFont(this.getFont());
                g2D.drawString(this._text, this._bounds.x, this._bounds.y + this._bounds.height - 2);
            }
        }

        public Rectangle getBounds() {
            return this._bounds;
        }

        private Font getFont() {
            return new Font("Dialog", 0, 12);
        }
    }
}

