/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.ui.graph.view2d.ExportCookie;
import com.paterva.maltego.ui.graph.view2d.Graph2DExporter;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import y.view.Graph2DView;

public class Graph2DViewExporter
implements ExportCookie {
    WeakReference<Graph2DView> _view;

    public Graph2DViewExporter(Graph2DView view) {
        this._view = new WeakReference<Graph2DView>(view);
    }

    private Graph2DView getView() {
        return this._view != null ? (Graph2DView)this._view.get() : null;
    }

    @Override
    public Map<String, String> getFileTypes() {
        return Graph2DExporter.getFileTypes();
    }

    @Override
    public void exportToFile(File outImage, int width, boolean wholeGraph, File outHTML) throws IOException {
        Graph2DView view = this.getView();
        if (view != null) {
            boolean transparentBackground = false;
            if (outImage.getPath().toLowerCase().endsWith(".png")) {
                transparentBackground = true;
            }
            Graph2DExporter.exportToFile(outImage, view.getGraph2D(), transparentBackground, width, wholeGraph, outHTML, null);
        } else {
            Logger.getLogger(Graph2DViewExporter.class.getName()).log(Level.SEVERE, "Cannot export graph, view already released.");
        }
    }
}

