/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.entity.api.EntityStringConverter;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.manager.palette.FavouriteEntities;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeNameValidatorLogger;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.nodes.AddAttachmentsAction;
import com.paterva.maltego.ui.graph.nodes.NewGraphOrTempStructureChanges;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainterAnimatorRegistry;
import com.paterva.maltego.util.EntityLimitNotifier;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.dnd.MaltegoGlobalDropHandler;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import y.base.Graph;
import y.base.YCursor;
import y.geom.YDimension;
import y.geom.YRectangle;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.HitInfo;

class Graph2DViewDropSupport
implements DropTargetListener {
    private static final int MINUTES_BETWEEN_CHECKS = 5;
    private static final int MILLIS_BETWEEN_CHECKS = 300000;
    private final Graph2DView _view;
    private Collection<MaltegoEntity> _entities;
    private Map<MaltegoEntity, File> _attachments;
    private long _lastLicenseCheck = 0L;

    public Graph2DViewDropSupport(Graph2DView view) {
        this._view = view;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.onDragOver(dtde);
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        this.onDragOver(dtde);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        this.onDragOver(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this._entities != null) {
            this.removeTempEntities();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.onDrop(dtde);
    }

    private void onDragOver(DropTargetDragEvent dtde) {
        if (Utilities.isMac() || this.updateDragged(dtde.getTransferable(), dtde.getLocation())) {
            dtde.acceptDrag(dtde.getDropAction());
        } else {
            dtde.rejectDrag();
        }
    }

    private boolean updateDragged(Transferable t, Point location) {
        if (MaltegoGlobalDropHandler.getInstance().allowDrop(t)) {
            return true;
        }
        Node node = NodeTransfer.node((Transferable)t, (int)1);
        boolean acceptDrag = false;
        Collection<MaltegoEntity> newEntities = null;
        if (node != null) {
            MaltegoEntity entity;
            if (this._entities == null && (entity = this.createEntity(node)) != null) {
                newEntities = new ArrayList<MaltegoEntity>();
                newEntities.add(entity);
            }
        } else if (this.hasHitNode(this.getHitInfo(location))) {
            boolean stateChanged = false;
            if (this._entities != null) {
                this.removeTempEntities();
                stateChanged = true;
            }
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                if (this.getFiles(t) != null) {
                    if (stateChanged) {
                        StatusDisplayer.getDefault().setStatusText("Drop to attach files...");
                    }
                    acceptDrag = true;
                }
            } else if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                if (stateChanged) {
                    StatusDisplayer.getDefault().setStatusText("Drop to append note...");
                }
                acceptDrag = true;
            }
        } else if (this._entities == null || this._entities.isEmpty()) {
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                newEntities = this.stringFlavorToEntities(t);
            } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                newEntities = this.filesFlavorToEntities(t);
            }
            if (newEntities != null) {
                StatusDisplayer.getDefault().setStatusText("Drop to create new entities...");
            }
        }
        if (newEntities != null) {
            GraphID graphID = this.getGraphID();
            MainEntityPainterAnimatorRegistry.allowModifications = false;
            NewGraphOrTempStructureChanges.addEntities(graphID, newEntities, true, false);
            MainEntityPainterAnimatorRegistry.allowModifications = true;
            this.updateAttachments(newEntities);
            this.select(newEntities);
            this._entities = newEntities;
        }
        if (this._entities != null && !this._entities.isEmpty()) {
            acceptDrag = true;
            this.updateCenters(location);
        }
        return acceptDrag;
    }

    private GraphID getGraphID() {
        return GraphViewManager.getDefault().getGraphID(this._view.getGraph2D());
    }

    private GraphStore getGraphStore() {
        GraphStore graphStore = null;
        try {
            GraphID graphID = this.getGraphID();
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return graphStore;
    }

    private void updateAttachments(Collection<MaltegoEntity> entities) {
        for (MaltegoEntity entity : entities) {
            File file;
            if (this._attachments == null || (file = this._attachments.get(entity)) == null) continue;
            this._attachments.remove(entity);
            this._attachments.put(entity, file);
        }
    }

    private void select(Collection<MaltegoEntity> entities) {
        GraphID graphID = this.getGraphID();
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set ids = GraphStoreHelper.getIds(entities);
        selection.setSelectedModelEntities((Collection)ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDrop(DropTargetDropEvent dtde) {
        Graph2D graph2D;
        if (!this.validateLicense()) {
            if (this._entities != null) {
                this.removeTempEntities();
            }
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"You have to activate Maltego before you can create a graph!", 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            return;
        }
        com.paterva.maltego.licensing.mode.A licenseMode = LicenseManager.A().A(false);
        if (!(licenseMode.B() && licenseMode.Q() || (graph2D = this._view.getGraph2D()).N() <= A.C())) {
            if (this._entities != null) {
                this.removeTempEntities();
            }
            for (EntityLimitNotifier notifier : Lookup.getDefault().lookupAll(EntityLimitNotifier.class)) {
                notifier.notifyLimitExceeded();
            }
            return;
        }
        graph2D = this._view.getGraph2D();
        dtde.acceptDrop(3);
        Transferable t = dtde.getTransferable();
        boolean acceptDrop = true;
        if (Utilities.isMac()) {
            acceptDrop = this.updateDragged(t, dtde.getLocation());
        }
        if (acceptDrop && MaltegoGlobalDropHandler.getInstance().handleDrop(t)) {
            return;
        }
        if (acceptDrop && this._entities != null) {
            FavouriteEntities.getInstance().addMaltegoEntities(this._entities);
            StatusDisplayer.getDefault().setStatusText(this._entities.size() + " entities created");
            if (this._attachments != null) {
                AddAttachmentsAction action = (AddAttachmentsAction)SystemAction.get(AddAttachmentsAction.class);
                action.perform(this._attachments);
            }
            Graph2D modelGraph = graph2D;
            String description = "%s " + GraphTransactionHelper.getDescriptionForEntities((Graph)modelGraph, this._entities, true);
            SimilarStrings descriptions = new SimilarStrings(description, "Drag & drop", "Delete");
            Set entityIDs = GraphStoreHelper.getIds(this._entities);
            Map<String, Map<EntityID, Point>> allCenters = GraphPositionAndPathHelper.getAllCenters((Graph)modelGraph, (Set<EntityID>)entityIDs);
            GraphTransaction transaction = GraphTransactions.addEntities(this._entities, allCenters, true);
            GraphTransactionBatch batch = new GraphTransactionBatch(descriptions, true, transaction);
            GraphID graphID = GraphIDProvider.forGraph((Graph)modelGraph);
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                graphStore.beginUpdate();
                try {
                    Map<EntityID, YRectangle> cachedRects = this.removeTempEntities();
                    GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
                    this.restorePositions(graph2D, cachedRects);
                }
                finally {
                    graphStore.endUpdate();
                }
                GraphSelection.forGraph((GraphID)graphID).setSelectedModelEntities((Collection)entityIDs);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this._entities = null;
            this._attachments = null;
            PlaceLabelsAction action = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
            if (action != null) {
                action.perform(graph2D, null);
            }
        } else {
            MaltegoEntity entity = null;
            HitInfo hitInfo = this.getHitInfo(dtde.getLocation());
            if (hitInfo.hasHitNodes()) {
                entity = this.nodeToEntity(hitInfo.getHitNode());
            }
            if (entity != null) {
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    this.appendNote(t, entity);
                    StatusDisplayer.getDefault().setStatusText("Note added");
                } else if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    int count = this.dropFiles(t, entity);
                    StatusDisplayer.getDefault().setStatusText(count + " files attached");
                }
            }
        }
        dtde.dropComplete(true);
        GraphEditorRegistry.getDefault().getTopmost().requestActive();
        this._view.requestFocusInWindow();
    }

    private void restorePositions(Graph2D graph2D, Map<EntityID, YRectangle> cachedRects) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
        for (Map.Entry<EntityID, YRectangle> entry : cachedRects.entrySet()) {
            EntityID entityID = entry.getKey();
            YRectangle rectangle = entry.getValue();
            y.base.Node node = wrapper.node(entityID);
            graph2D.setSize(node, (YDimension)rectangle);
            graph2D.setLocation(node, rectangle.getLocation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCenters(Point p) {
        Graph2D graph2D = this._view.getGraph2D();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
        wrapper.beginUpdate();
        try {
            double x = this._view.toWorldCoordX(p.x);
            double y = this._view.toWorldCoordY(p.y);
            Point2D.Double[] pos = this.calculateCenters(this._entities.size(), x, y);
            int i = 0;
            for (MaltegoEntity entity : this._entities) {
                y.base.Node yNode = wrapper.node((EntityID)entity.getID());
                graph2D.setCenter(yNode, pos[i].x, pos[i].y);
                ++i;
            }
        }
        finally {
            wrapper.endUpdate();
            this._view.updateView();
        }
    }

    private void applyCenters(Map<EntityID, Point> centers) {
        GraphStore graphStore = this.getGraphStore();
        GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
        try {
            layoutWriter.setCenters(centers);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Collection<MaltegoEntity> stringFlavorToEntities(Transferable t) {
        Collection entities = null;
        try {
            String text = (String)t.getTransferData(DataFlavor.stringFlavor);
            EntityStringConverter converter = (EntityStringConverter)Lookup.getDefault().lookup(EntityStringConverter.class);
            entities = converter.convert(text);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entities;
    }

    private List<MaltegoEntity> filesFlavorToEntities(Transferable t) {
        try {
            List<File> fileList = this.getFiles(t);
            if (fileList != null) {
                ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>(fileList.size());
                this._attachments = new HashMap<MaltegoEntity, File>(fileList.size());
                for (File file : fileList) {
                    MaltegoEntity entity = this.createDocumentEntity(file);
                    entities.add(entity);
                    this._attachments.put(entity, file);
                }
                return entities;
            }
        }
        catch (TypeInstantiationException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private MaltegoEntity createDocumentEntity(File file) throws IOException, TypeInstantiationException {
        GraphID graphID = this.getGraphID();
        MaltegoEntity entity = (MaltegoEntity)EntityFactory.forGraphID((GraphID)graphID).createInstance("maltego.File", false, true);
        PropertyDescriptor pd = entity.getProperties().get("description");
        if (pd == null) {
            pd = new DisplayDescriptor(String.class, "description", "Description");
            entity.addProperty(pd);
            entity.setValueProperty(pd);
            entity.setDisplayValueExpression(pd.getName());
        }
        entity.setValue(pd, (Object)file.getName());
        entity.setNotes(file.getCanonicalPath());
        return entity;
    }

    private boolean hasHitNode(HitInfo hitInfo) {
        if (hitInfo.hasHitNodes()) {
            if (this._entities == null || this._entities.isEmpty()) {
                return true;
            }
            Graph2D graph2D = this._view.getGraph2D();
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
            YCursor nodes = hitInfo.hitNodes();
            while (nodes.ok()) {
                Object currentNode = nodes.current();
                if (currentNode instanceof y.base.Node) {
                    y.base.Node node = (y.base.Node)currentNode;
                    boolean found = false;
                    for (MaltegoEntity entity : this._entities) {
                        if (!node.equals(wrapper.node((EntityID)entity.getID()))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return true;
                    }
                }
                nodes.next();
            }
        }
        return false;
    }

    private Map<EntityID, YRectangle> removeTempEntities() {
        HashMap<EntityID, YRectangle> rectangles = new HashMap<EntityID, YRectangle>();
        Graph2D graph2D = this._view.getGraph2D();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
        for (MaltegoEntity entity : this._entities) {
            EntityID entityID = (EntityID)entity.getID();
            y.base.Node node = wrapper.node(entityID);
            YRectangle rectangle = graph2D.getRectangle(node);
            rectangles.put(entityID, rectangle);
        }
        GraphStoreWriter.removeEntities((GraphID)this.getGraphID(), (Collection)GraphStoreHelper.getIds(this._entities));
        this._entities = null;
        this._attachments = null;
        return rectangles;
    }

    private void appendNote(Transferable t, MaltegoEntity entity) {
        try {
            String oldNotes;
            String text = (String)t.getTransferData(DataFlavor.stringFlavor);
            String newNotes = oldNotes = entity.getNotes();
            newNotes = newNotes == null || newNotes.isEmpty() ? text : newNotes + "\n" + text;
            if (!Utilities.compareObjects((Object)oldNotes, (Object)newNotes)) {
                GraphTransactionHelper.doChangeNotes((Graph)this._view.getGraph2D(), Collections.singleton(entity), newNotes, entity.isShowNotes());
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private int dropFiles(Transferable t, MaltegoEntity entity) {
        List<File> fileList = this.getFiles(t);
        if (fileList != null && fileList.size() > 0) {
            MaltegoEntity entityAfter = entity.createClone();
            AddAttachmentsAction action = (AddAttachmentsAction)SystemAction.get(AddAttachmentsAction.class);
            action.perform(entityAfter, fileList);
            Graph2D graph2D = this._view.getGraph2D();
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
            String description = "%s ";
            int size = fileList.size();
            description = size > 1 ? description + size + " attachments" : description + "attachment";
            description = description + " %s " + GraphTransactionHelper.getDescriptionForEntities(graphID, Collections.singleton(entityAfter), true);
            SimilarStrings descriptions = new SimilarStrings(description, new Object[]{"Add", "to"}, new Object[]{"Remove", "from"});
            if (!entity.isCopy((MaltegoPart)entityAfter)) {
                ModifiedHelper.updateModified(GraphUser.getUser(graphID), (MaltegoPart<? extends Guid>)entityAfter);
            }
            GraphTransactionHelper.doEntityChanged(graphID, descriptions, entity, entityAfter);
            return size;
        }
        return 0;
    }

    private boolean validateLicense() {
        long time = System.currentTimeMillis();
        long delta = time - this._lastLicenseCheck;
        if (delta > 300000L) {
            this._lastLicenseCheck = time;
            return LicenseManager.A().A(false, false);
        }
        return true;
    }

    private MaltegoEntity nodeToEntity(y.base.Node yNode) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this._view.getGraph2D());
        return wrapper.entity(yNode);
    }

    private HitInfo getHitInfo(Point point) {
        HitInfo hitInfo = HitInfoCache.getDefault().getOrCreateHitInfo(this._view, this._view.toWorldCoordX(point.x), this._view.toWorldCoordY(point.y), false, 1);
        return hitInfo;
    }

    private MaltegoEntity createEntity(Node node) {
        MaltegoEntitySpec spec = (MaltegoEntitySpec)node.getLookup().lookup(MaltegoEntitySpec.class);
        MaltegoEntity entity = null;
        try {
            GraphID graphID = this.getGraphID();
            entity = EntityFactory.forGraphID((GraphID)graphID).createInstance(spec, true, true);
            this.checkPropertyNames(spec, graphID);
        }
        catch (TypeInstantiationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return entity;
    }

    private void checkPropertyNames(MaltegoEntitySpec spec, GraphID graphID) {
        TypeNameValidatorLogger typeNameLogger = TypeNameValidatorLogger.getDefault();
        String entityDisplayName = spec.getDisplayName();
        String typeName = spec.getTypeName();
        DisplayDescriptorCollection properties = spec.getProperties();
        properties.stream().map(pd -> pd.getName()).forEachOrdered(propertyName -> typeNameLogger.handleIfInvalid(entityDisplayName, typeName, propertyName, graphID == null ? null : graphID.toString()));
    }

    private List<File> getFiles(Transferable t) {
        try {
            List fileList = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
            fileList = FileUtilities.removeDirectories((List)fileList);
            if (fileList != null && !fileList.isEmpty()) {
                return fileList;
            }
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    private Point2D.Double[] calculateCenters(int count, double baseX, double baseY) {
        int spacing = 120;
        int columns = (int)Math.ceil(Math.sqrt(count));
        int index = 0;
        Point2D.Double[] points = new Point2D.Double[count];
        double y = baseY;
        for (int row = 0; row < columns; ++row) {
            double x = baseX;
            for (int col = 0; col < columns; ++col) {
                if (index < points.length) {
                    points[index] = new Point2D.Double(x, y);
                }
                ++index;
                x += 120.0;
            }
            y += 120.0;
        }
        return points;
    }
}

