/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.view2d.MaltegoGraph2DRenderer;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.ui.image.TileViewer;
import com.paterva.maltego.util.ui.progress.ProgressController;
import com.paterva.maltego.util.yfiles.GIFIOHandlerJai;
import com.paterva.maltego.util.yfiles.IOHandlerJai;
import com.paterva.maltego.util.yfiles.ImageIoOutputHandlerJai;
import com.paterva.maltego.util.yfiles.JPGIOHandlerJai;
import com.paterva.maltego.util.yfiles.TiledImageOutputHandlerJai;
import gov.nist.isg.pyramidio.ProgressCallback;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import org.apache.commons.io.FilenameUtils;
import y.io.GIFIOHandler;
import y.io.IOHandler;
import y.io.ImageIoOutputHandler;
import y.io.ImageOutputHandler;
import y.io.JPGIOHandler;
import y.io.ViewPortConfigurator;
import y.view.BackgroundRenderer;
import y.view.DefaultBackgroundRenderer;
import y.view.Graph2D;
import y.view.Graph2DRenderer;
import y.view.Graph2DView;
import y.view.View;

public class Graph2DExporter {
    public static final int IMAGE_STREAM_THRESHOLD = 15000;
    private static final Logger LOG = Logger.getLogger(Graph2DExporter.class.getName());
    private static final LinkedHashMap<String, String> FILE_TYPES = new LinkedHashMap();

    private Graph2DExporter() {
    }

    public static LinkedHashMap<String, String> getFileTypes() {
        return FILE_TYPES;
    }

    public static boolean exportToFile(File outImage, Graph2D graph, boolean transparentBackground, int width, boolean wholeGraph, File outHTML, ProgressController controller) throws IOException {
        GIFIOHandler ioh;
        String path = outImage.getPath().toLowerCase();
        if (path.endsWith(".gif")) {
            ioh = new GIFIOHandler();
        } else if (path.endsWith(".jpg")) {
            ioh = new JPGIOHandler();
            ((JPGIOHandler)ioh).setQuality(0.9f);
        } else {
            ioh = Graph2DExporter.createOutputHandler(FileUtilities.getFileExtension((File)outImage).toLowerCase());
        }
        if (ioh != null) {
            return Graph2DExporter.exportGraphToImageFileFormat(graph, (ImageOutputHandler)ioh, outImage, transparentBackground, width, wholeGraph, outHTML, controller);
        }
        throw new IOException("Unable to export the graph. The given file format is not supported.");
    }

    private static ImageOutputHandler createOutputHandler(String extension) {
        ImageWriter iw;
        Iterator<ImageWriter> it = ImageIO.getImageWritersBySuffix(extension);
        ImageWriter imageWriter = iw = it.hasNext() ? it.next() : null;
        if (iw == null) {
            return null;
        }
        ImageIoOutputHandler ioh = new ImageIoOutputHandler(iw);
        if ("png".equalsIgnoreCase(extension)) {
            ioh.setTransparencyEnabled(true);
        }
        return ioh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean exportGraphToImageFileFormat(Graph2D graph, ImageOutputHandler ioh, File outImage, boolean transparentBackground, int width, boolean wholeGraph, File outHTML, ProgressController controller) throws IOException {
        boolean exceedsMaxJpeg;
        Graph2DView originalView = Graph2DExporter.replaceCurrentWithExportView(graph, ioh, wholeGraph);
        Graph2DExporter.configureExportView((Graph2DView)graph.getCurrentView(), transparentBackground, width, wholeGraph);
        Component component = graph.getCurrentView().getComponent();
        long viewWidth = component.getWidth();
        long viewHeight = component.getHeight();
        long sumPixels = viewWidth * viewHeight;
        int maxJpegDimension = 43000;
        int sumLimitJpeg = Math.min(maxJpegDimension * maxJpegDimension, Integer.MAX_VALUE);
        boolean bl = exceedsMaxJpeg = sumPixels > (long)sumLimitJpeg || viewHeight > 65500L;
        if (exceedsMaxJpeg && "jpg".equalsIgnoreCase(FileUtilities.getFileExtension((File)outImage))) {
            throw new IOException("For JPG images the maximum pixel count is an image of roughly " + maxJpegDimension + " x " + maxJpegDimension + " px, or a height of 65500 pixels. Use PNG as the output format for larger images.");
        }
        int widthLimit = 15000;
        int sumLimit = Math.min(widthLimit * widthLimit, Integer.MAX_VALUE);
        boolean exceedsMaxGeneral = sumPixels > (long)sumLimit || viewWidth > (long)widthLimit;
        try {
            com.paterva.maltego.util.jai.ProgressCallback cb = (task, message, progress) -> {
                if (controller != null && "EXPORT_IMAGE".equals(task)) {
                    controller.progress(message, progress);
                }
            };
            Graph2DExporter.writeGraphToFile(graph, (IOHandler)ioh, outImage, exceedsMaxGeneral, cb);
        }
        finally {
            Graph2DExporter.restoreOriginalView(graph, originalView);
            if (outHTML != null && outImage.isFile()) {
                String baseName = FilenameUtils.getBaseName((String)outHTML.getName());
                if (controller != null) {
                    Graph2DExporter.updateProgress(controller, "Creating Tiled Browser Image", 101);
                }
                AtomicInteger progressUnit = new AtomicInteger(100);
                ProgressCallback cb = (task, message, progress) -> {
                    int stepProgress = progress + 100;
                    if (controller != null && "DZI_IMAGE".equals(task) && stepProgress > progressUnit.get() && stepProgress < 199) {
                        progressUnit.set(stepProgress);
                        Graph2DExporter.updateProgress(controller, message, stepProgress);
                    }
                };
                int maxZoom = TileViewer.createDeepZoomImage((File)outImage, (File)outHTML.getParentFile(), (String)baseName, (boolean)exceedsMaxGeneral, (ProgressCallback)cb);
                if (maxZoom > -1) {
                    String imagesFolderName = baseName + "_files";
                    TileViewer.createLeafletDeepZoomHTML((File)outHTML, (String)imagesFolderName, (int)maxZoom, (int)((int)viewWidth), (int)((int)viewHeight));
                    if (controller != null) {
                        Graph2DExporter.updateProgress(controller, "Finished creating Tiled Browser Image", 199);
                    }
                }
            }
            if (controller != null) {
                Graph2DExporter.updateProgress(controller, "Finished exporting graph as image", 200);
            }
        }
        return true;
    }

    private static void updateProgress(ProgressController controller, String message, int progress) {
        LOG.log(Level.INFO, "{0}: {1}", new Object[]{message, progress});
        controller.progress(message, progress);
    }

    private static void writeGraphToFile(Graph2D graph, IOHandler ioh, File outImageFile, boolean exceedsMax, com.paterva.maltego.util.jai.ProgressCallback cb) throws IOException {
        if (cb != null) {
            Graph2DExporter.updateProgress(cb, "Starting graph export as image", 0);
        }
        if (exceedsMax) {
            String extension = FileUtilities.getFileExtension((File)outImageFile).toLowerCase();
            GIFIOHandlerJai iohJai = null;
            if (ioh instanceof GIFIOHandler) {
                iohJai = new GIFIOHandlerJai();
            } else if (ioh instanceof JPGIOHandler) {
                iohJai = new JPGIOHandlerJai();
                ((JPGIOHandlerJai)iohJai).setQuality(((JPGIOHandler)ioh).getQuality());
            } else if (ioh instanceof ImageIoOutputHandler) {
                iohJai = new ImageIoOutputHandlerJai(((ImageIoOutputHandler)ioh).getImageWriter());
                if ("png".equalsIgnoreCase(extension)) {
                    ((ImageIoOutputHandlerJai)iohJai).setTransparencyEnabled(true);
                }
            }
            if (iohJai == null) {
                throw new IOException("Unable to export the graph. The given file format is not supported.");
            }
            TiledImageOutputHandlerJai tioh = new TiledImageOutputHandlerJai((IOHandlerJai)iohJai, 5000, 256);
            tioh.write(graph, outImageFile, extension, cb);
        } else {
            ioh.write(graph, outImageFile.getPath());
        }
        if (cb != null) {
            Graph2DExporter.updateProgress(cb, "Finished image save", 100);
        }
    }

    private static void updateProgress(com.paterva.maltego.util.jai.ProgressCallback cb, String message, int progress) {
        LOG.log(Level.INFO, "{0}: {1}", new Object[]{message, progress});
        cb.progress("EXPORT_IMAGE", message, progress);
    }

    private static Graph2DView replaceCurrentWithExportView(Graph2D graph, ImageOutputHandler ioh, boolean wholeGraph) {
        Graph2DView originalView = (Graph2DView)graph.getCurrentView();
        Graph2DView exportView = ioh.createDefaultGraph2DView(graph);
        if (!wholeGraph) {
            double margin = 0.0;
            Dimension canvasSize = originalView.getCanvasSize();
            exportView.setSize(canvasSize);
            exportView.setPreferredSize(canvasSize);
            Rectangle visibleRect = originalView.getVisibleRect();
            exportView.zoomToArea((double)visibleRect.x - margin, (double)visibleRect.y - margin, (double)visibleRect.width + 2.0 * margin, (double)visibleRect.height + 2.0 * margin);
        }
        MaltegoGraph2DRenderer renderer = new MaltegoGraph2DRenderer(exportView, false);
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        renderer.setGraphID(graphID);
        EntityPainterSettings.getDefault().getEntityPainter(graphID).setOptimizationsEnabled(false);
        exportView.setGraph2DRenderer((Graph2DRenderer)renderer);
        graph.setCurrentView((View)exportView);
        return originalView;
    }

    private static void restoreOriginalView(Graph2D graph, Graph2DView originalView) {
        graph.removeView(graph.getCurrentView());
        graph.setCurrentView((View)originalView);
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph);
        EntityPainterSettings.getDefault().getEntityPainter(graphID).setOptimizationsEnabled(true);
    }

    private static void configureExportView(Graph2DView exportView, boolean transparentBackground, int width, boolean wholeGraph) {
        if (transparentBackground) {
            DefaultBackgroundRenderer transparentBackgroundR = new DefaultBackgroundRenderer(exportView);
            transparentBackgroundR.setColor(new Color(255, 255, 255, 0));
            exportView.setBackgroundRenderer((BackgroundRenderer)transparentBackgroundR);
        }
        ViewPortConfigurator vpc = new ViewPortConfigurator();
        if (wholeGraph) {
            vpc.setGraph2D(exportView.getGraph2D());
            vpc.setClipType(ViewPortConfigurator.CLIP_GRAPH);
        } else {
            vpc.setGraph2DView(exportView);
            vpc.setClipType(ViewPortConfigurator.CLIP_VIEW);
        }
        vpc.setSizeType(ViewPortConfigurator.SIZE_USE_CUSTOM_WIDTH);
        vpc.setCustomWidth(width);
        vpc.configure(exportView);
    }

    static {
        FILE_TYPES.put("png", "Portable Network Graphics (*.png)");
        FILE_TYPES.put("jpg", "Joint Photographic Experts Group (*.jpg)");
        FILE_TYPES.put("bmp", "Windows & OS/2 bitmap (*.bmp)");
    }
}

