/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityConverter;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.TransactionBatchFactory;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeRenderInfo;
import com.paterva.maltego.ui.graph.view2d.EditableNodeLabel;
import com.paterva.maltego.ui.graph.view2d.EntityLabelMax;
import com.paterva.maltego.ui.graph.view2d.EntityLabelOptions;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.NodeLabelUtils;
import com.paterva.maltego.ui.graph.view2d.PopupAwareEditMode;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.fonts.FontFallbackStringPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import y.base.Graph;
import y.geom.OrientedRectangle;
import y.geom.YPoint;
import y.view.Graph2D;
import y.view.YLabel;

public class EntityValueLabel
extends EditableNodeLabel
implements PopupAwareEditMode.EditableLabel {
    private static final Logger LOG = Logger.getLogger(EntityValueLabel.class.getName());

    public EntityValueLabel(LightweightEntityRealizer realizer) {
        super(realizer);
    }

    @Override
    public final void updateText() {
        LightweightEntityRealizer realizer = this.getEntityRealizer();
        MaltegoEntity entitySkeleton = realizer.getEntitySkeleton();
        if (entitySkeleton != null) {
            String text;
            boolean editing = this.isEditing();
            String string = text = editing ? entitySkeleton.getValueString() : entitySkeleton.getDisplayString();
            if (text == null) {
                text = "";
            }
            if (!editing && text.trim().isEmpty()) {
                text = "<empty>";
            }
            this.setTextInternal(text);
            this.setEditable(!entitySkeleton.isLabelReadonly());
        } else {
            CollectionNodeRenderInfo collectionNodeInfo = realizer.getCollectionNodeInfo();
            if (collectionNodeInfo != null) {
                this.setTextInternal(Integer.toString(collectionNodeInfo.getEntityCount()));
            }
            this.setEditable(false);
        }
    }

    private PropertyDescriptor getValueProperty(MaltegoEntity entity) {
        EntityRegistry registry;
        if (entity != null && (registry = this.getRegistry()) != null) {
            return InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entity, (boolean)false);
        }
        return null;
    }

    public void setText(String text) {
        this.setTextInternal(text);
        LightweightEntityRealizer realizer = this.getEntityRealizer();
        if (realizer == null) {
            return;
        }
        MaltegoEntity entity = null;
        try {
            GraphEntity graphEntity = realizer.getGraphEntity();
            GraphDataStoreReader dataStoreReader = GraphStoreHelper.getDataStoreReader((GraphID)graphEntity.getGraphID());
            entity = dataStoreReader.getEntity((EntityID)graphEntity.getID());
        }
        catch (GraphStoreException graphEntity) {
            // empty catch block
        }
        if (entity != null) {
            EntityRegistry registry = this.getRegistry();
            String beforeStr = InheritanceHelper.getDisplayString((SpecRegistry)registry, entity);
            PropertyDescriptor pd = this.getValueProperty(entity);
            if (pd != null) {
                PropertyDescriptor valuePd;
                EntityConverter converter;
                boolean converted = false;
                MaltegoEntity entityBefore = entity.createClone();
                MaltegoEntity entityAfter = entity.createClone();
                if (registry != null && (converter = InheritanceHelper.getConverter((EntityRegistry)registry, (MaltegoEntity)entityAfter, (String)text, (PropertyDescriptor)(valuePd = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entityAfter, (boolean)true)))) != null) {
                    pd = valuePd;
                    try {
                        converter.convertFrom((Object)text, entityAfter, pd, true);
                        converted = true;
                    }
                    catch (IllegalArgumentException e) {
                        NormalException.logStackTrace((Throwable)e);
                    }
                }
                if (!converted) {
                    try {
                        Object value = Converter.convertFrom((String)text, (Class)pd.getType());
                        if (value != null) {
                            entityAfter.setValue(pd, value, true, true);
                            converted = true;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        NormalException.logStackTrace((Throwable)e);
                    }
                }
                if (converted) {
                    String afterStr = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)entityAfter);
                    String description = "Change entity value from \"%s\" to \"%s\"";
                    beforeStr = beforeStr.replaceAll("\n", " ").trim();
                    afterStr = afterStr.replaceAll("\n", " ").trim();
                    int maxLength = EntityLabelOptions.getMaxLength(EntityLabelMax.VALUE);
                    beforeStr = StringUtilities.chomp((String)beforeStr, (int)maxLength);
                    afterStr = StringUtilities.chomp((String)afterStr, (int)maxLength);
                    Object[] doArgs = new Object[]{beforeStr, afterStr};
                    Object[] undoArgs = new Object[]{afterStr, beforeStr};
                    SimilarStrings descriptions = new SimilarStrings(description, doArgs, undoArgs);
                    if (!entityAfter.isCopy((MaltegoPart)entityBefore)) {
                        ModifiedHelper.updateModified(GraphUser.getUser((Graph)this.getGraph2D()), (MaltegoPart<? extends Guid>)entityAfter);
                        GraphTransactionBatch batch = TransactionBatchFactory.createEntityUpdateBatch(descriptions, entityBefore, entityAfter);
                        if (!batch.isEmpty()) {
                            GraphID graphID = GraphIDProvider.forGraph((Graph2D)this.getGraph2D());
                            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
                        }
                    }
                } else {
                    this.setTextInternal(beforeStr);
                }
            }
        }
    }

    private EntityRegistry getRegistry() {
        Graph2D graph2D = this.getGraph2D();
        return EntityRegistry.forGraph((Graph)graph2D);
    }

    private void setTextInternal(String text) {
        LOG.log(Level.FINE, "text = {0}", text);
        if (!this.isEditing() && EntityLabelOptions.isEnabled(EntityLabelMax.VALUE)) {
            text = StringUtilities.chompLines((String)text, (int)EntityLabelOptions.getMaxLength(EntityLabelMax.VALUE));
            LOG.log(Level.FINE, "text (truncated) = {0}", text);
        }
        super.setText(text);
    }

    protected void paintContent(Graphics2D gd, double x, double y, double width, double height) {
        String text = this.getText();
        YPoint textLocation = this.getTextLocation();
        Font font = this.getFont();
        float textX = (float)textLocation.x;
        float textY = (float)(textLocation.y + (double)font.getSize2D());
        Color color = this.getTextColor();
        FontFallbackStringPainter.paint((Graphics2D)gd, (String)text, (Font)font, (Color)color, (float)textX, (float)textY, (boolean)true);
        if (LOG.isLoggable(Level.FINE)) {
            gd.setStroke(new BasicStroke());
            gd.setColor(Color.CYAN);
            gd.drawRect((int)x, (int)y, (int)(width - 1.0), (int)(height - 1.0));
        }
    }

    public void calculateSize(FontRenderContext frc) {
        boolean original = false;
        if (original) {
            super.calculateSize(frc);
        } else {
            Rectangle2D size = NodeLabelUtils.calculateFontFallbackSize((YLabel)this, frc);
            this.setContentSize(size.getWidth(), size.getHeight());
            this.sizeDirty = false;
        }
    }

    public OrientedRectangle getTextBox() {
        return new OrientedRectangle(0.0, 0.0, this.getContentWidth(), this.getContentHeight());
    }
}

