/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.EntityColorFactory;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeRenderInfo;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.NodeRealizerSettings;
import com.paterva.maltego.ui.graph.view2d.painter.MainPaintUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.laf.Colors;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Set;
import javax.swing.UIManager;
import org.openide.util.Exceptions;
import y.view.AbstractCustomNodePainter;
import y.view.NodeRealizer;

public class EntitySloppyPainter
extends AbstractCustomNodePainter {
    public static final double DRAW_PLAIN_ZOOM = 0.1;
    public static final int BALL_COLLECTION_NODES_ROUND_RECT_ARC = 12;
    public static final boolean DRAW_BALL_COLLECTION_NODES_RECT = false;
    private static final int SELECTION_BORDER = 14;
    private static BufferedImage _cachedImage = null;
    private static int _cachedImageSize = 0;
    private static Color _cachedImageColor = null;
    private static int _cachedBookmark = -1;
    private static boolean _cachedHasNotes = false;
    private static boolean _collectionNode = false;
    private static boolean _cachedIsPartial = false;
    private static boolean _cachedSelected = false;
    private static final EntityColorFactory _colorFactory = EntityColorFactory.getDefault();
    private static int _painted = 0;
    private boolean _paintAnimations;
    private boolean _fixedSize = true;

    protected void setFixedSize(boolean fixedSize) {
        this._fixedSize = fixedSize;
    }

    public void onPaintStart() {
        _painted = 0;
    }

    public void setPaintAnimations(boolean paintAnimations) {
        this._paintAnimations = paintAnimations;
    }

    protected void paintNode(NodeRealizer nr, Graphics2D g2D, boolean sloppy) {
        if (sloppy) {
            this.paintSloppy(nr, g2D);
        } else {
            this.paint(nr, g2D);
        }
    }

    public void paintSloppy(NodeRealizer nr, Graphics2D g2D) {
        LightweightEntityRealizer realizer = (LightweightEntityRealizer)nr;
        float animationFactor = -1.0f;
        if (this._paintAnimations) {
            Map<String, Object> changes = MainPaintUtils.getAnimationFactorAndChangeType(realizer);
            animationFactor = ((Float)changes.get("factor")).floatValue();
        }
        AffineTransform transform = g2D.getTransform();
        double scale = transform.getScaleX();
        int nodeCount = nr.getNode().getGraph().nodeCount();
        ++_painted;
        GraphEntity graphEntity = (GraphEntity)realizer.getUserData();
        GraphID graphID = graphEntity.getGraphID();
        EntityID entityID = (EntityID)graphEntity.getID();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        String entityType = "maltego.Unknown";
        boolean isCollectionNode = wrapper.isCollectionNode(entityID);
        EntityID typeEntityID = null;
        if (isCollectionNode) {
            CollectionNodeRenderInfo collectionNodeInfo = realizer.getCollectionNodeInfo();
            if (collectionNodeInfo != null) {
                entityType = collectionNodeInfo.getType();
            } else {
                try {
                    GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
                    Set modelEntities = view.getModelViewMappings().getModelEntities(entityID);
                    typeEntityID = (EntityID)modelEntities.iterator().next();
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        } else {
            typeEntityID = entityID;
        }
        if (typeEntityID != null) {
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
                GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
                entityType = dataReader.getEntityType(typeEntityID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        double x = nr.getX();
        double y = nr.getY();
        double width = nr.getWidth();
        double radius = this._fixedSize ? 104.0 : this.getRadius(nr);
        x = x + width / 2.0 - radius / 2.0;
        Color c = this.getColor(nr, entityType);
        boolean isSelected = nr.isSelected();
        double actualPixelRadius = radius * scale;
        if (actualPixelRadius < 3.0) {
            if (isSelected) {
                c = this.getSelectedColor(c);
            }
            g2D.setColor(c);
            g2D.fillRect((int)x, (int)y, (int)radius, (int)radius);
        } else {
            boolean drawPlain = scale < 0.1;
            int bookmark = -1;
            String notes = null;
            if (!drawPlain) {
                try {
                    if (!isCollectionNode) {
                        EntitySkeletonProvider skeletonProvider = SkeletonProviders.entitiesForGraph((GraphID)graphID);
                        MaltegoEntity entitySkeleton = skeletonProvider.getEntitySkeleton(entityID);
                        bookmark = entitySkeleton.getBookmark();
                        notes = entitySkeleton.getNotes();
                    }
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            boolean hasNotes = !StringUtilities.isNullOrEmpty(notes);
            int h = (int)radius;
            int imageSize = h + 2;
            if (isSelected) {
                imageSize += 14;
            }
            boolean isPartial = CollectionNodeUtils.getSelectionState(nr) == SelectionState.PARTIAL;
            int scaledImageSize = (int)((double)imageSize * scale) + 1;
            if (_cachedImage == null || !c.equals(_cachedImageColor) || scaledImageSize != _cachedImageSize || bookmark != _cachedBookmark || hasNotes != _cachedHasNotes || isCollectionNode != _collectionNode || isPartial != _cachedIsPartial || isSelected != _cachedSelected) {
                Color borderColor;
                _cachedImage = g2D.getDeviceConfiguration().createCompatibleImage(scaledImageSize, scaledImageSize, 3);
                _cachedSelected = isSelected;
                Graphics2D g2DTemp = _cachedImage.createGraphics();
                g2DTemp.setRenderingHints(g2D.getRenderingHints());
                AffineTransform imgTransform = new AffineTransform();
                imgTransform.scale(scale, transform.getScaleY());
                g2DTemp.transform(imgTransform);
                int borderWidth = isSelected ? 14 : 0;
                int borderWidthHalf = borderWidth / 2;
                float selectionWidth = 0.0f;
                float margin = ((float)borderWidth + selectionWidth) / 2.0f + 1.0f;
                g2DTemp.translate(margin, margin);
                MainPaintUtils.setupAlphaComposite(g2DTemp, animationFactor, realizer);
                if (!drawPlain && isSelected && isCollectionNode) {
                    borderColor = NodeRealizerSettings.getDefault().getSelectionSloppyBorderColor();
                    g2DTemp.setColor(borderColor);
                    g2DTemp.fillRect(0 - borderWidthHalf, 0 - borderWidthHalf, h + borderWidth, h + borderWidth);
                }
                if (isSelected) {
                    g2DTemp.setColor(this.getSelectedColor(c));
                } else {
                    g2DTemp.setColor(c);
                }
                if (isCollectionNode) {
                    if (!isSelected || drawPlain) {
                        g2DTemp.fillRect(0, 0, h, h);
                    } else {
                        borderWidthHalf = borderWidth < h ? borderWidthHalf : 0;
                        g2DTemp.fillOval(0 + borderWidthHalf, 0 + borderWidthHalf, h - borderWidthHalf * 2, h - borderWidthHalf * 2);
                    }
                } else {
                    g2DTemp.fillOval(0, 0, h, h);
                }
                if (!drawPlain) {
                    borderColor = isSelected ? NodeRealizerSettings.getDefault().getSelectionSloppyBorderColor() : this.getSelectedColor(c);
                    g2DTemp.setColor(borderColor);
                    if (isSelected && isCollectionNode && isPartial) {
                        int w = (int)((float)h / 3.5f);
                        g2DTemp.translate(w, w);
                        g2DTemp.fillOval(0, 0, (int)((float)w * 1.6f), (int)((float)w * 1.6f));
                        g2DTemp.translate(-w, -w);
                    }
                    if (borderWidth > 0 && !isCollectionNode) {
                        g2DTemp.setStroke(new BasicStroke(borderWidth));
                        g2DTemp.drawOval(0, 0, h, h);
                    }
                    int hDiv4 = h / 4;
                    int hDiv2 = (int)(((double)h + 0.5) / 2.0);
                    if (hasNotes) {
                        g2DTemp.setColor(UIManager.getLookAndFeelDefaults().getColor("note-overlay-color"));
                        g2DTemp.fillRect(hDiv4, hDiv4, hDiv2, hDiv2);
                    }
                    if (bookmark >= 0) {
                        Color bookmarkColor = BookmarkFactory.getDefault().getColor(Integer.valueOf(bookmark));
                        GraphicsUtils.drawBookMark((Graphics2D)g2DTemp, (int)hDiv4, (int)hDiv4, (int)hDiv2, (int)hDiv2, (Color)bookmarkColor, (boolean)false);
                    }
                }
                MainPaintUtils.resetAlphaComposite(g2DTemp, animationFactor);
                g2DTemp.dispose();
                _cachedImageSize = scaledImageSize;
                _cachedImageColor = c;
                _cachedBookmark = bookmark;
                _cachedHasNotes = hasNotes;
                _collectionNode = isCollectionNode;
                _cachedIsPartial = isPartial;
            }
            try {
                g2D.transform(transform.createInverse());
            }
            catch (NoninvertibleTransformException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            double centerOffset = (double)(imageSize - h) / 2.0;
            Point2D.Double canvasPos = new Point2D.Double(x - centerOffset, y - centerOffset);
            Point2D.Double viewPos = new Point2D.Double();
            transform.transform(canvasPos, viewPos);
            g2D.drawImage(_cachedImage, null, (int)((Point2D)viewPos).getX(), (int)((Point2D)viewPos).getY());
            g2D.setTransform(transform);
        }
    }

    protected double getRadius(NodeRealizer nr) {
        return nr.getWidth();
    }

    protected Color getColor(NodeRealizer nr, String typeName) {
        return _colorFactory.getTypeColor(typeName);
    }

    private Color getSelectedColor(Color c) {
        return Colors.getQuarkXPressShade((Color)c, (float)50.0f);
    }
}

