/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.cache.skeletons.EntitySkeletonProvider;
import com.paterva.maltego.graph.cache.skeletons.SkeletonProviders;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphTypeChangePropagator;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.view.Graph2D;
import y.view.NodeRealizer;

public class EntityRealizerInflater {
    private static final Logger LOG = Logger.getLogger(EntityRealizerInflater.class.getName());
    private final LinkedHashSet<LightweightEntityRealizer> _inflatedRealizers = new LinkedHashSet();
    private final GraphID _graphID;
    private int _inflated = 0;
    private int _touched = 0;
    private int _maxPainted = 0;
    private PropertyChangeListener _graphStoreListener;
    private Graph2D _graph;
    private NodeRemovedListener _nodeRemovedListener;
    private GraphStructureStore _viewStructureStore;
    private ChangeListener _graphTypeListener;

    EntityRealizerInflater(GraphID graphID) {
        this._graphID = graphID;
        this.addListeners();
    }

    public void addListeners() {
        this._graphStoreListener = new GraphStoreListener();
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this._graphID);
        this._viewStructureStore = view.getGraphStructureStore();
        this._viewStructureStore.addPropertyChangeListener(this._graphStoreListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GraphID graphID;
                if ("graphClosing".equals(evt.getPropertyName()) && (graphID = (GraphID)evt.getNewValue()).equals((Object)EntityRealizerInflater.this._graphID)) {
                    EntityRealizerInflater.this.removeListeners();
                    EntityRealizerInflater.this._inflatedRealizers.clear();
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                }
            }
        });
        this._nodeRemovedListener = new NodeRemovedListener();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)this._graphID);
        this._graph = (Graph2D)wrapper.getGraph();
        this._graph.addGraphListener((GraphListener)this._nodeRemovedListener);
        this._graphTypeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                EntityRealizerInflater.this.deflateAll();
            }
        };
        GraphTypeChangePropagator.get().addChangeListener(this._graphTypeListener);
    }

    public void removeListeners() {
        GraphTypeChangePropagator.get().removeChangeListener(this._graphTypeListener);
        this._graphTypeListener = null;
        this._graph.removeGraphListener((GraphListener)this._nodeRemovedListener);
        this._nodeRemovedListener = null;
        this._viewStructureStore.removePropertyChangeListener(this._graphStoreListener);
        this._graphStoreListener = null;
    }

    public void inflate(LightweightEntityRealizer realizer) throws GraphStoreException {
        if (!realizer.isInflated()) {
            GraphEntity graphEntity = realizer.getGraphEntity();
            if (graphEntity != null) {
                GraphID graphID = graphEntity.getGraphID();
                EntityID entityID = (EntityID)graphEntity.getID();
                GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
                Graph2D graph2D = (Graph2D)realizer.getNode().getGraph();
                if (wrapper.isCollectionNode(entityID)) {
                    this.inflateCollectionNode(realizer, graph2D);
                } else {
                    EntitySkeletonProvider skeletonProvider = SkeletonProviders.entitiesForGraph((GraphID)graphID);
                    MaltegoEntity entitySkeleton = skeletonProvider.getEntitySkeleton(entityID);
                    this.inflate(realizer, graph2D, entitySkeleton);
                }
            }
        } else {
            this.touch(realizer);
        }
    }

    public void inflate(LightweightEntityRealizer realizer, Graph2D graph2D, MaltegoEntity entitySkeleton) {
        LOG.log(Level.FINE, "Inflating {0}", realizer.getGraphEntity().getID());
        realizer.inflate(entitySkeleton);
        this._inflatedRealizers.add(realizer);
        ++this._inflated;
    }

    public void inflateCollectionNode(LightweightEntityRealizer realizer, Graph2D graph2D) {
        LOG.log(Level.FINE, "Inflating {0}", realizer.getGraphEntity().getID());
        realizer.inflateCollectionNode();
        this._inflatedRealizers.add(realizer);
        ++this._inflated;
    }

    public void touch(LightweightEntityRealizer realizer) {
        LOG.log(Level.FINEST, "Touching {0}", realizer.getGraphEntity().getID());
        if (!this._inflatedRealizers.remove((Object)realizer)) {
            LOG.severe("Realizer not inflated!");
        }
        this._inflatedRealizers.add(realizer);
        ++this._touched;
    }

    public void deflateAll() {
        for (LightweightEntityRealizer realizer : this._inflatedRealizers) {
            realizer.deflate();
        }
        this._inflatedRealizers.clear();
    }

    public void onPaintStart() {
        this._inflated = 0;
        this._touched = 0;
    }

    public void onPaintEnd() {
        this._maxPainted = Math.max(this._maxPainted, this._inflated + this._touched);
        int cacheLimit = this._maxPainted * 10;
        int deflated = 0;
        while (this._inflatedRealizers.size() > cacheLimit) {
            Iterator itr = this._inflatedRealizers.iterator();
            LightweightEntityRealizer realizer = (LightweightEntityRealizer)((Object)itr.next());
            this.deflate(realizer);
            itr.remove();
            ++deflated;
        }
        if (this._inflated != 0 || deflated != 0) {
            LOG.log(Level.FINE, "Inflated: {0} Deflated: {1} Touched: {2} MaxPainted: {3} CacheSize: {4} CacheLimit: {5}", new Object[]{this._inflated, deflated, this._touched, this._maxPainted, this._inflatedRealizers.size(), cacheLimit});
        }
    }

    private void deflate(LightweightEntityRealizer realizer) {
        LOG.log(Level.FINE, "Deflating {0}", realizer.getGraphEntity().getID());
        realizer.deflate();
    }

    private void deflateModelEntities(Collection<EntityID> modelEntities) throws GraphStoreException {
        Set<EntityID> viewEntities = this.getViewEntities(modelEntities);
        this.deflateViewEntities(viewEntities);
    }

    private void deflateViewEntities(Collection<EntityID> viewEntities) throws GraphStoreException {
        Set<LightweightEntityRealizer> realizers = this.getRealizers(viewEntities);
        for (LightweightEntityRealizer realizer : realizers) {
            if (!this._inflatedRealizers.remove((Object)realizer)) continue;
            this.deflate(realizer);
        }
    }

    private Set<EntityID> getViewEntities(Collection<EntityID> modelEntities) throws GraphStoreException {
        HashSet<EntityID> viewEntities = new HashSet<EntityID>();
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(this._graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        for (EntityID modelEntity : modelEntities) {
            viewEntities.add(mappings.getViewEntity(modelEntity));
        }
        return viewEntities;
    }

    private Set<LightweightEntityRealizer> getRealizers(Collection<EntityID> viewEntities) {
        HashSet<LightweightEntityRealizer> realizers = new HashSet<LightweightEntityRealizer>();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)this._graphID);
        Graph2D graph = (Graph2D)wrapper.getGraph();
        for (EntityID viewEntity : viewEntities) {
            Node node = wrapper.node(viewEntity);
            NodeRealizer realizer = graph.getRealizer(node);
            if (!(realizer instanceof LightweightEntityRealizer)) continue;
            realizers.add((LightweightEntityRealizer)realizer);
        }
        return realizers;
    }

    private class NodeRemovedListener
    implements GraphListener {
        private NodeRemovedListener() {
        }

        public void onGraphEvent(GraphEvent e) {
            if (e.getType() == 2) {
                Node node = (Node)e.getData();
                LightweightEntityRealizer realizer = (LightweightEntityRealizer)EntityRealizerInflater.this._graph.getRealizer(node);
                if (EntityRealizerInflater.this._inflatedRealizers.remove((Object)realizer)) {
                    EntityRealizerInflater.this.deflate(realizer);
                }
            }
        }
    }

    private class GraphStoreListener
    implements PropertyChangeListener {
        private GraphStoreListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            HashSet viewEntitiesChanged = new HashSet();
            switch (propertyName) {
                case "structureModified": {
                    GraphStructureMods mods = (GraphStructureMods)evt.getNewValue();
                    viewEntitiesChanged.addAll(mods.getCollectionMods().keySet());
                }
            }
            if (!viewEntitiesChanged.isEmpty()) {
                try {
                    EntityRealizerInflater.this.deflateViewEntities(viewEntitiesChanged);
                }
                catch (GraphStoreException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

