/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.view2d.EntityRealizerInflater;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import java.awt.Graphics2D;
import java.util.Collection;
import org.openide.util.Exceptions;
import y.view.AbstractCustomNodePainter;
import y.view.EdgeRealizer;
import y.view.NodeRealizer;

public class EntityNodePainter
extends AbstractCustomNodePainter {
    private final GraphID _graphID;
    private final EntityRealizerInflater _inflater;
    private final boolean _paintAnimations;

    public EntityNodePainter(GraphID graphID, EntityRealizerInflater inflater, boolean paintAnimations) {
        this._graphID = graphID;
        this._inflater = inflater;
        this._paintAnimations = paintAnimations;
    }

    public void onPaintStart(Collection<NodeRealizer> nodeRealizersToPaint, Collection<EdgeRealizer> edgeRealizersToPaint) {
        this._inflater.onPaintStart();
        EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
        painter.onGraphPaintStart(this._graphID, nodeRealizersToPaint, edgeRealizersToPaint);
    }

    public void onPaintEnd() {
        this._inflater.onPaintEnd();
        EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
        painter.onGraphPaintEnd(this._graphID);
    }

    public boolean isOptimizationsEnabled() {
        return EntityPainterSettings.getDefault().getEntityPainter(this._graphID).isOptimizationsEnabled();
    }

    public boolean isCollectionNodeEditorEnabled() {
        EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
        return painter.isCollectionNodeEditorEnabled();
    }

    protected void paintNode(NodeRealizer nr, Graphics2D g2D, boolean sloppy) {
        try {
            LightweightEntityRealizer realizer = (LightweightEntityRealizer)nr;
            EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
            painter.update(realizer, false);
            if (sloppy) {
                painter.paintSloppy(g2D, realizer, this._paintAnimations);
            } else {
                this._inflater.inflate(realizer);
                painter.paint(g2D, realizer);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

