/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeLabel;
import com.paterva.maltego.ui.graph.view2d.EditLabelAction;
import com.paterva.maltego.ui.graph.view2d.EntityLabelConfigs;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import y.base.Graph;
import y.base.Node;
import y.geom.YPoint;
import y.view.HitInfo;
import y.view.NodeLabel;
import y.view.ViewMode;
import y.view.YLabel;

public class EditNotesViewMode
extends ViewMode {
    private int _mouseX;
    private int _mouseY;

    public void mousePressed(MouseEvent me) {
        super.mousePressed(me);
        this._mouseX = me.getX();
        this._mouseY = me.getY();
    }

    public void mouseReleased(MouseEvent me) {
        NodeLabel label;
        double worldY;
        double worldX;
        HitInfo hitInfo;
        super.mouseReleased(me);
        if (this.view.getZoom() >= this.view.getPaintDetailThreshold() && this._mouseX == me.getX() && this._mouseY == me.getY() && (hitInfo = this.getHitInfo(worldX = this.view.toWorldCoordX(me.getX()), worldY = this.view.toWorldCoordY(me.getY()))).hasHitNodeLabels() && (label = hitInfo.getHitNodeLabel()) != null && !(label instanceof CollectionNodeLabel) && this.isNotesEditLabel(label)) {
            if (this.isCloseClicked(label, worldX, worldY)) {
                MaltegoEntity entity = this.getEntity(label.getNode());
                String notes = entity.getNotes();
                boolean isShowNotes = false;
                if ("(Click here to add notes)".equals(notes)) {
                    notes = "";
                }
                GraphTransactionHelper.doChangeNotes((Graph)this.getGraph2D(), Collections.singleton(entity), notes, isShowNotes);
            } else {
                this.notesEditLabelClicked(label);
            }
        }
    }

    private boolean isCloseClicked(NodeLabel label, double worldX, double worldY) {
        Point2D.Double pos = this.getLabelClickLocation(label, worldX, worldY);
        Rectangle2D.Double notesCloseRect = EntityLabelConfigs.getNotesCloseRect((YLabel)label);
        notesCloseRect.x -= 1.0;
        notesCloseRect.y -= 1.0;
        notesCloseRect.width += 2.0;
        notesCloseRect.height += 2.0;
        return notesCloseRect.contains(pos);
    }

    private Point2D.Double getLabelClickLocation(NodeLabel label, double worldX, double worldY) {
        Node node = label.getNode();
        double nodeX = this.view.getGraph2D().getX(node);
        double nodeY = this.view.getGraph2D().getY(node);
        double labelClickX = worldX - (nodeX + label.getOffsetX());
        double labelClickY = worldY - (nodeY + label.getOffsetY());
        return new Point2D.Double(labelClickX, labelClickY);
    }

    private boolean isNotesEditLabel(NodeLabel label) {
        NodeLabel notesEditLabel = this.view.getGraph2D().getRealizer(label.getNode()).getLabel(4);
        return notesEditLabel != null && notesEditLabel.equals(label);
    }

    private void notesEditLabelClicked(NodeLabel notesEditLabel) {
        int margin = 10;
        YPoint textLocation = notesEditLabel.getTextLocation().moveBy((double)margin, (double)margin);
        EditLabelAction action = new EditLabelAction();
        action.startEditing(this.view, (YLabel)notesEditLabel);
        this.view.openLabelEditor((YLabel)notesEditLabel, textLocation.x, textLocation.y, (PropertyChangeListener)new NotesListener(notesEditLabel));
    }

    private MaltegoEntity getEntity(Node node) {
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this.view.getGraph2D());
        MaltegoEntity entity = wrapper.entity(node);
        return entity;
    }

    private void setNotes(MaltegoEntity entity, String newNotes, boolean isShowNotes) {
        GraphTransactionHelper.doChangeNotes((Graph)this.getGraph2D(), Collections.singleton(entity), newNotes, isShowNotes);
    }

    private class NotesListener
    implements PropertyChangeListener {
        private NodeLabel _label;

        private NotesListener(NodeLabel label) {
            this._label = label;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)this._label.getGraph2D());
            MaltegoEntity entity = wrapper.entity(this._label.getNode());
            String text = this._label.getText();
            if (text == null || text.trim().isEmpty()) {
                EditNotesViewMode.this.setNotes(entity, "", false);
            } else {
                EditNotesViewMode.this.setNotes(entity, text, entity.isShowNotes());
            }
        }
    }
}

