/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EditableNodeLabel;
import com.paterva.maltego.ui.graph.view2d.NodeEditHook;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import javax.swing.SwingUtilities;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2DView;
import y.view.Graph2DViewActions;
import y.view.NodeLabel;
import y.view.YLabel;

public class EditLabelAction
extends Graph2DViewActions.EditLabelAction {
    public void startEditing(final Graph2DView view, final YLabel ylabel) {
        if (ylabel instanceof NodeLabel) {
            final NodeLabel nodeLabel = (NodeLabel)ylabel;
            this.fireEditEvent("labelEditorOpened", nodeLabel.getNode());
            ContainerAdapter containerListener = new ContainerAdapter(){

                @Override
                public void componentRemoved(ContainerEvent e) {
                    boolean fireByCollectionNode = CollectionNodeUtils.isFiredByCollectionNode(e);
                    if (!fireByCollectionNode) {
                        SwingUtilities.invokeLater(() -> {
                            EditLabelAction.this.fireEditEvent("labelEditorClosed", nodeLabel.getNode());
                            if (ylabel instanceof EditableNodeLabel) {
                                EditableNodeLabel editableLabel = (EditableNodeLabel)ylabel;
                                editableLabel.setEditing(false);
                            }
                        });
                        view.getCanvasComponent().removeContainerListener(this);
                    }
                }
            };
            view.getCanvasComponent().addContainerListener(containerListener);
        }
        if (ylabel instanceof EditableNodeLabel) {
            EditableNodeLabel editableLabel = (EditableNodeLabel)ylabel;
            editableLabel.setEditing(true);
            view.repaint();
        }
    }

    protected void openLabelEditor(Graph2DView view, YLabel ylabel, PropertyChangeListener pl, boolean bln) {
        this.startEditing(view, ylabel);
        super.openLabelEditor(view, ylabel, pl, bln);
    }

    private void fireEditEvent(String id, Node node) {
        Collection<? extends NodeEditHook> hooks = NodeEditHook.getAll();
        if (hooks.isEmpty()) {
            return;
        }
        Graph graph = node.getGraph();
        GraphID graphID = GraphIDProvider.forGraph((Graph)graph);
        if (graphID != null) {
            for (NodeEditHook nodeEditHook : hooks) {
                nodeEditHook.handle(id, graphID);
            }
        }
    }
}

