/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.selection.SelectionState;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphModelViewMappings;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.view2d.LightweightEntityRealizer;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainter;
import java.awt.Component;
import java.awt.event.ContainerEvent;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.NodeCellRendererPainter;
import y.view.NodeRealizer;

public class CollectionNodeUtils {
    public static boolean isCollectionNode(Node node) {
        Graph graph = node.getGraph();
        if (graph == null) {
            return false;
        }
        return CollectionNodeUtils.isCollectionNode(((Graph2D)graph).getRealizer(node));
    }

    public static boolean isCollectionNode(NodeRealizer nr) {
        boolean isCollectionNode = false;
        if (nr instanceof LightweightEntityRealizer) {
            LightweightEntityRealizer realizer = (LightweightEntityRealizer)nr;
            GraphEntity graphEntity = realizer.getGraphEntity();
            GraphID graphID = graphEntity.getGraphID();
            EntityID entityID = (EntityID)graphEntity.getID();
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            isCollectionNode = wrapper.isCollectionNode(entityID);
        }
        return isCollectionNode;
    }

    public static boolean isShowComponents(Graph2DView view) {
        return MainEntityPainter.isDeepZoom(view.getZoom());
    }

    public static SelectionState getSelectionState(NodeRealizer nr) {
        SelectionState state;
        if (nr instanceof LightweightEntityRealizer) {
            LightweightEntityRealizer realizer = (LightweightEntityRealizer)nr;
            GraphEntity graphEntity = realizer.getGraphEntity();
            state = CollectionNodeUtils.getSelectionState(graphEntity);
        } else {
            Node node = nr.getNode();
            Graph2D graph = (Graph2D)node.getGraph();
            state = graph.isSelected(node) ? SelectionState.YES : SelectionState.NO;
        }
        return state;
    }

    public static SelectionState getSelectionState(GraphEntity graphEntity) {
        return CollectionNodeUtils.getSelectionState(graphEntity.getGraphID(), (EntityID)graphEntity.getID());
    }

    public static SelectionState getSelectionState(GraphID graphID, EntityID entityID) {
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        return selection.getViewSelectionState(entityID);
    }

    public static int getModelEntityCount(GraphID graphID, EntityID collectionEntityID) throws GraphStoreException {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        return mappings.getModelEntities(collectionEntityID).size();
    }

    public static int getModelLinkCount(GraphID graphID, LinkID collectionLinkID) throws GraphStoreException {
        GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
        GraphModelViewMappings mappings = view.getModelViewMappings();
        return mappings.getModelLinks(collectionLinkID).size();
    }

    static boolean isFiredByCollectionNode(ContainerEvent e) {
        String name;
        Class<?> aClass;
        boolean fireByCollectionNode = false;
        Component child = e.getChild();
        if (child != null && (aClass = child.getClass()) != null && (name = aClass.getName()) != null && name.contains(NodeCellRendererPainter.class.getName() + "$")) {
            fireByCollectionNode = true;
        }
        return fireByCollectionNode;
    }
}

