/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.treelist.parts.entity.EntityTreeModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CollectionNodeSelectionModel
extends DefaultListSelectionModel {
    private final GraphEntity _graphEntity;
    private final EntityTreeModel _tableModel;
    private final GraphSelection _selection;
    private final List<ListSelectionListener> _listeners = new LinkedList<ListSelectionListener>();
    private final DefaultListSelectionModel _delegate = new DefaultListSelectionModel();
    private final JTable _table;
    private boolean _clearGlobalSelection = false;
    private SelectionSyncListener _selectionSyncListener;
    private boolean _isUpdating = false;

    public CollectionNodeSelectionModel(GraphEntity graphEntity, EntityTreeModel tableModel, JTable table) {
        this.setSelectionMode(2);
        this._graphEntity = graphEntity;
        this._tableModel = tableModel;
        this._table = table;
        this._selection = GraphSelection.forGraph((GraphID)this._graphEntity.getGraphID());
    }

    public void addNotify() {
        this._selectionSyncListener = new SelectionSyncListener();
        this._selectionSyncListener.syncWithGraphSelection();
        this._selection.addPropertyChangeListener((PropertyChangeListener)this._selectionSyncListener);
        this._delegate.addListSelectionListener(this._selectionSyncListener);
    }

    public void removeNotify() {
        this._selection.removePropertyChangeListener((PropertyChangeListener)this._selectionSyncListener);
        this._delegate.removeListSelectionListener(this._selectionSyncListener);
        this._selectionSyncListener = null;
    }

    @Override
    public void setSelectionInterval(int firstIndex, int lastIndex) {
        this._clearGlobalSelection = firstIndex == lastIndex;
        this._delegate.setSelectionInterval(firstIndex, lastIndex);
    }

    @Override
    public void addSelectionInterval(int firstIndex, int lastIndex) {
        this._clearGlobalSelection = false;
        this._delegate.addSelectionInterval(firstIndex, lastIndex);
    }

    @Override
    public void removeSelectionInterval(int firstIndex, int lastIndex) {
        this._clearGlobalSelection = false;
        this._delegate.removeSelectionInterval(firstIndex, lastIndex);
    }

    @Override
    public int getMinSelectionIndex() {
        return this._delegate.getMinSelectionIndex();
    }

    @Override
    public int getMaxSelectionIndex() {
        return this._delegate.getMaxSelectionIndex();
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.isSelectedIndex(index, true);
    }

    private boolean isSelectedIndex(int viewIndex, boolean doSyncCheck) {
        EntityID entityID;
        boolean selectedInGraph;
        int rowCount;
        int modelIndex;
        boolean selected = this._delegate.isSelectedIndex(viewIndex);
        if (doSyncCheck && (modelIndex = this._table.convertRowIndexToModel(viewIndex)) < (rowCount = this._tableModel.getChildCount(this._tableModel.getRoot())) && modelIndex >= 0 && selected != (selectedInGraph = this._selection.isSelectedInModel(entityID = (EntityID)this._tableModel.getPartID(modelIndex)))) {
            this.syncListSelectionWithGraph();
            selected = selectedInGraph;
        }
        return selected;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this._delegate.getAnchorSelectionIndex();
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        this._clearGlobalSelection = false;
        this._delegate.setAnchorSelectionIndex(index);
    }

    @Override
    public int getLeadSelectionIndex() {
        return this._delegate.getLeadSelectionIndex();
    }

    @Override
    public void setLeadSelectionIndex(int index) {
        this._clearGlobalSelection = false;
        this._delegate.setLeadSelectionIndex(index);
    }

    @Override
    public void clearSelection() {
        this._clearGlobalSelection = true;
        this._delegate.clearSelection();
    }

    @Override
    public boolean isSelectionEmpty() {
        return this._delegate.isSelectionEmpty();
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        this._clearGlobalSelection = false;
        this._delegate.insertIndexInterval(index, length, before);
    }

    @Override
    public void removeIndexInterval(int firstIndex, int lastIndex) {
        this._clearGlobalSelection = false;
        this._delegate.removeIndexInterval(firstIndex, lastIndex);
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this._delegate.setValueIsAdjusting(valueIsAdjusting);
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this._delegate.getValueIsAdjusting();
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this._delegate.setSelectionMode(selectionMode);
    }

    @Override
    public int getSelectionMode() {
        return this._delegate.getSelectionMode();
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this._listeners.remove(listener);
    }

    private void fireSelectionChanged(ListSelectionEvent event) {
        for (ListSelectionListener listener : this._listeners) {
            listener.valueChanged(event);
        }
    }

    @Override
    public void moveLeadSelectionIndex(int leadIndex) {
        this._delegate.moveLeadSelectionIndex(leadIndex);
    }

    @Override
    public void setLeadAnchorNotificationEnabled(boolean flag) {
        this._delegate.setLeadAnchorNotificationEnabled(flag);
    }

    @Override
    public boolean isLeadAnchorNotificationEnabled() {
        return this._delegate.isLeadAnchorNotificationEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncListSelectionWithGraph() {
        if (!this._isUpdating) {
            this._isUpdating = true;
            this._delegate.setValueIsAdjusting(true);
            try {
                this._delegate.clearSelection();
                int rowCount = this._tableModel.getChildCount(this._tableModel.getRoot());
                for (int modelRow = 0; modelRow < rowCount; ++modelRow) {
                    EntityID entityID = (EntityID)this._tableModel.getPartID(modelRow);
                    boolean isSelected = this._selection.isSelectedInModel(entityID);
                    if (!isSelected) continue;
                    int viewRow = this._table.convertRowIndexToView(modelRow);
                    this._delegate.addSelectionInterval(viewRow, viewRow);
                }
            }
            finally {
                this._delegate.setValueIsAdjusting(false);
                this._isUpdating = false;
            }
        }
    }

    private class SelectionSyncListener
    implements ListSelectionListener,
    PropertyChangeListener {
        private SelectionSyncListener() {
        }

        public void syncWithGraphSelection() {
            this.propertyChange(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!CollectionNodeSelectionModel.this._isUpdating && !CollectionNodeSelectionModel.this._tableModel.isFiringDataChange()) {
                CollectionNodeSelectionModel.this._isUpdating = true;
                try {
                    HashSet<EntityID> selected = new HashSet<EntityID>();
                    HashSet<EntityID> unselected = new HashSet<EntityID>();
                    for (int viewRow = e.getFirstIndex(); viewRow <= e.getLastIndex(); ++viewRow) {
                        int modelRow = CollectionNodeSelectionModel.this._table.convertRowIndexToModel(viewRow);
                        if (modelRow == -1) continue;
                        EntityID entityID = (EntityID)CollectionNodeSelectionModel.this._tableModel.getPartID(modelRow);
                        if (CollectionNodeSelectionModel.this.isSelectedIndex(viewRow, false)) {
                            selected.add(entityID);
                            continue;
                        }
                        unselected.add(entityID);
                    }
                    if (CollectionNodeSelectionModel.this._clearGlobalSelection) {
                        CollectionNodeSelectionModel.this._selection.clearSelection();
                        CollectionNodeSelectionModel.this._selection.setSelectedModelEntities(selected);
                    } else {
                        CollectionNodeSelectionModel.this._selection.setModelEntitiesSelected(unselected, false);
                        CollectionNodeSelectionModel.this._selection.setModelEntitiesSelected(selected, true);
                    }
                }
                finally {
                    CollectionNodeSelectionModel.this._isUpdating = false;
                }
            }
            CollectionNodeSelectionModel.this.fireSelectionChanged(e);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CollectionNodeSelectionModel.this.syncListSelectionWithGraph();
        }
    }
}

