/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeEditor;
import com.paterva.maltego.ui.graph.view2d.EmptyNodeMap;
import com.paterva.maltego.ui.graph.view2d.MouseWheelListenerProxy;
import com.paterva.maltego.ui.graph.view2d.PopupAwareEditMode;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainter;
import com.paterva.maltego.ui.graph.view2d.painter.EntityPainterSettings;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import y.base.DataAcceptor;
import y.base.DataMap;
import y.base.Graph;
import y.base.Node;
import y.view.CellEditorMode;
import y.view.EditMode;
import y.view.NodeCellEditor;
import y.view.NodeRealizer;

class CollectionNodeEditMode
extends CellEditorMode {
    private static final CollectionNodeEditor _editor = new CollectionNodeEditor();
    private Node _node;
    private ZoomChangeListener _zoomListener;
    private JComponent _editorComponent;
    private GraphID _graphID;

    public CollectionNodeEditMode(EditMode editMode) {
        super((NodeCellEditor)_editor, (DataMap)new EmptyNodeMap());
    }

    public boolean isNodeEditable(Node node) {
        EntityPainter painter = EntityPainterSettings.getDefault().getEntityPainter(this._graphID);
        return painter != null ? painter.isCollectionNodeEditorEnabled() : false;
    }

    public void setGraphID(GraphID graphID) {
        this._graphID = graphID;
        MouseWheelListenerProxy.forGraph(graphID).addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (CollectionNodeEditMode.this._node != null) {
                    Component[] components = CollectionNodeEditMode.this._editorComponent.getComponents();
                    JScrollPane scrollPane = (JScrollPane)components[0];
                    JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
                    int value = verticalScrollBar.getValue();
                    int rows = 5;
                    verticalScrollBar.setValue(value += rows * 7 * e.getWheelRotation());
                    e.consume();
                }
            }
        });
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        Node hitNode = this.getHitInfo(e).getHitNode();
        if ((hitNode != this.getEditingNode() || this.view.getZoom() < 2.0 || hitNode != null && !PopupAwareEditMode.isOverCollectionNodeMinusBanner(hitNode, this.view, e)) && !this.stopCellEditing()) {
            this.cancelEditing();
        }
    }

    protected void installEditor(JComponent component, NodeRealizer nr) {
        this._editorComponent = component;
        this._node = nr.getNode();
        CollectionNodeEditMode.setEditing(this._node, true);
        this._zoomListener = new ZoomChangeListener();
        this.view.getCanvasComponent().addPropertyChangeListener(this._zoomListener);
        super.installEditor(component, nr);
    }

    protected void removeEditor() {
        super.removeEditor();
        this.view.getCanvasComponent().removePropertyChangeListener(this._zoomListener);
        this._zoomListener = null;
        CollectionNodeEditMode.setEditing(this._node, false);
        this._node = null;
        this._editorComponent = null;
    }

    private static void setEditing(Node node, boolean editing) {
        Graph graph;
        if (node != null && (graph = node.getGraph()) != null) {
            ((DataAcceptor)graph.getDataProvider((Object)"IS_EDITING_DPKEY")).setBool((Object)node, editing);
        }
    }

    private class ZoomChangeListener
    implements PropertyChangeListener {
        private ZoomChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("Zoom".equals(evt.getPropertyName()) && CollectionNodeEditMode.this.view.getZoom() < 2.0 && !CollectionNodeEditMode.this.stopCellEditing()) {
                CollectionNodeEditMode.this.cancelEditing();
            }
        }
    }
}

