/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureMods;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.treelist.lazy.filter.LazyOutlineFilterPanel;
import com.paterva.maltego.treelist.lazy.outline.DefaultOutlineCellRenderer;
import com.paterva.maltego.treelist.parts.entity.EntityTable;
import com.paterva.maltego.treelist.parts.entity.EntityTreeModel;
import com.paterva.maltego.ui.graph.BookmarkUtils;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeSelectionModel;
import com.paterva.maltego.ui.graph.view2d.PartHoverEntityTable;
import com.paterva.maltego.ui.graph.view2d.SmallScrollBarUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.table.TableCellRenderer;
import org.openide.util.Exceptions;

public class CollectionNodeComponent
extends JPanel
implements Scrollable {
    private final GraphEntity _graphEntity;
    private final EntityTable _table;
    private final CollectionNodeSelectionModel _selectionModel;
    private boolean _addNotified = false;
    private boolean _added = false;
    private Timer _removeNotifyTimer;
    private ClickEditListener _clickEditListener;
    private PropertyChangeListener _viewListener;
    private final Color _bg;
    private GraphStoreView _view;

    CollectionNodeComponent(GraphEntity graphEntity) throws GraphStoreException {
        this.setLayout(new BorderLayout());
        this._graphEntity = graphEntity;
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this._bg = laf.getColor("graph-collection-background-color");
        this.setBackground(this._bg);
        this._table = new PartHoverEntityTable("Collection Entities", true, "global", "graph");
        this._table.setBackground(this._bg);
        this._selectionModel = new CollectionNodeSelectionModel(this._graphEntity, (EntityTreeModel)this._table.getTreeModel(), (JTable)this._table);
        this._table.setSelectionModel((ListSelectionModel)this._selectionModel);
        SmallScrollPane smallScrollPane = new SmallScrollPane((Component)this._table);
        smallScrollPane.getViewport().setBackground(this._bg);
        smallScrollPane.setBackground(this._bg);
        this.add(smallScrollPane);
        JPanel filterPanel = this._table.getFilter();
        filterPanel.setBackground(laf.getColor("parts-table-header-bg"));
        this.add((Component)filterPanel, "South");
    }

    public EntityTable getTable() {
        return this._table;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.onShow();
    }

    public void onShow() {
        this._added = true;
        if (!this._addNotified) {
            this._table.addListeners();
            this._selectionModel.addNotify();
            this._clickEditListener = new ClickEditListener();
            this._table.addMouseListener((MouseListener)this._clickEditListener);
            this._viewListener = new GraphStoreViewListener();
            this._view = GraphStoreViewRegistry.getDefault().getDefaultView(this._graphEntity.getGraphID());
            this._view.getGraphStructureStore().addPropertyChangeListener(this._viewListener);
            this.updateEntities();
            this._addNotified = true;
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this._added = false;
        if (this._removeNotifyTimer == null) {
            this._removeNotifyTimer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CollectionNodeComponent.this._removeNotifyTimer = null;
                    if (!CollectionNodeComponent.this._added && CollectionNodeComponent.this._addNotified) {
                        CollectionNodeComponent.this.onHide();
                    }
                }
            });
            this._removeNotifyTimer.setRepeats(false);
            this._removeNotifyTimer.start();
        }
    }

    public void onHide() {
        this._added = false;
        this._addNotified = false;
        this._table.removeMouseListener((MouseListener)this._clickEditListener);
        this._clickEditListener = null;
        this._selectionModel.removeNotify();
        this._table.removeListeners();
        this._view.getGraphStructureStore().removePropertyChangeListener(this._viewListener);
        this._viewListener = null;
    }

    public int scrollToVisible(EntityID entityID, int ColIndex) {
        int viewRow = -1;
        if (this._table != null) {
            if (!(this._table.getParent() instanceof JViewport)) {
                return viewRow;
            }
            int modelRow = this._table.getTreelistModel().getModelPartIndex((Guid)entityID);
            viewRow = this._table.convertRowIndexToView(modelRow);
            JViewport viewport = (JViewport)this._table.getParent();
            Point p = viewport.getViewPosition();
            int firstVisibleRow = this._table.rowAtPoint(p);
            p.y = (int)((double)p.y + viewport.getExtentSize().getHeight());
            int lastVisibleRow = this._table.rowAtPoint(p);
            if (viewRow <= firstVisibleRow || viewRow >= lastVisibleRow) {
                boolean adjustY = false;
                int viewRowMod = viewRow;
                if (viewRowMod > firstVisibleRow) {
                    viewRowMod = viewRowMod > 1 ? viewRowMod - 2 : viewRowMod;
                    adjustY = true;
                } else {
                    viewRowMod = viewRowMod > 0 ? viewRowMod - 1 : viewRowMod;
                }
                Rectangle rect = this._table.getCellRect(viewRowMod, ColIndex, true);
                if (adjustY) {
                    rect.y = (int)((double)rect.y + viewport.getExtentSize().getHeight());
                }
                this._table.scrollRectToVisible(rect);
            }
        }
        return viewRow;
    }

    public boolean setFlashingRow(int viewRow, boolean showFlashColour) {
        TableCellRenderer cr;
        boolean isSuccess = false;
        if (this._table != null && (cr = this._table.getDefaultRenderer(Object.class)) != null && cr instanceof DefaultOutlineCellRenderer) {
            DefaultOutlineCellRenderer renderer = (DefaultOutlineCellRenderer)cr;
            if (viewRow != -1) {
                renderer.setFlashingRow(viewRow);
                renderer.setFlashTimerRunning(true);
                renderer.setShowFlashColour(showFlashColour);
            } else {
                renderer.setFlashTimerRunning(false);
            }
            isSuccess = true;
        }
        return isSuccess;
    }

    private void updateEntities() {
        try {
            GraphID graphID = this._graphEntity.getGraphID();
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            Set modelEntities = view.getModelViewMappings().getModelEntities((EntityID)this._graphEntity.getID());
            this._table.getTreelistModel().setModelParts(graphID, modelEntities);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        double toolbarHeight = this._table.getFilter().getPreferredSize().getHeight();
        Dimension size = this._table.getPreferredScrollableViewportSize();
        size.setSize(size.getWidth(), size.getHeight() + toolbarHeight);
        return size;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this._table.getScrollableUnitIncrement(visibleRect, orientation, direction);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this._table.getScrollableBlockIncrement(visibleRect, orientation, direction);
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return this._table.getScrollableTracksViewportWidth();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this._table.getScrollableTracksViewportHeight();
    }

    private void changeBookmarks(int viewRow) {
        int modelRow = this._table.convertRowIndexToModel(viewRow);
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        EntityID entityID = (EntityID)this._table.getTreeModel().getPartID(modelRow);
        MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
        int bookmark = entity.getBookmark();
        int newBookmark = BookmarkFactory.getDefault().getNext(bookmark);
        if (!this._table.getSelectionModel().isSelectedIndex(viewRow)) {
            Set<MaltegoEntity> entities = Collections.singleton(entity);
            GraphTransactionHelper.doChangeBookmark(graphID, entities, newBookmark);
        } else {
            BookmarkUtils.setBookmarkForSelection(graphID, newBookmark);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePin(int viewRow) {
        int modelRow = this._table.convertRowIndexToModel(viewRow);
        GraphID graphID = this._table.getTreelistModel().getGraphID();
        EntityID entityID = (EntityID)this._table.getTreeModel().getPartID(modelRow);
        GraphStore graphStore = null;
        try {
            Set entities;
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            if (!this._table.getSelectionModel().isSelectedIndex(viewRow)) {
                entities = Collections.singleton(entityID);
            } else {
                GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                entities = selection.getSelectedModelEntities();
            }
            GraphTransactionHelper.doChangePinned(graphID, entities, true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)true);
                if (this._table != null && this._table.getRowCount() == 0 && this._table.getFilter() instanceof LazyOutlineFilterPanel) {
                    ((LazyOutlineFilterPanel)this._table.getFilter()).setText("");
                }
            }
        }
    }

    private class GraphStoreViewListener
    implements PropertyChangeListener {
        private GraphStoreViewListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Map collectionMods;
            GraphStructureMods structureMods = (GraphStructureMods)evt.getNewValue();
            if (structureMods != null && (collectionMods = structureMods.getCollectionMods()).containsKey(CollectionNodeComponent.this._graphEntity.getID())) {
                CollectionNodeComponent.this.updateEntities();
            }
        }
    }

    private class ClickEditListener
    extends MouseAdapter {
        private ClickEditListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point point = e.getPoint();
            int viewRow = CollectionNodeComponent.this._table.rowAtPoint(point);
            int col = CollectionNodeComponent.this._table.columnAtPoint(point);
            col = CollectionNodeComponent.this._table.convertColumnIndexToModel(col) - 1;
            if (col <= 0 && e.getClickCount() == 2) {
                System.out.println(col);
                int modelRow = CollectionNodeComponent.this._table.convertRowIndexToModel(viewRow);
                GraphID graphID = CollectionNodeComponent.this._table.getTreelistModel().getGraphID();
                EntityID entityID = (EntityID)CollectionNodeComponent.this._table.getTreeModel().getPartID(modelRow);
                NodeEditor.getDefault().edit(graphID, entityID);
            } else if (col == 3) {
                CollectionNodeComponent.this.changeBookmarks(viewRow);
            } else if (col == 4) {
                CollectionNodeComponent.this.changePin(viewRow);
            }
        }
    }

    private static class SmallScrollPane
    extends JScrollPane {
        public SmallScrollPane(Component view) {
            super(view);
            this.setBorder(null);
            JScrollBar vScrollBar = this.getVerticalScrollBar();
            vScrollBar.setUI((ScrollBarUI)((Object)new SmallScrollBarUI()));
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.paintBorder(g);
        }

        @Override
        protected void paintBorder(Graphics g) {
        }
    }
}

