/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.BookmarkUtils;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.view2d.LabelViewMode;
import java.util.Collections;
import java.util.Set;
import org.openide.awt.StatusDisplayer;
import y.base.Graph;
import y.base.Node;
import y.view.Graph2D;
import y.view.Graph2DView;
import y.view.NodeLabel;

public class BookmarkClickViewMode
extends LabelViewMode {
    public boolean isOverLabel(Graph2DView view, double x, double y) {
        return this.getLabel(view, x, y, 3) != null;
    }

    public void mouseReleasedLeft(double x, double y) {
        super.mouseReleasedLeft(x, y);
        NodeLabel label = this.getLabel(this.view, x, y, 3);
        if (label != null) {
            this.bookmarkClicked(label);
        }
        this.reactivateParent();
    }

    private void bookmarkClicked(NodeLabel label) {
        int newBookmark;
        Node yNode = label.getNode();
        Graph2D graph2D = label.getGraph2D();
        MaltegoEntity entity = this.getEntity(yNode);
        BookmarkFactory bookmarkFactory = BookmarkFactory.getDefault();
        int oldBookmark = entity.getBookmark();
        if (this.lastReleaseEvent.isControlDown()) {
            newBookmark = bookmarkFactory.getPrevious(oldBookmark);
        } else {
            newBookmark = bookmarkFactory.getNext(oldBookmark);
            if (newBookmark < 0) {
                StatusDisplayer.getDefault().setStatusText("Hint: hold <Ctrl> to cycle bookmarks in reverse");
            }
        }
        GraphID graphID = GraphIDProvider.forGraph((Graph2D)graph2D);
        if (!graph2D.isSelected(yNode)) {
            Set<MaltegoEntity> entities = Collections.singleton(entity);
            GraphTransactionHelper.doChangeBookmark(graphID, entities, newBookmark);
        } else {
            BookmarkUtils.setBookmarkForSelection(graphID, newBookmark);
        }
        this.view.getGraph2D().updateViews();
    }

    private MaltegoEntity getEntity(Node yNode) {
        return MaltegoGraphManager.getWrapper((Graph)yNode.getGraph()).entity(yNode);
    }
}

