/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphEntity;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;

public class BookmarkAction
implements ActionListener {
    private final GraphEntity _graphEntity;
    private final int _bookmark;

    public BookmarkAction(GraphEntity graphEntity, int bookmark) {
        this._graphEntity = graphEntity;
        this._bookmark = bookmark;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            GraphID graphID = this._graphEntity.getGraphID();
            EntityID entityID = (EntityID)this._graphEntity.getID();
            GraphStoreView view = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            Set modelEntities = view.getModelViewMappings().getModelEntities(entityID);
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            HashSet selectedModelEntities = new HashSet(selection.getSelectedModelEntities());
            selectedModelEntities.retainAll(modelEntities);
            Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, selectedModelEntities);
            GraphTransactionHelper.doChangeBookmark(graphID, entities, this._bookmark);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

