/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.view.GraphStoreView;
import com.paterva.maltego.graph.store.view.GraphStoreViewRegistry;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.PlaceLabelsAction;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.data.GraphDataUtils;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.Point;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeList;
import y.view.EdgeRealizer;
import y.view.Graph2D;
import y.view.MoveSelectionMode;

public class BendClearingMoveMode
extends MoveSelectionMode {
    private static final Logger LOG = Logger.getLogger(BendClearingMoveMode.class.getName());
    private Map<EntityID, Point> _centersBefore = Collections.emptyMap();
    private Map<LinkID, List<Point>> _pathsBefore = Collections.emptyMap();

    public BendClearingMoveMode() {
        this.setRemovingInnerBends(true);
    }

    protected void selectionMoveStarted(double x, double y) {
        LOG.fine("Move started");
        NodeList nodes = this.getNodesToBeMoved();
        Set<EntityID> entityIDs = this.toEntityIDs(nodes);
        this._centersBefore = GraphPositionAndPathHelper.getViewCenters(this.view.getGraph2D(), entityIDs);
        this._pathsBefore = GraphPositionAndPathHelper.getViewPathsForEntities(this.view.getGraph2D(), entityIDs);
        this.clearBends(nodes);
        super.selectionMoveStarted(x, y);
        GraphDataObject gdo = GraphDataUtils.getGraphDataObject((Graph)this.view.getGraph2D());
        if (gdo != null) {
            gdo.setModified(true);
        }
    }

    protected void selectionMovedAction(double d, double d1, double d2, double d3) {
        LOG.fine("Move action");
        this.createTransaction();
        this._centersBefore = Collections.emptyMap();
        this._pathsBefore = Collections.emptyMap();
        PlaceLabelsAction action = (PlaceLabelsAction)SystemAction.get(PlaceLabelsAction.class);
        if (action != null) {
            action.perform(this.view.getGraph2D(), null);
        }
    }

    public void reactivateParent() {
        LOG.fine("Reactivate parent");
        super.reactivateParent();
    }

    private void clearBends(NodeList nodes) {
        Graph2D graph = this.view.getGraph2D();
        NodeCursor nc = nodes.nodes();
        while (nc.ok()) {
            EdgeCursor ec = nc.node().edges();
            while (ec.ok()) {
                EdgeRealizer er = graph.getRealizer(ec.edge());
                if (er != null) {
                    er.clearBends();
                }
                ec.next();
            }
            nc.next();
        }
    }

    private void createTransaction() {
        try {
            Graph2D viewGraph2D = this.view.getGraph2D();
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)viewGraph2D);
            NodeList nodes = this.getNodesToBeMoved();
            Set<EntityID> entitiesAfter = this.toEntityIDs(nodes);
            GraphStoreView graphStoreView = GraphStoreViewRegistry.getDefault().getDefaultView(graphID);
            Set modelEntities = graphStoreView.getModelViewMappings().getModelEntities(entitiesAfter);
            String description = "Move selected " + GraphTransactionHelper.getDescriptionForEntityIDs(graphID, (Collection<EntityID>)modelEntities, true);
            GraphTransactionHelper.commitLayoutChanges(new SimilarStrings(description), viewGraph2D, entitiesAfter, this._centersBefore, this._pathsBefore, true);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Set<EntityID> toEntityIDs(NodeList nodes) {
        Graph2D graph2D = this.getGraph2D();
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((Graph)graph2D);
        HashSet<EntityID> entities = new HashSet<EntityID>(nodes.size());
        NodeCursor nc = nodes.nodes();
        while (nc.ok()) {
            Node node = nc.node();
            entities.add(wrapper.entityID(node));
            nc.next();
        }
        return entities;
    }
}

