/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions.merging;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.matching.api.GraphMatchStrategy;
import com.paterva.maltego.merging.EntityFilter;
import com.paterva.maltego.merging.GraphMergeCallback;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.StrategicGraphMerger;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.SlownessDetector;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openide.util.Exceptions;

public class TransactionGraphMerger
extends StrategicGraphMerger {
    private final SimilarStrings _description;
    private List<MaltegoEntity> _addedEntities = null;
    private List<MaltegoLink> _addedLinks = null;
    private Map<MaltegoEntity, MaltegoEntity> _mergedEntities = null;
    private Map<MaltegoLink, MaltegoLink> _mergedLinks = null;
    private int _totalEntities = 0;
    private String _user;
    private final boolean _newEntitiesNeedLayouting;

    public TransactionGraphMerger(SimilarStrings description, GraphMatchStrategy graphMatchStrat, GraphMergeStrategy graphMergeStrat, GraphMergeCallback cb, boolean newEntitiesNeedlayouting, boolean useGraphStoreMatching, boolean cloneParts) {
        super(graphMatchStrat, graphMergeStrat, cb, useGraphStoreMatching, cloneParts);
        this._description = description;
        this._newEntitiesNeedLayouting = newEntitiesNeedlayouting;
    }

    public void setGraphs(GraphID destGraphID, GraphID srcGraphID, EntityFilter filter) {
        super.setGraphs(destGraphID, srcGraphID, filter);
        this._addedEntities = new ArrayList<MaltegoEntity>();
        this._addedLinks = new ArrayList<MaltegoLink>();
        this._mergedEntities = new HashMap<MaltegoEntity, MaltegoEntity>();
        this._mergedLinks = new HashMap<MaltegoLink, MaltegoLink>();
        this._user = GraphUser.getUser(destGraphID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append() {
        GraphStore graphStore = null;
        try {
            Map<String, Map<EntityID, Point>> centers;
            SlownessDetector.setEnabled((boolean)false);
            GraphID destGraphID = this.getDestGraphID();
            graphStore = GraphStoreRegistry.getDefault().forGraphID(destGraphID);
            graphStore.beginUpdate();
            this._totalEntities = 0;
            boolean appended = super.append();
            if (!appended) {
                boolean bl = false;
                return bl;
            }
            if (this._addedEntities.isEmpty()) {
                centers = Collections.emptyMap();
            } else {
                centers = GraphPositionAndPathHelper.getAllCenters(destGraphID, (Set<EntityID>)GraphStoreHelper.getIds(this._addedEntities));
                this.setMissingCentersToParentCenter(graphStore, centers);
            }
            Map connections = this._addedLinks.isEmpty() ? Collections.emptyMap() : GraphStoreHelper.getModelConnections((GraphID)destGraphID, this._addedLinks);
            GraphTransactionBatch batch = new GraphTransactionBatch(this._description, true, new GraphTransaction[0]);
            if (!this._addedEntities.isEmpty() || !connections.isEmpty()) {
                Map pinned = GraphStoreHelper.isPinned((GraphID)destGraphID, (Set)GraphStoreHelper.getIds(this._addedEntities));
                batch.add(GraphTransactions.addEntitiesAndLinks(this._addedEntities, (Map<MaltegoLink, LinkEntityIDs>)connections, centers, pinned, this._newEntitiesNeedLayouting));
            }
            batch.addAll(GraphTransactionHelper.createUpdateTransactions(this._mergedEntities, this._mergedLinks));
            HashMap<MaltegoEntity, MaltegoEntity> inverseMergedEntities = GraphTransactionHelper.reverse(this._mergedEntities);
            HashMap<MaltegoLink, MaltegoLink> inverseMergedLinks = GraphTransactionHelper.reverse(this._mergedLinks);
            GraphTransactionBatch inverseBatch = new GraphTransactionBatch(this._description.createInverse(), true, new GraphTransaction[0]);
            inverseBatch.addAll(GraphTransactionHelper.createUpdateTransactions(inverseMergedEntities, inverseMergedLinks));
            if (!this._addedEntities.isEmpty() || !this._addedLinks.isEmpty()) {
                inverseBatch.add(GraphTransactions.deleteEntitiesAndLinks(GraphStoreHelper.getIds(this._addedEntities), GraphStoreHelper.getIds(this._addedLinks)));
            }
            if (!batch.isEmpty()) {
                GraphTransactorRegistry.getDefault().get(destGraphID).commitTransactions(batch, inverseBatch);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)this._newEntitiesNeedLayouting);
            }
            SlownessDetector.setEnabled((boolean)true);
        }
        return true;
    }

    protected void onEntityAdded(MaltegoEntity dest, MaltegoEntity src) {
        super.onEntityAdded(dest, src);
        this._addedEntities.add(dest);
        ModifiedHelper.updateCreated(this._user, (MaltegoPart<? extends Guid>)dest);
        ModifiedHelper.updateModified(this._user, (MaltegoPart<? extends Guid>)dest);
        ++this._totalEntities;
    }

    protected void onEntitiesMerged(MaltegoEntity destBefore, MaltegoEntity destAfter, MaltegoEntity src) {
        super.onEntitiesMerged(destBefore, destAfter, src);
        if (!destAfter.isCopy((MaltegoPart)destBefore)) {
            ModifiedHelper.updateModified(this._user, (MaltegoPart<? extends Guid>)destAfter);
            this._mergedEntities.put(destBefore, destAfter);
        }
        ++this._totalEntities;
    }

    protected void onLinkAdded(MaltegoLink dest, MaltegoLink src) {
        super.onLinkAdded(dest, src);
        this._addedLinks.add(dest);
        ModifiedHelper.updateCreated(this._user, (MaltegoPart<? extends Guid>)dest);
        ModifiedHelper.updateModified(this._user, (MaltegoPart<? extends Guid>)dest);
    }

    protected void onLinksMerged(MaltegoLink destBefore, MaltegoLink destAfter, MaltegoLink src) {
        super.onLinksMerged(destBefore, destAfter, src);
        if (!destAfter.isCopy((MaltegoPart)destBefore)) {
            ModifiedHelper.updateModified(this._user, (MaltegoPart<? extends Guid>)destAfter);
            this._mergedLinks.put(destBefore, destAfter);
        }
    }

    private void setMissingCentersToParentCenter(GraphStore graphStore, Map<String, Map<EntityID, Point>> centers) throws GraphStoreException {
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
        GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
        for (Map.Entry<String, Map<EntityID, Point>> viewEntry : centers.entrySet()) {
            Map<EntityID, Point> value = viewEntry.getValue();
            for (Map.Entry<EntityID, Point> entry : value.entrySet()) {
                EntityID entityID = entry.getKey();
                Point center = entry.getValue();
                if (center != null) continue;
                Point parentCenter = null;
                Set parents = structureReader.getParents(entityID);
                if (parents != null && !parents.isEmpty()) {
                    parentCenter = layoutReader.getCenter((EntityID)parents.iterator().next());
                }
                if (parentCenter == null) continue;
                entry.setValue(parentCenter);
                layoutWriter.setCenter(entityID, parentCenter);
            }
        }
    }
}

