/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.transactions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.EntityUpdate;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.LinkUpdate;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.ui.graph.transactions.GraphOperation;
import com.paterva.maltego.ui.graph.transactions.GraphPositionAndPathHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransaction;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.GraphTransactions;
import com.paterva.maltego.ui.graph.view2d.ViewGraphName;
import com.paterva.maltego.util.SimilarStrings;
import java.awt.Point;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import y.base.Graph;

public class TransactionBatchFactory {
    private TransactionBatchFactory() {
    }

    public static GraphTransactionBatch createReverseLinksBatch(GraphID graphID, Set<LinkID> linkIDs) {
        SimilarStrings description = new SimilarStrings("Reverse " + GraphTransactionHelper.getDescriptionForLinkIDs(graphID, linkIDs, true));
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        Map connections = GraphStoreHelper.getConnectionLinks((GraphID)graphID, Collections.emptySet(), linkIDs);
        HashMap<MaltegoLink, LinkEntityIDs> newConnections = new HashMap<MaltegoLink, LinkEntityIDs>(connections.size());
        for (Map.Entry entry : connections.entrySet()) {
            MaltegoLink link;
            LinkEntityIDs ids = (LinkEntityIDs)entry.getValue();
            LinkEntityIDs connection = new LinkEntityIDs(ids.getTargetID(), ids.getSourceID());
            link.setReversed(Boolean.valueOf(!Boolean.TRUE.equals((link = ((MaltegoLink)entry.getKey()).createCopy()).isReversed())));
            newConnections.put(link, connection);
        }
        batch.add(GraphTransactions.deleteLinks(linkIDs));
        batch.add(GraphTransactions.addLinks(newConnections));
        return batch;
    }

    public static GraphTransactionBatch createUpdateBatch(SimilarStrings description, Map<MaltegoEntity, MaltegoEntity> beforeAfterEntities, Map<MaltegoLink, MaltegoLink> beforeAfterLinks) {
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        List<GraphTransaction> transactions = GraphTransactionHelper.createUpdateTransactions(beforeAfterEntities, beforeAfterLinks);
        for (GraphTransaction transaction : transactions) {
            batch.add(transaction);
        }
        return batch;
    }

    public static GraphTransactionBatch createEntityUpdateBatch(SimilarStrings description, MaltegoEntity before, MaltegoEntity after) {
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        batch.addAll(GraphTransactionHelper.createUpdateTransactions(before, after));
        return batch;
    }

    public static GraphTransactionBatch createLinkUpdateBatch(SimilarStrings description, MaltegoLink before, MaltegoLink after) {
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        batch.addAll(GraphTransactionHelper.createUpdateTransactions(before, after));
        return batch;
    }

    public static GraphTransactionBatch createPostitionAndPathsBatch(SimilarStrings description, Graph viewGraph, Set<EntityUpdate> entityUpdates, Set<LinkUpdate> linkUpdates, Map<EntityID, Point> centers, Map<LinkID, List<Point>> paths, boolean isSignificant) {
        GraphTransactionBatch batch = new GraphTransactionBatch(description, isSignificant, new GraphTransaction[0]);
        String graphName = ViewGraphName.get(viewGraph);
        Map<String, Map<EntityID, Point>> allCenters = Collections.singletonMap(graphName, centers);
        Map<String, Map<LinkID, List<Point>>> allPaths = Collections.singletonMap(graphName, paths);
        batch.add(GraphTransactions.updateCentersAndPaths(entityUpdates, linkUpdates, allCenters, allPaths));
        return batch;
    }

    public static GraphTransactionBatch createBookmarkChangeBatch(SimilarStrings description, Set<EntityID> entityIDs, int bookmark) {
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        batch.add(GraphTransactions.changeBookmark(entityIDs, bookmark));
        return batch;
    }

    public static GraphTransactionBatch createForGraph(SimilarStrings description, GraphID graphID) {
        Set entityIDs = GraphStoreHelper.getEntityIDs((GraphID)graphID);
        Set linkIDs = GraphStoreHelper.getLinkIDs((GraphID)graphID);
        GraphTransactionBatch batch = new GraphTransactionBatch(description, true, new GraphTransaction[0]);
        Set<MaltegoEntity> entities = GraphTransactionHelper.getGraphEntities(graphID, entityIDs, false);
        if (!entities.isEmpty()) {
            Set<MaltegoLink> links = GraphTransactionHelper.getGraphLinks(graphID, linkIDs, false);
            Map connectionIDs = GraphStoreHelper.getConnectionsForIDs((GraphID)graphID, Collections.emptySet(), (Set)GraphStoreHelper.getLinkIDs((GraphID)graphID));
            Map<String, Map<EntityID, Point>> allCenters = GraphPositionAndPathHelper.getAllCenters(graphID, (Set<EntityID>)GraphStoreHelper.getIds(entities));
            Map<String, Map<LinkID, List<Point>>> allPaths = GraphPositionAndPathHelper.getAllPaths(graphID, (Set<LinkID>)GraphStoreHelper.getIds(links));
            Map pinned = GraphStoreHelper.isPinned((GraphID)graphID, (Set)entityIDs);
            batch.add(GraphTransactions.create(GraphOperation.Add, entities, links, allCenters, allPaths, connectionIDs, pinned, false));
        }
        return batch;
    }
}

