/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkEntityIDs;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureWriter;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreWriter;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import java.awt.HeadlessException;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.windows.TopComponent;
import y.base.Node;
import y.view.Graph2D;
import y.view.Graph2DView;

public class NewGraphOrTempStructureChanges {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<EntityID, EntityID> add(GraphID srcGraphID, GraphID destGraphID, Set<EntityID> entityIDs, boolean keepPositions) {
        HashMap<EntityID, EntityID> entityMap = new HashMap<EntityID, EntityID>();
        GraphStore destGraphStore = null;
        try {
            destGraphStore = GraphStoreRegistry.getDefault().forGraphID(destGraphID);
            destGraphStore.beginUpdate();
            Map<EntityID, Point> srcCenters = keepPositions ? NewGraphOrTempStructureChanges.getCenters(srcGraphID, entityIDs) : NewGraphOrTempStructureChanges.calculateCenters(entityIDs);
            HashMap<MaltegoEntity, Guid> destEntityToSrcIdMap = new HashMap<MaltegoEntity, Guid>();
            Set srcEntities = GraphStoreHelper.getMaltegoEntities((GraphID)srcGraphID, entityIDs);
            for (MaltegoEntity srcEntity : srcEntities) {
                MaltegoEntity destEntity = srcEntity.createCopy();
                entityMap.put((EntityID)srcEntity.getID(), (EntityID)destEntity.getID());
                destEntityToSrcIdMap.put(destEntity, srcEntity.getID());
            }
            GraphStore srcGraphStore = GraphStoreRegistry.getDefault().forGraphID(srcGraphID);
            GraphStructureReader srcStructureReader = srcGraphStore.getGraphStructureStore().getStructureReader();
            Map srcPinned = srcStructureReader.getPinned(entityMap.keySet());
            HashMap<EntityID, Point> destCenters = new HashMap<EntityID, Point>(srcCenters.size());
            for (Map.Entry<EntityID, Point> entry : srcCenters.entrySet()) {
                EntityID srcEntityID = entry.getKey();
                Point center = entry.getValue();
                destCenters.put((EntityID)entityMap.get(srcEntityID), center);
            }
            HashMap<EntityID, Boolean> destPinned = new HashMap<EntityID, Boolean>(srcPinned.size());
            for (Map.Entry entry : srcPinned.entrySet()) {
                EntityID srcEntityID = (EntityID)entry.getKey();
                Boolean pinned = (Boolean)entry.getValue();
                destPinned.put((EntityID)entityMap.get(srcEntityID), pinned);
            }
            NewGraphOrTempStructureChanges.addEntitiesToGraph(destGraphID, destEntityToSrcIdMap.keySet(), destCenters, destPinned);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (destGraphStore != null) {
                destGraphStore.endUpdate(null);
            }
        }
        return entityMap;
    }

    public static void addWithLinks(GraphID srcGraphID, Graph2D destGraph, Set<EntityID> entityIDs, boolean keepPositions) {
        GraphID destGraphID = GraphViewManager.getDefault().getGraphID(destGraph);
        NewGraphOrTempStructureChanges.addWithLinks(srcGraphID, destGraphID, entityIDs, keepPositions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addWithLinks(GraphID srcGraphID, GraphID destGraphID, Set<EntityID> entityIDs, boolean keepPositions) {
        if (entityIDs.isEmpty()) {
            return;
        }
        GraphStore destGraphStore = null;
        try {
            destGraphStore = GraphStoreRegistry.getDefault().forGraphID(destGraphID);
            destGraphStore.beginUpdate();
            Map<EntityID, EntityID> entityMap = NewGraphOrTempStructureChanges.add(srcGraphID, destGraphID, entityIDs, keepPositions);
            GraphStore srcGraphStore = GraphStoreRegistry.getDefault().forGraphID(srcGraphID);
            GraphDataStoreReader srcDataReader = srcGraphStore.getGraphDataStore().getDataStoreReader();
            GraphStructureReader srcStructureReader = srcGraphStore.getGraphStructureStore().getStructureReader();
            HashMap<MaltegoLink, LinkEntityIDs> links = new HashMap<MaltegoLink, LinkEntityIDs>();
            for (LinkID linkID : srcStructureReader.getLinks()) {
                EntityID destTarget;
                EntityID srcSource = srcStructureReader.getSource(linkID);
                EntityID srcTarget = srcStructureReader.getTarget(linkID);
                EntityID destSource = entityMap.get(srcSource);
                if (destSource == null || (destTarget = entityMap.get(srcTarget)) == null) continue;
                MaltegoLink link = srcDataReader.getLink(linkID).createCopy();
                links.put(link, new LinkEntityIDs(destSource, destTarget));
            }
            GraphStoreWriter.addLinks((GraphID)destGraphID, links);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (destGraphStore != null) {
                destGraphStore.endUpdate(null);
            }
        }
    }

    public static void addEntities(GraphID graphID, Collection<MaltegoEntity> entities, boolean pinned, boolean layout) {
        HashMap<EntityID, Boolean> pinnedMap = new HashMap<EntityID, Boolean>();
        for (MaltegoEntity entity : entities) {
            pinnedMap.put((EntityID)entity.getID(), pinned);
        }
        NewGraphOrTempStructureChanges.addEntities(graphID, entities, pinnedMap, layout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEntities(GraphID graphID, Collection<MaltegoEntity> entities, Map<EntityID, Boolean> pinned, boolean layout) {
        GraphStore graphStore = null;
        try {
            graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            graphStore.beginUpdate();
            Map<EntityID, Point> centers = NewGraphOrTempStructureChanges.calculateCenters(entities);
            NewGraphOrTempStructureChanges.addEntitiesToGraph(graphID, entities, centers, pinned);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            if (graphStore != null) {
                graphStore.endUpdate((Object)layout);
            }
        }
    }

    private static void addEntitiesToGraph(GraphID graphID, Collection<MaltegoEntity> entities, Map<EntityID, Point> centers, Map<EntityID, Boolean> pinned) throws GraphStoreException {
        GraphStoreWriter.addEntities((GraphID)graphID, entities);
        NewGraphOrTempStructureChanges.setCenters(graphID, entities, centers);
        NewGraphOrTempStructureChanges.setPinned(graphID, pinned);
    }

    public static Map<MaltegoEntity, Node> getNodes(GraphWrapper wrapper, Collection<MaltegoEntity> entities) {
        HashMap<MaltegoEntity, Node> map = new HashMap<MaltegoEntity, Node>(entities.size());
        for (MaltegoEntity entity : entities) {
            map.put(entity, wrapper.node((EntityID)entity.getID()));
        }
        return map;
    }

    private static void setCenters(GraphID graphID, Collection<MaltegoEntity> entities, Map<EntityID, Point> centers) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphLayoutWriter layoutWriter = graphStore.getGraphLayoutStore().getLayoutWriter();
        layoutWriter.setCenters(centers);
    }

    private static Map<EntityID, Point> getCenters(GraphID graphID, Set<EntityID> entityIDs) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphLayoutReader layoutReader = graphStore.getGraphLayoutStore().getLayoutReader();
        Map centers = layoutReader.getCenters(entityIDs);
        HashSet<EntityID> entitiesWithoutCenters = new HashSet<EntityID>();
        for (Map.Entry entry : centers.entrySet()) {
            EntityID entityID = (EntityID)entry.getKey();
            Point center = (Point)entry.getValue();
            if (center != null) continue;
            entitiesWithoutCenters.add(entityID);
        }
        centers.putAll(NewGraphOrTempStructureChanges.calculateCenters(entitiesWithoutCenters));
        return centers;
    }

    public static Map<EntityID, Point> calculateCenters(Set<EntityID> entityIDs) {
        int count = entityIDs.size();
        Point[] points = NewGraphOrTempStructureChanges.calculateCenters(count);
        HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>();
        int num = 0;
        for (EntityID entityID : entityIDs) {
            centers.put(entityID, points[num]);
            ++num;
        }
        return centers;
    }

    public static Map<EntityID, Point> calculateCenters(Collection<MaltegoEntity> entities) {
        int count = entities.size();
        Point[] points = NewGraphOrTempStructureChanges.calculateCenters(count);
        HashMap<EntityID, Point> centers = new HashMap<EntityID, Point>();
        int num = 0;
        for (MaltegoEntity entity : entities) {
            centers.put((EntityID)entity.getID(), points[num]);
            ++num;
        }
        return centers;
    }

    private static Point[] calculateCenters(int count) throws HeadlessException {
        JComponent viewControl;
        GraphViewCookie cookie;
        int spacing = 120;
        double baseX = 0.0;
        double baseY = 0.0;
        TopComponent tc = GraphEditorRegistry.getDefault().getTopmost();
        if (tc != null && (cookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null && (viewControl = cookie.getGraphView().getViewControl()).isShowing() && viewControl instanceof Graph2DView) {
            Graph2DView view = (Graph2DView)viewControl;
            Point cursorPosition = MouseInfo.getPointerInfo().getLocation();
            Point min = viewControl.getLocationOnScreen();
            Rectangle bounds = viewControl.getBounds();
            bounds.translate(min.x, min.y);
            if (!bounds.contains(cursorPosition)) {
                SwingUtilities.convertPointFromScreen(min, viewControl);
                baseX = view.toWorldCoordX(min.x) + 60.0;
                baseY = view.toWorldCoordY(min.y) + 60.0;
            } else {
                SwingUtilities.convertPointFromScreen(cursorPosition, viewControl);
                baseX = view.toWorldCoordX(cursorPosition.x);
                baseY = view.toWorldCoordY(cursorPosition.y);
            }
        }
        int columns = (int)Math.ceil(Math.sqrt(count));
        int index = 0;
        Point[] points = new Point[count];
        double y = baseY;
        for (int row = 0; row < columns; ++row) {
            double x = baseX;
            for (int col = 0; col < columns; ++col) {
                if (index < points.length) {
                    points[index] = new Point((int)x, (int)y);
                }
                ++index;
                x += 120.0;
            }
            y += 120.0;
        }
        return points;
    }

    private static void setPinned(GraphID graphID, Map<EntityID, Boolean> pinned) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureWriter structureWriter = graphStore.getGraphStructureStore().getStructureWriter();
        structureWriter.setPinned(pinned);
    }
}

