/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.TopGraphViewRegistry;
import com.paterva.maltego.ui.graph.actions.NewGraphAction;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.actions.ZoomToFitAction;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLayouter;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import org.openide.util.NbPreferences;
import org.openide.util.actions.SystemAction;
import y.layout.Layouter;
import y.view.Graph2D;
import y.view.Graph2DLayoutExecutor;
import y.view.Graph2DView;

public abstract class CopyToNewGraphAction
extends TopGraphEntitySelectionAction {
    public static final String PREF_RELAYOUT_AFTER_COPY = "maltego.relayout-after-copy";

    public static boolean isRelayoutAfterCopy() {
        return CopyToNewGraphAction.getPrefs().getBoolean(PREF_RELAYOUT_AFTER_COPY, true);
    }

    public static void setRelayoutAfterCopy(boolean relayout) {
        CopyToNewGraphAction.getPrefs().putBoolean(PREF_RELAYOUT_AFTER_COPY, relayout);
    }

    private static Preferences getPrefs() {
        return NbPreferences.forModule(CopyToNewGraphAction.class);
    }

    @Override
    protected void actionPerformed() {
        GraphID topGraphID = this.getTopGraphID();
        Set<EntityID> selectedModelEntities = this.getSelectedModelEntities();
        TopGraphViewRegistry.getDefault().addPropertyChangeListener(new OpenHandler(topGraphID, selectedModelEntities));
        ((NewGraphAction)SystemAction.get(NewGraphAction.class)).performAction();
    }

    protected abstract void performCopy(GraphID var1, GraphID var2, Set<EntityID> var3);

    private void relayoutNewGraph(Graph2DView view) {
        new Graph2DLayoutExecutor(7).doLayout(view, (Layouter)new MaltegoLayouter());
    }

    private class OpenHandler
    implements PropertyChangeListener {
        private final GraphID _srcGraphID;
        private final Set<EntityID> _entityIDs;

        public OpenHandler(GraphID srcGraphID, Set<EntityID> entityIDs) {
            this._srcGraphID = srcGraphID;
            this._entityIDs = entityIDs;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TopGraphViewRegistry registry;
            GraphView graphView;
            if ("topGraphViewChanged".equals(evt.getPropertyName()) && (graphView = (registry = TopGraphViewRegistry.getDefault()).getTopGraphView()) != null) {
                registry.removePropertyChangeListener(this);
                Graph2D destGraph = graphView.getViewGraph();
                GraphID destGraphID = GraphIDProvider.forGraph((Graph2D)destGraph);
                CopyToNewGraphAction.this.performCopy(this._srcGraphID, destGraphID, this._entityIDs);
                if (CopyToNewGraphAction.isRelayoutAfterCopy()) {
                    JComponent viewControl = graphView.getViewControl();
                    if (viewControl instanceof Graph2DView) {
                        Graph2DView graph2DView = (Graph2DView)viewControl;
                        CopyToNewGraphAction.this.relayoutNewGraph(graph2DView);
                    }
                } else {
                    ((ZoomToFitAction)SystemAction.get(ZoomToFitAction.class)).actionPerformed((ActionEvent)null);
                }
            }
        }
    }
}

