/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import com.paterva.maltego.ui.graph.clipboard.EntityTypeValueListCopyAction;
import com.paterva.maltego.ui.graph.clipboard.EntityTypeValuePropertyListCopyAction;
import com.paterva.maltego.ui.graph.clipboard.EntityTypeValueWeightListCopyAction;
import com.paterva.maltego.ui.graph.clipboard.EntityValueListCopyAction;
import com.paterva.maltego.ui.graph.clipboard.GraphCopyAction;
import com.paterva.maltego.ui.graph.clipboard.GraphMLCopyAction;
import com.paterva.maltego.ui.graph.nodes.CopyToNewGraphWithLinksAction;
import com.paterva.maltego.ui.graph.nodes.CopyToNewGraphWithNeighboursAction;
import com.paterva.maltego.ui.graph.nodes.CopyToNewGraphWithoutLinksAction;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import com.pinkmatter.modules.flamingo.ActionAdapters;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public class CopyRibbonAction
extends TopGraphSelectionContextAction
implements RibbonPresenter.Button {
    private JCommandButton _button;

    @Override
    protected void actionPerformed(GraphView graphView) {
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    public String getName() {
        return "Copy";
    }

    protected String iconResource() {
        return "com/paterva/maltego/welcome/resources/Copy.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            String shortcut = StringUtilities.getCtrlShortcut((String)"C");
            String descr = "Copy the selected part of the graph to the clipboard. You can paste the graph into a text editor in XML format (and vice versa). (" + shortcut + ")";
            RichTooltip tooltip = new RichTooltip(this.getName(), descr);
            tooltip.setMainImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Copy48.png"));
            tooltip.addFooterSection("Click the help button to get more help on Maltego features");
            tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip(tooltip);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GraphCopyAction delegate = (GraphCopyAction)SystemAction.get(GraphCopyAction.class);
                    delegate.actionPerformed(e);
                }
            });
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return CopyRibbonAction.this.createPopup();
                }
            });
        }
        return this._button;
    }

    private JCommandPopupMenu createPopup() {
        JCommandMenuButton button = new JCommandMenuButton("To New Graph", null);
        button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
        button.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
        button.setPopupCallback((PopupPanelCallback)new NewGraphPopupCallback());
        JCommandPopupMenu menu = new JCommandPopupMenu();
        menu.addMenuButton(this.createMenuButton(SystemAction.get(GraphMLCopyAction.class)));
        menu.addMenuButton(this.createMenuButton(SystemAction.get(EntityValueListCopyAction.class)));
        menu.addMenuButton(this.createMenuButton(SystemAction.get(EntityTypeValueListCopyAction.class)));
        menu.addMenuButton(this.createMenuButton(SystemAction.get(EntityTypeValueWeightListCopyAction.class)));
        menu.addMenuButton(this.createMenuButton(SystemAction.get(EntityTypeValuePropertyListCopyAction.class)));
        menu.addMenuButton(button);
        return menu;
    }

    private JCommandMenuButton createMenuButton(SystemAction action) {
        return new ActionAdapters.MenuButton(null, action.getName(), (Action)action, JCommandButton.CommandButtonKind.ACTION_ONLY);
    }

    private static class NeighboursAction
    extends AbstractAction {
        private final int _depth;
        private final CopyToNewGraphWithNeighboursAction.Family _family;

        public NeighboursAction(int depth, CopyToNewGraphWithNeighboursAction.Family family) {
            this._depth = depth;
            this._family = family;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CopyToNewGraphWithNeighboursAction action = (CopyToNewGraphWithNeighboursAction)SystemAction.get(CopyToNewGraphWithNeighboursAction.class);
            if (action != null) {
                action.setDepth(this._depth);
                action.setFamily(this._family);
                action.actionPerformed(e);
            }
        }
    }

    private static class FamilyPopupCallback
    implements PopupPanelCallback {
        private final CopyToNewGraphWithNeighboursAction.Family _family;

        public FamilyPopupCallback(CopyToNewGraphWithNeighboursAction.Family family) {
            this._family = family;
        }

        public JPopupPanel getPopupPanel(JCommandButton commandButton) {
            JCommandPopupMenu familyMenu = new JCommandPopupMenu();
            for (int i = 1; i <= 5; ++i) {
                JCommandMenuButton menuButton = new JCommandMenuButton(Integer.toString(i), null);
                menuButton.addActionListener((ActionListener)new NeighboursAction(i, this._family));
                familyMenu.addMenuButton(menuButton);
            }
            return familyMenu;
        }
    }

    private static class NeighboursPopupCallback
    implements PopupPanelCallback {
        private NeighboursPopupCallback() {
        }

        public JPopupPanel getPopupPanel(JCommandButton jcb) {
            JCommandPopupMenu subMenu = new JCommandPopupMenu();
            for (CopyToNewGraphWithNeighboursAction.Family family : CopyToNewGraphWithNeighboursAction.Family.values()) {
                String familyName = CopyToNewGraphWithNeighboursAction.getFamilyName(family);
                JCommandMenuButton familyButton = new JCommandMenuButton(familyName, null);
                familyButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
                familyButton.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
                familyButton.setPopupCallback((PopupPanelCallback)new FamilyPopupCallback(family));
                subMenu.addMenuButton(familyButton);
            }
            return subMenu;
        }
    }

    private class NewGraphPopupCallback
    implements PopupPanelCallback {
        private NewGraphPopupCallback() {
        }

        public JPopupPanel getPopupPanel(JCommandButton jcb) {
            JCommandPopupMenu subMenu = new JCommandPopupMenu();
            JCommandMenuButton withLinks = CopyRibbonAction.this.createMenuButton(SystemAction.get(CopyToNewGraphWithLinksAction.class));
            JCommandMenuButton withoutLinks = CopyRibbonAction.this.createMenuButton(SystemAction.get(CopyToNewGraphWithoutLinksAction.class));
            withLinks.setText("With Links");
            withoutLinks.setText("Without Links");
            subMenu.addMenuButton(withLinks);
            subMenu.addMenuButton(withoutLinks);
            subMenu.addMenuButton(this.createNeighbourButton());
            return subMenu;
        }

        private JCommandMenuButton createNeighbourButton() {
            JCommandMenuButton button = new JCommandMenuButton("With Neighbours", null);
            button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            button.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
            button.setPopupCallback((PopupPanelCallback)new NeighboursPopupCallback());
            return button;
        }
    }
}

