/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.core.OverlayDescriptorSet;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpecDisplayNameComparator;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.nodes.ChangeTypePanel;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.TransactionBatchFactory;
import com.paterva.maltego.ui.graph.view2d.LegendBackgroundRenderer;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.StringUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.windows.TopComponent;
import y.view.BackgroundRenderer;
import y.view.Graph2DView;

public class ChangeTypeUtil {
    private static final Logger LOG = Logger.getLogger(ChangeTypeUtil.class.getName());

    private ChangeTypeUtil() {
    }

    public static List<MaltegoEntitySpec> getSortedVisibleSpecs(GraphID graphID) {
        ArrayList<MaltegoEntitySpec> specs = new ArrayList<MaltegoEntitySpec>(EntityRegistry.forGraphID((GraphID)graphID).getAllVisible());
        Iterator it = specs.iterator();
        while (it.hasNext()) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)it.next();
            if (spec.isToolboxItem()) continue;
            it.remove();
        }
        Collections.sort(specs, new TypeSpecDisplayNameComparator());
        return specs;
    }

    public static MaltegoEntitySpec showChangeTypePanel(GraphID graphID, MaltegoEntitySpec oldSpec) {
        ChangeTypePanel panel = new ChangeTypePanel(graphID);
        panel.setEntitySpec(oldSpec);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, "Choose New Entity Type", true, 2, DialogDescriptor.OK_OPTION, null);
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
            return panel.getEntitySpec();
        }
        return null;
    }

    public static void changeTypes(GraphID graphID, Collection<EntityID> entityIDs, MaltegoEntitySpec spec) {
        EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
        HashMap<MaltegoEntity, MaltegoEntity> beforeAfterEntities = new HashMap<MaltegoEntity, MaltegoEntity>(entityIDs.size());
        String user = GraphUser.getUser(graphID);
        Set entities = GraphStoreHelper.getMaltegoEntities((GraphID)graphID, entityIDs);
        for (MaltegoEntity entity : entities) {
            MaltegoEntity entityBefore = entity.createClone();
            MaltegoEntity entityAfter = entity.createClone();
            PropertyDescriptor entityValuePd = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entityBefore, (boolean)true);
            Object entityValue = entityBefore.getValue(entityValuePd);
            ChangeTypeUtil.addTypeProperties(registry, spec, entityAfter);
            entityAfter.setTypeName(spec.getTypeName());
            ChangeTypeUtil.resetSpecialPropertyMappings(entityAfter);
            ChangeTypeUtil.transferValueProperty(registry, entityAfter, entityValuePd, entityValue);
            if (entityBefore.getOverlaySet() != null) {
                entityBefore.getOverlaySet().clear();
                OverlayDescriptorSet specOverlays = spec.getOverlaySet();
                if (specOverlays != null) {
                    specOverlays.forEach(overlay -> entityBefore.addOverlay(overlay));
                }
            }
            if (!entityBefore.isCopy((MaltegoPart)entityAfter)) {
                ModifiedHelper.updateModified(user, (MaltegoPart<? extends Guid>)entityAfter);
            }
            beforeAfterEntities.put(entityBefore, entityAfter);
        }
        String descriptionStr = "Change type of " + GraphTransactionHelper.getDescriptionForEntities(graphID, beforeAfterEntities.keySet(), true) + "%s";
        SimilarStrings description = new SimilarStrings(descriptionStr, " to " + spec.getDisplayName(), "");
        GraphTransactionBatch batch = TransactionBatchFactory.createUpdateBatch(description, beforeAfterEntities, Collections.emptyMap());
        if (!batch.isEmpty()) {
            GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
        }
        ChangeTypeUtil.updateSloppyLegend();
    }

    private static void addTypeProperties(EntityRegistry registry, MaltegoEntitySpec spec, MaltegoEntity entity) {
        DisplayDescriptorCollection ddc = InheritanceHelper.getAggregatedProperties((SpecRegistry)registry, (String)spec.getTypeName());
        for (DisplayDescriptor dd : ddc) {
            String propName = dd.getName();
            PropertyDescriptor destPropDescriptor = entity.getProperties().get(propName);
            if (destPropDescriptor == null) {
                entity.addProperty((PropertyDescriptor)dd);
                entity.setValue((PropertyDescriptor)dd, dd.getDefaultValue());
                continue;
            }
            TypeDescriptor propType = dd.getTypeDescriptor();
            Object value = entity.getValue((PropertyDescriptor)dd);
            if (!destPropDescriptor.getType().equals(propType.getType())) {
                entity.removeProperty(propName);
                entity.addProperty((PropertyDescriptor)dd);
            }
            if (value != null) {
                try {
                    value = Converter.convert((Object)value, (Class)propType.getType());
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "Failed to convert value {0} to type {1}", new Object[]{value, propType});
                    value = propType.getDefaultValue();
                }
            } else if (!dd.isNullable()) {
                value = propType.getDefaultValue();
            }
            entity.setValue((PropertyDescriptor)dd, value);
        }
    }

    private static void transferValueProperty(EntityRegistry registry, MaltegoEntity entity, PropertyDescriptor oldPd, Object oldValue) {
        PropertyDescriptor entityValuePd = InheritanceHelper.getValueProperty((SpecRegistry)registry, (TypedPropertyBag)entity, (boolean)true);
        if (!entityValuePd.equals(oldPd) && entityValuePd.getType().equals(oldPd.getType())) {
            entity.setValue(entityValuePd, oldValue);
        }
    }

    private static void resetSpecialPropertyMappings(MaltegoEntity entity) {
        entity.setDisplayValueExpression(null);
        entity.setValueProperty(null);
    }

    public static Map<String, List<MaltegoEntitySpec>> getGroupedSpecs(GraphID graphID) {
        List<MaltegoEntitySpec> specs = ChangeTypeUtil.getSortedVisibleSpecs(graphID);
        HashMap<String, List<MaltegoEntitySpec>> groupedSpecs = new HashMap<String, List<MaltegoEntitySpec>>();
        for (MaltegoEntitySpec spec : specs) {
            ArrayList<MaltegoEntitySpec> categorySpecs;
            String category = spec.getDefaultCategory();
            if (StringUtilities.isNullOrEmpty((String)category)) {
                category = "(No category)";
            }
            if ((categorySpecs = (ArrayList<MaltegoEntitySpec>)groupedSpecs.get(category)) == null) {
                categorySpecs = new ArrayList<MaltegoEntitySpec>();
            }
            categorySpecs.add(spec);
            groupedSpecs.put(category, categorySpecs);
        }
        return groupedSpecs;
    }

    private static void updateSloppyLegend() {
        Graph2DView view;
        BackgroundRenderer bgRenderer;
        JComponent viewControl;
        GraphViewCookie cookie;
        TopComponent active = GraphEditorRegistry.getDefault().getActive();
        if (active != null && (cookie = (GraphViewCookie)active.getLookup().lookup(GraphViewCookie.class)) != null && (viewControl = cookie.getGraphView().getViewControl()) instanceof Graph2DView && (bgRenderer = (view = (Graph2DView)viewControl).getBackgroundRenderer()) instanceof LegendBackgroundRenderer) {
            ((LegendBackgroundRenderer)bgRenderer).setNeedsRecalc();
        }
    }
}

