/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.nodes;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.ui.graph.actions.TopGraphEntitySelectionAction;
import com.paterva.maltego.ui.graph.nodes.ChangeTypeUtil;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.menu.MenuUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.Presenter;

public class ChangeTypePopupAction
extends TopGraphEntitySelectionAction
implements Presenter.Menu,
Presenter.Popup {
    public ChangeTypePopupAction() {
        this.putValue("position", 300);
    }

    @Override
    protected void actionPerformed() {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        GraphID graphID = this.getTopGraphID();
        Set<EntityID> entities = this.getSelectedModelEntities();
        JMenu menu = new JMenu(this.getName());
        if (entities.isEmpty()) {
            return menu;
        }
        Map<String, List<MaltegoEntitySpec>> groupedSpecs = ChangeTypeUtil.getGroupedSpecs(graphID);
        ArrayList<String> categories = new ArrayList<String>(groupedSpecs.keySet());
        Collections.sort(categories);
        int MAX_PER_MENU = 30;
        JMenu currentCategoryMenu = menu;
        for (String category : categories) {
            JMenu categoryMenu;
            List<MaltegoEntitySpec> specs = groupedSpecs.get(category);
            JMenu currentTypeMenu = categoryMenu = new JMenu(category);
            for (MaltegoEntitySpec spec : specs) {
                ChangeTypeMenuAction action = new ChangeTypeMenuAction(graphID, entities, spec);
                currentTypeMenu = MenuUtils.overflowIfNeeded((JMenu)currentTypeMenu, (int)30);
                currentTypeMenu.add(action);
            }
            currentCategoryMenu = MenuUtils.overflowIfNeeded((JMenu)currentCategoryMenu, (int)30);
            currentCategoryMenu.add(categoryMenu);
        }
        menu.setIcon(new ImageIcon(ImageUtilities.loadImage((String)this.iconResource())));
        return menu;
    }

    public String getName() {
        return "Change Type";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/resources/ChangeType.png";
    }

    private static class ChangeTypeMenuAction
    extends AbstractAction {
        private final GraphID _graphID;
        private final Collection<EntityID> _entities;
        private final MaltegoEntitySpec _spec;

        public ChangeTypeMenuAction(GraphID graphID, Collection<EntityID> entities, MaltegoEntitySpec spec) {
            super(spec.getDisplayName(), EntityImageFactory.forGraph((GraphID)graphID).getSmallTypeIcon(spec.getTypeName()));
            this._graphID = graphID;
            this._entities = entities;
            this._spec = spec;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                WindowUtil.showWaitCursor();
                ChangeTypeUtil.changeTypes(this._graphID, this._entities, this._spec);
                GraphSelection selection = GraphSelection.forGraph((GraphID)this._graphID);
                selection.setSelectedModelEntities(Collections.emptySet());
                selection.setSelectedModelEntities(this._entities);
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }
}

