/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.ui.graph.data.GraphDataObject;
import com.paterva.maltego.ui.graph.view2d.controls.AddOnPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.JPanel;

class ViewPanel
extends JPanel {
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    public static final String EAST = "east";
    public static final String WEST = "west";
    private final JPanel _innerPanel;
    private final JPanel _mainViewAndSideBar;
    private final AddOnPanel _addOnPanel;

    public ViewPanel(GraphDataObject gdo) {
        this.setLayout(new BorderLayout());
        this._mainViewAndSideBar = new JPanel(new BorderLayout());
        this.add((Component)this._mainViewAndSideBar, "Center");
        this._innerPanel = new JPanel(new CardLayout());
        this._mainViewAndSideBar.add((Component)this._innerPanel, "Center");
        this._addOnPanel = new AddOnPanel(gdo);
        this.add((Component)this._addOnPanel, "South");
    }

    public void addMainView(Component component, String name) {
        this._innerPanel.add(component, name);
    }

    public void selectMainView(String name) {
        CardLayout layout = (CardLayout)this._innerPanel.getLayout();
        layout.show(this._innerPanel, name);
    }

    public void addSideBar(Component component, String position) {
        String p = this.translatePosition(position);
        if (p != null) {
            this._mainViewAndSideBar.add(component, p);
            this.validate();
        }
    }

    public void removeSideBar(Component component) {
        this._mainViewAndSideBar.remove(component);
    }

    private String translatePosition(String position) {
        if (NORTH.equals(position)) {
            return "North";
        }
        if (SOUTH.equals(position)) {
            return "South";
        }
        if (EAST.equals(position)) {
            return "East";
        }
        if (WEST.equals(position)) {
            return "West";
        }
        return null;
    }

    public void removeSideBar(String position) {
        String p = this.translatePosition(position);
        if (p != null) {
            BorderLayout layout = (BorderLayout)this._mainViewAndSideBar.getLayout();
            Component c = layout.getLayoutComponent(p);
            if (c != null) {
                this.removeSideBar(c);
            }
            this.validate();
        }
    }

    public void componentShowing() {
        this._addOnPanel.componentShowing();
    }

    public void componentHidden() {
        this._addOnPanel.componentHidden();
    }
}

