/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.undo.UndoRedoManager;
import com.paterva.maltego.graph.undo.UndoRedoModel;
import com.paterva.maltego.util.ui.WindowUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.openide.awt.UndoRedo;
import org.openide.util.ChangeSupport;

public class GraphViewElementUndoRedo
implements UndoRedo {
    private GraphID _graphID;
    private final ChangeSupport _undoChangeSupport = new ChangeSupport((Object)this);
    private ChangeListener _undoRedoListener;
    private UndoRedoModel _undoRedo;

    void setGraphID(GraphID graphID) {
        this._graphID = graphID;
        this._undoRedo = UndoRedoManager.getDefault().get(graphID);
        this._undoRedoListener = new GraphUndoRedoListener();
        this._undoRedo.addChangeListener(this._undoRedoListener);
        GraphLifeCycleManager.getDefault().addPropertyChangeListener((PropertyChangeListener)new GraphCloseListener());
        this._undoChangeSupport.fireChange();
    }

    public boolean canUndo() {
        boolean canUndo = this._undoRedo != null ? this._undoRedo.canUndo() : false;
        return canUndo;
    }

    public boolean canRedo() {
        boolean canRedo = this._undoRedo != null ? this._undoRedo.canRedo() : false;
        return canRedo;
    }

    public void undo() throws CannotUndoException {
        if (this._undoRedo != null) {
            try {
                WindowUtil.showWaitCursor();
                this._undoRedo.undo();
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    public void redo() throws CannotRedoException {
        if (this._undoRedo != null) {
            try {
                WindowUtil.showWaitCursor();
                this._undoRedo.redo();
            }
            finally {
                WindowUtil.hideWaitCursor();
            }
        }
    }

    public void addChangeListener(ChangeListener l) {
        this._undoChangeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this._undoChangeSupport.removeChangeListener(l);
    }

    public String getUndoPresentationName() {
        return "Undo";
    }

    public String getRedoPresentationName() {
        return "Redo";
    }

    private class GraphCloseListener
    implements PropertyChangeListener {
        private GraphCloseListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue().equals(GraphViewElementUndoRedo.this._graphID)) {
                if ("graphClosing".equals(evt.getPropertyName())) {
                    GraphViewElementUndoRedo.this._undoRedo.removeChangeListener(GraphViewElementUndoRedo.this._undoRedoListener);
                } else if ("graphClosed".equals(evt.getPropertyName())) {
                    GraphLifeCycleManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
                    GraphViewElementUndoRedo.this._undoRedoListener = null;
                    GraphViewElementUndoRedo.this._undoRedo = null;
                    GraphViewElementUndoRedo.this._graphID = null;
                }
            }
        }
    }

    private class GraphUndoRedoListener
    implements ChangeListener {
        private GraphUndoRedoListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            GraphViewElementUndoRedo.this._undoChangeSupport.fireChange();
        }
    }
}

