/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.ui.graph.impl.OverviewFactory;
import com.paterva.maltego.util.ui.slide.SlideWindowContainer;
import com.paterva.maltego.util.ui.slide.SlideWindowManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.openide.util.ImageUtilities;
import y.view.Graph2DView;
import y.view.NavigationComponent;
import y.view.Overview;

public class GraphFullScreenDecorator {
    private static final String PREF_NAVIGATION_VISIBLE = "fullscreenNavigationVisible";
    private static final String PREF_OVERVIEW_VISIBLE = "fullscreenOverviewVisible";

    public static void addFullScreenDecorations(GraphID graphID, Graph2DView view) {
        view.setScrollBarPolicy(21, 31);
        JLayeredPane layeredPane = new JLayeredPane();
        GraphFullScreenDecorator.addSlideWindows(layeredPane);
        layeredPane.add((Component)GraphFullScreenDecorator.createOverlayPanel(graphID, view), (Object)0);
        JPanel glassPane = view.getGlassPane();
        glassPane.setLayout(new BorderLayout());
        glassPane.add(layeredPane);
    }

    private static JPanel createOverlayPanel(GraphID graphID, Graph2DView view) {
        GraphOverlayPanel graphOverlayPanel = new GraphOverlayPanel(view);
        graphOverlayPanel.setLayout(new GridBagLayout());
        graphOverlayPanel.setOpaque(false);
        JPanel toolsPanel = new JPanel(new GridBagLayout());
        toolsPanel.setOpaque(false);
        toolsPanel.setBackground(null);
        Overview overview = OverviewFactory.create(graphID, view);
        overview.setPreferredSize(new Dimension(150, 150));
        overview.setMinimumSize(new Dimension(150, 150));
        int scrollStepSize = 15;
        int scrollTimerDelay = 5;
        NavigationComponent navigationComponent = GraphFullScreenDecorator.createNavigationComponent(view, scrollStepSize, scrollTimerDelay);
        JPanel innerToolbar = GraphFullScreenDecorator.createInnerToolbar(overview, navigationComponent);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 22;
        toolsPanel.add((Component)innerToolbar, gbc);
        gbc.gridy = 1;
        gbc.insets = new Insets(16, 0, 0, 0);
        overview.setBorder((Border)new LineBorder(UIManager.getLookAndFeelDefaults().getColor("Separator.foreground"), 2));
        toolsPanel.add((Component)overview, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        gbc.insets = new Insets(11, 11, 0, 0);
        navigationComponent.setPreferredSize(new Dimension((int)navigationComponent.getPreferredSize().getWidth(), 300));
        graphOverlayPanel.add((Component)navigationComponent, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.anchor = 24;
        gbc.insets = new Insets(16, 0, 0, 16);
        graphOverlayPanel.add((Component)toolsPanel, gbc);
        return graphOverlayPanel;
    }

    public static void removeFullScreenDecorations(Graph2DView view) {
        GraphFullScreenDecorator.closeSlideWindows();
        view.getGlassPane().removeAll();
        view.setScrollBarPolicy(20, 30);
    }

    private static NavigationComponent createNavigationComponent(Graph2DView view, double scrollStepSize, int scrollTimerDelay) {
        NavigationComponent navigation = new NavigationComponent(view){

            protected Icon createZoomIcon(boolean bln) {
                if (bln) {
                    return ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenZoomIn.png", (boolean)true);
                }
                return ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenZoomOut.png", (boolean)true);
            }

            protected Icon createFitContentIcon() {
                return ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenToggleFit.png", (boolean)true);
            }

            protected Icon createScrollIcon(byte b) {
                ImageIcon icon = null;
                switch (b) {
                    case 2: {
                        icon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenScrollDown.png", (boolean)true);
                        break;
                    }
                    case 1: {
                        icon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenScrollUp.png", (boolean)true);
                        break;
                    }
                    case 8: {
                        icon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenScrollLeft.png", (boolean)true);
                        break;
                    }
                    case 4: {
                        icon = ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenScrollRight.png", (boolean)true);
                        break;
                    }
                }
                return icon;
            }
        };
        navigation.setScrollStepSize(scrollStepSize);
        navigation.putClientProperty((Object)"NavigationComponent.ScrollTimerDelay", (Object)scrollTimerDelay);
        navigation.putClientProperty((Object)"NavigationComponent.ScrollTimerInitialDelay", (Object)scrollTimerDelay);
        navigation.putClientProperty((Object)"NavigationComponent.AnimateFitContent", (Object)Boolean.TRUE);
        navigation.setBackground(new Color(255, 255, 255, 0));
        double zoom = view.getZoom();
        navigation.setMinZoomLevel(zoom);
        navigation.setMaxZoomLevel(zoom);
        navigation.setMinZoomLevel(0.01);
        navigation.setMaxZoomLevel(5.0);
        return navigation;
    }

    private static JPanel createInnerToolbar(Overview overview, NavigationComponent navigationComponent) {
        GridBagConstraints gbc = new GridBagConstraints();
        Insets margin = new Insets(2, 2, 2, 2);
        JPanel headPanel = new JPanel(new GridBagLayout());
        headPanel.setOpaque(false);
        JToggleButton navigateButton = new JToggleButton(new ToggleComponentVisibilityAction((Component)navigationComponent, PREF_NAVIGATION_VISIBLE));
        navigateButton.setMargin(margin);
        navigateButton.setToolTipText("Toggle Navigation Controls");
        navigateButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenNavigation.png", (boolean)true));
        navigateButton.setSelected(true);
        navigateButton.setOpaque(false);
        navigateButton.setSelected(SlideWindowManager.getVisiblePreference((String)PREF_NAVIGATION_VISIBLE));
        gbc.weightx = 0.0;
        gbc.anchor = 22;
        gbc.insets = new Insets(0, 1, 0, 1);
        headPanel.add((Component)navigateButton, gbc);
        JToggleButton overviewButton = new JToggleButton(new ToggleComponentVisibilityAction((Component)overview, PREF_OVERVIEW_VISIBLE));
        overviewButton.setMargin(margin);
        overviewButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/ui/graph/impl/FullScreenOverview.png", (boolean)true));
        overviewButton.setToolTipText("Toggle Overview");
        overviewButton.setSelected(true);
        overviewButton.setOpaque(false);
        overviewButton.setSelected(SlideWindowManager.getVisiblePreference((String)PREF_OVERVIEW_VISIBLE));
        headPanel.add((Component)overviewButton, gbc);
        String isFinishedSetup = "isFinishedSetup";
        JToggleButton slideWindowsButton = new JToggleButton(new ToggleSlideWindowVisibilityAction()){
            private PreferenceChangeListener _prefsListener;

            @Override
            public void addNotify() {
                super.addNotify();
                this._prefsListener = new PreferenceChangeListener(){

                    @Override
                    public void preferenceChange(final PreferenceChangeEvent evt) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (evt.getKey().startsWith("fullscreenSlideWindowsVisible") && !SlideWindowManager.getVisiblePreference((String)"fullscreenSlideWindowsVisible") && Boolean.TRUE.equals(this.getClientProperty("isFinishedSetup"))) {
                                    this.setSelected(false);
                                }
                            }
                        });
                    }
                };
                Preferences prefs = SlideWindowManager.getPreferences();
                prefs.addPreferenceChangeListener(this._prefsListener);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                if (this._prefsListener != null) {
                    Preferences prefs = SlideWindowManager.getPreferences();
                    prefs.removePreferenceChangeListener(this._prefsListener);
                }
            }
        };
        slideWindowsButton.setMargin(margin);
        slideWindowsButton.setIcon(ImageUtilities.loadImageIcon((String)"com/paterva/maltego/detailview/DetailView.png", (boolean)true));
        slideWindowsButton.setToolTipText("Toggle Detail View");
        slideWindowsButton.setSelected(true);
        slideWindowsButton.setOpaque(false);
        slideWindowsButton.setSelected(SlideWindowManager.getVisiblePreference((String)"fullscreenSlideWindowsVisible"));
        headPanel.add((Component)slideWindowsButton, gbc);
        slideWindowsButton.putClientProperty("isFinishedSetup", Boolean.TRUE);
        return headPanel;
    }

    private static void addSlideWindows(JLayeredPane layeredPane) {
        SlideWindowManager.getDefault().addAll((Container)layeredPane);
    }

    private static void closeSlideWindows() {
        SlideWindowManager.getDefault().closeAll();
    }

    private static class GraphOverlayPanel
    extends JPanel {
        private final Graph2DView _view;

        public GraphOverlayPanel(Graph2DView view) {
            this._view = view;
        }

        @Override
        public void doLayout() {
            this.setBounds(0, 0, this._view.getWidth(), this._view.getHeight());
            super.doLayout();
        }
    }

    static class ToggleSlideWindowVisibilityAction
    extends AbstractAction {
        public ToggleSlideWindowVisibilityAction() {
            this.update(SlideWindowManager.getVisiblePreference((String)"fullscreenSlideWindowsVisible"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean visible = !SlideWindowManager.getVisiblePreference((String)"fullscreenSlideWindowsVisible");
            SlideWindowManager.setVisiblePreference((String)"fullscreenSlideWindowsVisible", (boolean)visible);
            this.update(visible);
        }

        private void update(boolean visible) {
            List all = SlideWindowManager.getDefault().getAll();
            for (SlideWindowContainer container : all) {
                container.setVisible(visible);
            }
        }
    }

    static class ToggleComponentVisibilityAction
    extends AbstractAction {
        private final Component _component;
        private final String _preference;

        public ToggleComponentVisibilityAction(Component component, String preference) {
            this._component = component;
            this._preference = preference;
            this._component.setVisible(SlideWindowManager.getVisiblePreference((String)this._preference));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean visible = !this._component.isVisible();
            this._component.setVisible(visible);
            SlideWindowManager.setVisiblePreference((String)this._preference, (boolean)visible);
        }
    }
}

