/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.graph.PageRankProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeListener;
import org.openide.util.ChangeSupport;
import y.base.DataProvider;
import y.base.Graph;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.base.Node;
import y.base.NodeCursor;
import y.base.NodeMap;

public class DefaultPageRankProvider
extends PageRankProvider {
    private static final String PAGE_RANK_PROVIDER_KEY = "maltego.PageRank";
    private static final double DAMPENING = 0.85;
    private Map<Graph, ChangeSupport> _changeSupport = new WeakHashMap<Graph, ChangeSupport>();
    private Set<Graph> _updatingGraphs = new HashSet<Graph>();
    private Set<Graph> _modifiedGraphs = new HashSet<Graph>();

    public double get(Node node) {
        Graph graph = node.getGraph();
        NodeMap pageRankMap = this.getPageRankMap(graph);
        this.lazyUpdate(graph, pageRankMap);
        return pageRankMap.getDouble((Object)node);
    }

    protected synchronized NodeMap getPageRankMap(Graph graph) {
        NodeMap pageRanks = (NodeMap)graph.getDataProvider((Object)PAGE_RANK_PROVIDER_KEY);
        if (pageRanks == null) {
            pageRanks = graph.createNodeMap();
            graph.addDataProvider((Object)PAGE_RANK_PROVIDER_KEY, (DataProvider)pageRanks);
            this.initPageRanks(graph, pageRanks);
            this.updatePageRanks(graph, pageRanks);
            graph.addGraphListener((GraphListener)new EdgeGraphListener(graph));
        }
        return pageRanks;
    }

    private void initPageRanks(Graph graph, NodeMap pageRanks) {
        NodeCursor nodes = graph.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            pageRanks.setDouble((Object)node, 1.0 / (double)graph.N());
            nodes.next();
        }
    }

    private void lazyUpdate(Graph graph, NodeMap pageRankMap) {
        if (this._modifiedGraphs.contains(graph)) {
            this.updatePageRanks(graph, pageRankMap);
            this._modifiedGraphs.remove(graph);
        }
    }

    protected void updatePageRanks(Graph graph) {
        this.updatePageRanks(graph, this.getPageRankMap(graph));
    }

    protected void updatePageRanks(Graph graph, NodeMap pageRanks) {
        this.updatePageRanks(graph, pageRanks, 50);
    }

    protected void updatePageRanks(Graph graph, NodeMap pageRanks, int maxIterations) {
        if (this._updatingGraphs.contains(graph)) {
            return;
        }
        this._updatingGraphs.add(graph);
        double aux = 0.15000000000000002;
        boolean change = true;
        while (maxIterations-- > 0 && change) {
            change = false;
            NodeMap tempPageRanks = this.clonePageRanks(graph, pageRanks);
            NodeCursor nodes = graph.nodes();
            while (nodes.ok()) {
                Node node = nodes.node();
                NodeCursor predecessors = node.predecessors();
                double rank = 0.0;
                while (predecessors.ok()) {
                    Node predecessor = predecessors.node();
                    int numLink = predecessor.outDegree();
                    rank += pageRanks.getDouble((Object)predecessor) / (double)numLink;
                    predecessors.next();
                }
                rank = aux + 0.85 * rank;
                tempPageRanks.setDouble((Object)node, rank);
                if (Math.abs(rank - pageRanks.getDouble((Object)node)) > 0.001) {
                    change = true;
                }
                nodes.next();
            }
            this.copyPageRanks(graph, tempPageRanks, pageRanks);
            graph.disposeNodeMap(tempPageRanks);
        }
        this._modifiedGraphs.remove(graph);
        this._updatingGraphs.remove(graph);
    }

    private NodeMap clonePageRanks(Graph graph, NodeMap pageRanks) {
        NodeMap cloned = graph.createNodeMap();
        this.copyPageRanks(graph, pageRanks, cloned);
        return cloned;
    }

    private void copyPageRanks(Graph graph, NodeMap src, NodeMap dest) {
        NodeCursor nodes = graph.nodes();
        while (nodes.ok()) {
            Node node = nodes.node();
            dest.setDouble((Object)node, src.getDouble((Object)node));
            nodes.next();
        }
    }

    public void addChangeListener(Graph graph, ChangeListener listener) {
        this.getChangeSupport(graph).addChangeListener(listener);
    }

    public void removeChangeListener(Graph graph, ChangeListener listener) {
        this.getChangeSupport(graph).removeChangeListener(listener);
    }

    private synchronized ChangeSupport getChangeSupport(Graph graph) {
        ChangeSupport support = this._changeSupport.get(graph);
        if (support == null) {
            support = new ChangeSupport((Object)this);
            this._changeSupport.put(graph, support);
        }
        return support;
    }

    private class EdgeGraphListener
    implements GraphListener {
        private Graph _graph;
        private int _block = 0;
        private boolean _changed = false;

        public EdgeGraphListener(Graph graph) {
            this._graph = graph;
        }

        public void onGraphEvent(GraphEvent ge) {
            switch (ge.getType()) {
                case 12: {
                    ++this._block;
                    break;
                }
                case 13: {
                    --this._block;
                    this._block = Math.max(this._block, 0);
                    break;
                }
                case 1: 
                case 5: {
                    this._changed = true;
                }
            }
            if (this._block == 0 && this._changed) {
                DefaultPageRankProvider.this._modifiedGraphs.add(this._graph);
                this._changed = false;
                DefaultPageRankProvider.this.getChangeSupport(this._graph).fireChange();
            }
        }
    }
}

