/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.data.GraphDataObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DefaultGraphEditorRegistry
extends GraphEditorRegistry
implements PropertyChangeListener {
    private TopComponent _previousTopMost = null;
    private TopComponent _topMost;
    private TopComponent.Registry _registry;

    public DefaultGraphEditorRegistry() {
        this(TopComponent.getRegistry());
    }

    public DefaultGraphEditorRegistry(TopComponent.Registry r) {
        this._registry = r;
        this._registry.addPropertyChangeListener((PropertyChangeListener)this);
        TopComponent active = DefaultGraphEditorRegistry.asGraphEditor(this._registry.getActivated());
        if (active != null) {
            this._topMost = active;
        } else {
            for (TopComponent tc : this._registry.getOpened()) {
                if (!DefaultGraphEditorRegistry.isGraphEditor(tc)) continue;
                this._topMost = tc;
                break;
            }
        }
    }

    @Override
    public TopComponent getPreviousTopmost() {
        return this._previousTopMost;
    }

    @Override
    public TopComponent getTopmost() {
        return this._topMost;
    }

    private void setTopmost(TopComponent tc) {
        if (this._topMost != tc) {
            this._previousTopMost = this._topMost;
            this._topMost = tc;
            this.firePropertyChanged("topmost", this._previousTopMost, this._topMost);
        }
    }

    @Override
    public TopComponent getActive() {
        TopComponent active = this._registry.getActivated();
        if (DefaultGraphEditorRegistry.isGraphEditor(active)) {
            return active;
        }
        return null;
    }

    @Override
    public Set<TopComponent> getOpen() {
        HashSet<TopComponent> open = new HashSet<TopComponent>();
        for (TopComponent tc : this._registry.getOpened()) {
            if (!DefaultGraphEditorRegistry.isGraphEditor(tc)) continue;
            open.add(tc);
        }
        return open;
    }

    private static boolean isGraphEditor(TopComponent tc) {
        return tc != null && tc.getLookup().lookup(GraphDataObject.class) != null;
    }

    private static TopComponent asGraphEditor(TopComponent tc) {
        if (DefaultGraphEditorRegistry.isGraphEditor(tc)) {
            return tc;
        }
        return null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String type = evt.getPropertyName();
        if ("activated".equals(type)) {
            TopComponent newActive = (TopComponent)evt.getNewValue();
            TopComponent oldActive = (TopComponent)evt.getOldValue();
            if (DefaultGraphEditorRegistry.isGraphEditor(newActive)) {
                this.setTopmost(newActive);
                this.firePropertyChanged("activated", DefaultGraphEditorRegistry.asGraphEditor(oldActive), newActive);
            } else if (DefaultGraphEditorRegistry.isGraphEditor(oldActive)) {
                if (WindowManager.getDefault().isEditorTopComponent(newActive)) {
                    this.setTopmost(null);
                }
                this.firePropertyChanged("activated", oldActive, null);
            }
        } else if (!"opened".equals(type)) {
            if ("tcOpened".equals(type)) {
                TopComponent tc = (TopComponent)evt.getNewValue();
                if (tc != null) {
                    tc.putClientProperty((Object)"netbeans.winsys.tc.draganddrop_copy_disabled", (Object)Boolean.TRUE);
                }
                if (DefaultGraphEditorRegistry.isGraphEditor(tc)) {
                    this.firePropertyChanged("opened", null, this.getOpen());
                }
            } else if ("tcClosed".equals(type)) {
                TopComponent tc = (TopComponent)evt.getNewValue();
                if (DefaultGraphEditorRegistry.isGraphEditor(tc)) {
                    this.firePropertyChanged("ge_closed", null, tc);
                }
                if (tc == this._topMost) {
                    this.setTopmost(null);
                }
            }
        }
    }
}

