/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.impl;

import com.paterva.maltego.licensing.A;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.ui.BrowseToUrl;
import com.paterva.maltego.licensing.ui.product.ProductSelectionAction;
import com.paterva.maltego.util.EntityLimitNotifier;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class DefaultEntityLimitNotifier
implements EntityLimitNotifier {
    AtomicBoolean showDialog = new AtomicBoolean(false);

    public void notifyLimitExceeded() {
        if (this.showDialog.get()) {
            return;
        }
        Runnable asyncDialog = () -> this.asyncDialog();
        SwingUtilities.invokeLater(asyncDialog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void asyncDialog() {
        String msg = "The current operation will cause the graph to exceed " + A.C() + " entities, which is the maximum number of entities allowed in a graph in this version of Maltego.\n\nPlease consider upgrading to Maltego XL to unlock all features.";
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
        nd.setMessageType(1);
        nd.setTitle("Graph Size Limit Reached");
        String upgradeOption = "Upgrade";
        String cancelOption = "Cancel";
        Object[] options = new String[]{upgradeOption, cancelOption};
        nd.setOptions(options);
        try {
            this.showDialog.set(true);
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (upgradeOption.equals(result)) {
                LicenseManager licMan = LicenseManager.A();
                com.paterva.maltego.licensing.mode.A licenseMode = licMan.A(false);
                String licenseKey = licMan.C();
                if (licenseMode.N()) {
                    BrowseToUrl.buyXL((String)licenseKey);
                } else {
                    BrowseToUrl.upgradeToXL((String)licenseKey);
                }
                ProductSelectionAction.perform();
            }
        }
        finally {
            this.showDialog.set(false);
        }
    }
}

