/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.imex.MaltegoEntityIO;
import com.paterva.maltego.ui.graph.imex.StaxHelper;
import com.paterva.maltego.util.BulkStatusDisplayer;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.XMLEscapeUtils;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openide.util.Exceptions;

public class StaxEntityReader {
    private static final Logger LOG = Logger.getLogger(StaxEntityReader.class.getName());
    private final XMLStreamReader _reader;
    private final EntityFactory _factory;
    private final BulkStatusDisplayer _statusDisplayer = new BulkStatusDisplayer("Loading entities (%d)");

    public StaxEntityReader(XMLStreamReader reader, EntityFactory factory) {
        this._reader = reader;
        this._factory = factory;
    }

    public MaltegoEntity readEntity() throws IOException, XMLStreamException {
        this._statusDisplayer.increment();
        String type = StaxHelper.getRequiredAttribute(this._reader, "type");
        String id = StaxHelper.getOptionalAttribute(this._reader, "id", null);
        try {
            EntityID guid = id != null ? EntityID.parse((String)id) : null;
            MaltegoEntity entity = guid != null ? this._factory.createInstance(type, false, guid, false) : (MaltegoEntity)this._factory.createInstance(type, false, false);
            Map<Integer, Attachment> attIndexes = null;
            Properties properties = null;
            Properties properties2 = null;
            do {
                String elementName;
                int event;
                if ((event = this._reader.next()) != 1) continue;
                switch (elementName = this._reader.getLocalName()) {
                    case "MaltegoEntityList": {
                        attIndexes = this.attachEntities(entity);
                        break;
                    }
                    case "Properties": {
                        properties = this.readProperties("Properties");
                        break;
                    }
                    case "Properties2": {
                        properties2 = this.readProperties("Properties2");
                        break;
                    }
                    case "DisplayInformation": {
                        this.attachDisplayInformation(entity);
                        break;
                    }
                    case "Weight": {
                        this.attachWeight(entity);
                        break;
                    }
                    case "Notes": {
                        this.attachNotes(entity);
                        break;
                    }
                    case "Bookmarks": {
                        this.attachBookmarks(entity);
                        break;
                    }
                    default: {
                        LOG.log(Level.WARNING, "Unknown element in MaltegoEntity XML: {0}", elementName);
                    }
                }
            } while (!StaxHelper.isEndElement(this._reader, "MaltegoEntity"));
            if (properties2 != null) {
                this.attachProperties(entity, properties2, null);
            }
            if (properties != null) {
                this.attachProperties(entity, properties, attIndexes);
            }
            return entity;
        }
        catch (TypeInstantiationException ex) {
            throw new IOException("Could not instantiate entity of type " + type, ex);
        }
    }

    public Point2D.Double readEntityRenderer() throws XMLStreamException, IOException {
        Point2D.Double center = null;
        do {
            this._reader.next();
            if (center != null || !StaxHelper.isStartElement(this._reader, "Position")) continue;
            center = this.readCenter();
        } while (!StaxHelper.isEndElement(this._reader, "EntityRenderer"));
        return center != null ? center : new Point2D.Double();
    }

    private Point2D.Double readCenter() throws IOException {
        Point2D.Double center = null;
        try {
            double x = Double.parseDouble(StaxHelper.getRequiredAttribute(this._reader, "x"));
            double y = Double.parseDouble(StaxHelper.getRequiredAttribute(this._reader, "y"));
            center = new Point2D.Double(x, y);
        }
        catch (NumberFormatException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        return center;
    }

    private Map<Integer, Attachment> attachEntities(MaltegoEntity entity) throws IOException, XMLStreamException {
        HashMap<Integer, Attachment> indexes = new HashMap<Integer, Attachment>();
        Attachments atts = new Attachments();
        int attNum = 0;
        do {
            this._reader.next();
            if (!StaxHelper.isStartElement(this._reader, "MaltegoEntity")) continue;
            MaltegoEntity attEntity = this.readEntity();
            Attachment att = MaltegoEntityIO.attachmentFromEntity(attEntity);
            if (att != null) {
                atts.add((Object)att);
                indexes.put(attNum, att);
            }
            ++attNum;
        } while (!StaxHelper.isEndElement(this._reader, "MaltegoEntityList"));
        PropertyDescriptor attsPd = new PropertyDescriptor(Attachments.class, "attachments_internal", "Attachments");
        entity.setValue(attsPd, (Object)atts);
        return indexes;
    }

    private Properties readProperties(String nodeName) throws XMLStreamException, IOException {
        String value = StaxHelper.getOptionalAttribute(this._reader, "value", null);
        String displayValue = StaxHelper.getOptionalAttribute(this._reader, "displayValue", null);
        String image = StaxHelper.getOptionalAttribute(this._reader, "image", null);
        HashMap<PropertyDescriptor, String> props = new HashMap<PropertyDescriptor, String>();
        do {
            this._reader.next();
            if (!StaxHelper.isStartElement(this._reader, "Property")) continue;
            String name = StaxHelper.getRequiredAttribute(this._reader, "name");
            String type = StaxHelper.getRequiredAttribute(this._reader, "type");
            TypeDescriptor td = TypeRegistry.getDefault().getType(type);
            if (td == null) {
                LOG.log(Level.WARNING, "Unknown type in loaded graph: {0}", type);
                continue;
            }
            String displayName = StaxHelper.getOptionalAttribute(this._reader, "displayName", null);
            boolean hidden = StaxHelper.getBooleanAttribute(this._reader, "hidden", false);
            boolean nullable = StaxHelper.getBooleanAttribute(this._reader, "nullable", true);
            boolean readonly = StaxHelper.getBooleanAttribute(this._reader, "readonly", false);
            PropertyDescriptor pd = new PropertyDescriptor(td.getType(), name, displayName);
            pd.setHidden(hidden);
            pd.setNullable(nullable);
            pd.setReadonly(readonly);
            StaxHelper.skipToElement(this._reader, "Value");
            String propValue = XMLEscapeUtils.unescapeUnicode((String)this._reader.getElementText());
            props.put(pd, propValue);
        } while (!StaxHelper.isEndElement(this._reader, nodeName));
        return new Properties(value, displayValue, image, props);
    }

    private void attachDisplayInformation(MaltegoEntity entity) throws XMLStreamException {
        do {
            this._reader.next();
            if (!StaxHelper.isStartElement(this._reader, "DisplayElement")) continue;
            String displayElementName = StaxHelper.getOptionalAttribute(this._reader, "name", "");
            String value = StaxHelper.readCData(this._reader, "DisplayElement");
            if (value.isEmpty()) continue;
            DisplayInformationCollection displayInformation = entity.getOrCreateDisplayInformation();
            displayInformation.add(displayElementName, value);
            entity.setDisplayInformation(displayInformation);
        } while (!StaxHelper.isEndElement(this._reader, "DisplayInformation"));
    }

    private void attachWeight(MaltegoEntity entity) throws XMLStreamException {
        try {
            entity.setWeight(Integer.valueOf(this._reader.getElementText()));
        }
        catch (NumberFormatException e) {
            NormalException.logStackTrace((Throwable)e);
        }
    }

    private void attachNotes(MaltegoEntity entity) throws XMLStreamException {
        boolean showAttr = StaxHelper.getBooleanAttribute(this._reader, "show", false);
        entity.setShowNotes(Boolean.valueOf(showAttr));
        String notes = StaxHelper.readCData(this._reader, "Notes");
        if (!notes.isEmpty()) {
            entity.setNotes(notes);
        }
    }

    private void attachBookmarks(MaltegoEntity entity) throws XMLStreamException {
        try {
            entity.setBookmark(Integer.valueOf(this._reader.getElementText()));
        }
        catch (NumberFormatException e) {
            NormalException.logStackTrace((Throwable)e);
        }
    }

    private void attachProperties(MaltegoEntity entity, Properties properties, Map<Integer, Attachment> attIndexes) {
        Map<PropertyDescriptor, String> props = properties.getProps();
        if (props != null) {
            for (Map.Entry<PropertyDescriptor, String> entrySet : props.entrySet()) {
                PropertyDescriptor pd = entrySet.getKey();
                String valueString = entrySet.getValue();
                String name = pd.getName();
                PropertyDescriptorCollection typeProperties = entity.getProperties();
                if (!typeProperties.contains(name)) {
                    typeProperties.add(pd);
                } else {
                    pd = typeProperties.get(name);
                }
                if (MaltegoEntityIO.isDependentSet(pd, entity)) continue;
                try {
                    Object value = Converter.convertFrom((String)valueString, (Class)pd.getType());
                    entity.setValue(pd, value);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
                    if (type == null) continue;
                    entity.setValue(pd, type.getDefaultValue());
                }
            }
        }
        String value = properties.getValue();
        String displayValue = properties.getDisplayValue();
        String image = properties.getImage();
        MaltegoEntityIO.setSpecialProperties(entity, value, displayValue, image, attIndexes);
    }

    private static class Properties {
        private final String _value;
        private final String _displayValue;
        private final String _image;
        private final Map<PropertyDescriptor, String> _props;

        public Properties(String value, String displayValue, String image, Map<PropertyDescriptor, String> props) {
            this._value = value;
            this._displayValue = displayValue;
            this._image = image;
            this._props = props;
        }

        public String getValue() {
            return this._value;
        }

        public String getDisplayValue() {
            return this._displayValue;
        }

        public String getImage() {
            return this._image;
        }

        public Map<PropertyDescriptor, String> getProps() {
            return this._props;
        }
    }
}

