/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.DisplayInformation;
import com.paterva.maltego.core.DisplayInformationCollection;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GenericEntity;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityFactory;
import com.paterva.maltego.typing.Converter;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.TypeInstantiationException;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.typing.types.InternalFile;
import com.paterva.maltego.typing.types.TimeSpan;
import com.paterva.maltego.ui.graph.imex.IOHelper;
import com.paterva.maltego.util.FastURL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.output.XmlWriter;

public class MaltegoEntityIO {
    public MaltegoEntity read(Node node, EntityFactory factory) throws GraphMLParseException {
        String type = IOHelper.getRequiredAttribute(node, "type");
        String id = IOHelper.getOptionalAttribute(node, "id", null);
        try {
            Element bookmarks;
            Element weight;
            Element displayInfo;
            Element properties;
            Element properties2;
            Element attachmentProperties;
            EntityID guid = id != null ? EntityID.parse((String)id) : null;
            MaltegoEntity entity = guid != null ? factory.createInstance(type, false, guid, false) : (MaltegoEntity)factory.createInstance(type, false, false);
            Map<Integer, Attachment> attIndexes = null;
            Element entities = IOHelper.findElement(node, "MaltegoEntityList");
            if (entities != null) {
                attIndexes = this.attachEntities(entity, entities, factory);
            }
            if ((attachmentProperties = IOHelper.findElement(node, "AttachmentProperties")) != null) {
                this.attachProperties(entity, attachmentProperties, null);
            }
            if ((properties2 = IOHelper.findElement(node, "Properties2")) != null) {
                this.attachProperties(entity, properties2, null);
            }
            if ((properties = IOHelper.findElement(node, "Properties")) != null) {
                this.attachProperties(entity, properties, attIndexes);
            }
            if ((displayInfo = IOHelper.findElement(node, "DisplayInformation")) != null) {
                this.attachDisplayInformation(entity, displayInfo);
            }
            if ((weight = IOHelper.findElement(node, "Weight")) != null) {
                this.attachWeight(entity, weight);
            } else {
                entity.setWeight(Integer.valueOf(0));
            }
            Element notes = IOHelper.findElement(node, "Notes");
            if (notes != null) {
                this.attachNotes(entity, notes);
            }
            if ((bookmarks = IOHelper.findElement(node, "Bookmarks")) != null) {
                this.attachBookmarks(entity, bookmarks);
            }
            MaltegoEntity maltegoEntity = entity;
            return maltegoEntity;
        }
        catch (TypeInstantiationException ex) {
            throw new GraphMLParseException("Could not instantiate entity of type " + type, (Throwable)ex);
        }
        finally {
            node.setTextContent(null);
        }
    }

    private Map<Integer, Attachment> attachEntities(MaltegoEntity entity, Element entities, EntityFactory factory) throws GraphMLParseException {
        HashMap<Integer, Attachment> indexes = new HashMap<Integer, Attachment>();
        Attachments atts = new Attachments();
        NodeList children = entities.getChildNodes();
        int attNum = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"MaltegoEntity".equals(child.getLocalName())) continue;
            MaltegoEntity attEntity = this.read(child, factory);
            Attachment att = MaltegoEntityIO.attachmentFromEntity(attEntity);
            if (att != null) {
                atts.add((Object)att);
                indexes.put(attNum, att);
            }
            ++attNum;
        }
        PropertyDescriptor attsPd = new PropertyDescriptor(Attachments.class, "attachments_internal", "Attachments");
        entity.setValue(attsPd, (Object)atts);
        return indexes;
    }

    static Attachment attachmentFromEntity(MaltegoEntity attEntity) {
        Attachment att = null;
        PropertyDescriptorCollection pds = attEntity.getProperties();
        PropertyDescriptor sourcePd = pds.get("source");
        FastURL source = (FastURL)attEntity.getValue(sourcePd);
        PropertyDescriptor filePd = pds.get("file");
        InternalFile file = (InternalFile)attEntity.getValue(filePd);
        if (file != null) {
            att = new Attachment(file.fileStoreIndex, source);
        }
        return att;
    }

    private void attachWeight(MaltegoEntity entity, Element weight) {
        try {
            entity.setWeight(Integer.valueOf(weight.getTextContent()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void attachDisplayInformation(MaltegoEntity entity, Element displayInfo) {
        NodeList children = displayInfo.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            String value;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"DisplayElement".equals(child.getLocalName()) || (value = IOHelper.findCData(child)) == null) continue;
            DisplayInformationCollection displayInformation = entity.getOrCreateDisplayInformation();
            displayInformation.add(IOHelper.getOptionalAttribute(child, "name", ""), value);
            entity.setDisplayInformation(displayInformation);
        }
    }

    private void attachProperties(MaltegoEntity entity, Node properties, Map<Integer, Attachment> attIndexes) throws GraphMLParseException {
        NodeList children = properties.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"Property".equals(child.getLocalName())) continue;
            String name = IOHelper.getRequiredAttribute(child, "name");
            if (!entity.getProperties().contains(name)) {
                this.attachProperty(entity, child);
            }
            String valueString = IOHelper.getValue(child);
            PropertyDescriptor pd = entity.getProperties().get(name);
            if (MaltegoEntityIO.isDependentSet(pd, entity)) continue;
            try {
                Object value = Converter.convertFrom((String)valueString, (Class)pd.getType());
                entity.setValue(pd, value);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
                if (type == null) continue;
                entity.setValue(pd, type.getDefaultValue());
            }
        }
        String value = IOHelper.getStringAttribute(properties, "value");
        String displayValue = IOHelper.getStringAttribute(properties, "displayValue");
        String image = IOHelper.getStringAttribute(properties, "image");
        MaltegoEntityIO.setSpecialProperties(entity, value, displayValue, image, attIndexes);
    }

    static void setSpecialProperties(MaltegoEntity entity, String value, String displayValue, String image, Map<Integer, Attachment> attIndexes) {
        if (value != null) {
            PropertyDescriptor pd = entity.getProperties().get(value);
            entity.setValueProperty(pd);
        }
        entity.setDisplayValueExpression(displayValue);
        if (image != null) {
            String imgEntityText = "MaltegoEntityList#";
            if (image.startsWith(imgEntityText)) {
                if (attIndexes != null) {
                    try {
                        Integer imgEntity = Integer.parseInt(image.substring(imgEntityText.length()));
                        Attachment att = attIndexes.get(imgEntity);
                        MaltegoEntityIO.setAsEntityImage(att, entity);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                entity.setImageExpression(imgEntityText);
            }
        }
    }

    private static void setAsEntityImage(Attachment att, MaltegoEntity entity) {
        if (att != null) {
            PropertyDescriptorCollection pds = entity.getProperties();
            for (PropertyDescriptor pd : pds) {
                Attachments atts;
                if (!Attachments.class.equals((Object)pd.getType()) || !(atts = (Attachments)entity.getValue(pd)).contains((Object)att)) continue;
                atts.setPrimaryImage(att);
                entity.setImageExpression(pd.getName());
                break;
            }
        }
    }

    static boolean isDependentSet(PropertyDescriptor pd, MaltegoEntity entity) {
        if (pd instanceof DisplayDescriptor) {
            DisplayDescriptor dd = (DisplayDescriptor)pd;
            List linkedProperties = dd.getLinkedProperties();
            for (PropertyDescriptor propertyDescriptor : linkedProperties) {
                propertyDescriptor = entity.getProperties().get(propertyDescriptor.getName());
                Object value = entity.getValue(propertyDescriptor);
                if (value == null || value.equals(TypeRegistry.getDefault().getType(propertyDescriptor.getType()).getDefaultValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void attachProperty(MaltegoEntity entity, Node property) throws GraphMLParseException {
        String name = IOHelper.getRequiredAttribute(property, "name");
        String type = IOHelper.getRequiredAttribute(property, "type");
        TypeDescriptor td = TypeRegistry.getDefault().getType(type);
        if (td != null) {
            String displayName = IOHelper.getStringAttribute(property, "displayName");
            PropertyDescriptor pd = new PropertyDescriptor(td.getType(), name, displayName);
            pd.setHidden(IOHelper.getBooleanAttribute(property, "hidden", false));
            pd.setNullable(IOHelper.getBooleanAttribute(property, "nullable", true));
            pd.setReadonly(IOHelper.getBooleanAttribute(property, "readonly", false));
            entity.getProperties().add(pd);
        } else {
            System.out.println("Unknown type in loaded graph: " + type);
        }
    }

    private void attachNotes(MaltegoEntity entity, Element notesElement) {
        String notes = IOHelper.findCData(notesElement);
        if (notes != null) {
            entity.setNotes(notes);
        }
        String showAttrib = IOHelper.getOptionalAttribute(notesElement, "show", "false");
        entity.setShowNotes(Boolean.valueOf("true".equals(showAttrib)));
    }

    private void attachBookmarks(MaltegoEntity entity, Element bookmarks) {
        try {
            entity.setBookmark(Integer.valueOf(bookmarks.getTextContent()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void write(XmlWriter writer, MaltegoEntity entity) {
        AttachmentEntities attEntities = this.translateAttachments(entity);
        writer.writeStartElement("mtg", "MaltegoEntity", "http://maltego.paterva.com/xml/mtgx");
        writer.writeAttribute("type", entity.getTypeName());
        writer.writeAttribute("id", ((EntityID)entity.getID()).toString());
        this.writeProperties(writer, entity, attEntities.imgIndex);
        this.writeProperties2(writer, entity);
        this.writeDisplayInformation(writer, entity.getDisplayInformation());
        this.writeWeight(writer, entity.getWeight());
        this.writeNotes(writer, entity.getNotes(), entity.isShowNotes());
        this.writeBookmarks(writer, entity.getBookmark());
        this.writeContainedEntities(writer, entity, attEntities.entities);
        writer.writeEndElement();
    }

    private void writeWeight(XmlWriter writer, int weight) {
        if (weight != 0) {
            writer.writeStartElement("mtg", "Weight", "http://maltego.paterva.com/xml/mtgx");
            writer.writeText(String.valueOf(weight));
            writer.writeEndElement();
        }
    }

    private void writeDisplayInformation(XmlWriter writer, DisplayInformationCollection display) {
        if (display != null && !display.isEmpty()) {
            writer.writeStartElement("mtg", "DisplayInformation", "http://maltego.paterva.com/xml/mtgx");
            for (DisplayInformation di : display) {
                writer.writeStartElement("mtg", "DisplayElement", "http://maltego.paterva.com/xml/mtgx");
                writer.writeAttribute("name", di.getName());
                writer.writeCData(di.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeProperties(XmlWriter writer, MaltegoEntity entity, Integer imgIndex) {
        writer.writeStartElement("mtg", "Properties", "http://maltego.paterva.com/xml/mtgx");
        this.writePropertyName(writer, "value", entity.getValueProperty());
        entity.getDisplayValueExpression().ifPresent(dispExpr -> writer.writeAttribute("displayValue", dispExpr));
        if (imgIndex == null) {
            entity.getNonBlankImageExpression().ifPresent(imgExpr -> writer.writeAttribute("image", imgExpr));
        } else {
            writer.writeAttribute("image", "MaltegoEntityList#" + imgIndex);
        }
        for (PropertyDescriptor pd : entity.getProperties()) {
            if (this.isProperties2Property(pd) || Attachments.class.equals((Object)pd.getType())) continue;
            IOHelper.writeProperty(writer, (MaltegoPart<? extends Guid>)entity, pd);
        }
        writer.writeEndElement();
    }

    private boolean isProperties2Property(PropertyDescriptor pd) {
        return DateTime.class.equals((Object)pd.getType()) || TimeSpan.class.equals((Object)pd.getType()) || InternalFile.class.equals((Object)pd.getType());
    }

    private void writeProperties2(XmlWriter writer, MaltegoEntity entity) {
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        for (PropertyDescriptor pd : entity.getProperties()) {
            if (!this.isProperties2Property(pd) || Attachments.class.equals((Object)pd.getType())) continue;
            pds.add(pd);
        }
        if (!pds.isEmpty()) {
            writer.writeStartElement("mtg", "Properties2", "http://maltego.paterva.com/xml/mtgx");
            for (PropertyDescriptor pd : pds) {
                IOHelper.writeProperty(writer, (MaltegoPart<? extends Guid>)entity, pd);
            }
            writer.writeEndElement();
        }
    }

    private void writePropertyName(XmlWriter writer, String name, PropertyDescriptor property) {
        if (property != null) {
            writer.writeAttribute(name, property.getName());
        }
    }

    private void writeNotes(XmlWriter writer, String notes, boolean showNotes) {
        if (notes != null && !notes.isEmpty()) {
            writer.writeStartElement("mtg", "Notes", "http://maltego.paterva.com/xml/mtgx");
            if (showNotes) {
                writer.writeAttribute("show", showNotes);
            }
            writer.writeCData(notes);
            writer.writeEndElement();
        }
    }

    private void writeBookmarks(XmlWriter writer, int bookmark) {
        if (bookmark >= 0) {
            writer.writeStartElement("mtg", "Bookmarks", "http://maltego.paterva.com/xml/mtgx");
            writer.writeText(Integer.toString(bookmark));
            writer.writeEndElement();
        }
    }

    private void writeContainedEntities(XmlWriter writer, MaltegoEntity entity, List<MaltegoEntity> entities) {
        if (!entities.isEmpty()) {
            writer.writeStartElement("mtg", "MaltegoEntityList", "http://maltego.paterva.com/xml/mtgx");
            for (MaltegoEntity e : entities) {
                this.write(writer, e);
            }
            writer.writeEndElement();
        }
    }

    private AttachmentEntities translateAttachments(MaltegoEntity entity) {
        PropertyDescriptor imgProperty = entity.getNonBlankImageExpression().map(imgExpr -> entity.getProperties().get(imgExpr)).orElse(null);
        Attachment imgAtt = null;
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        for (PropertyDescriptor attPd : entity.getProperties()) {
            Attachments atts;
            if (!Attachments.class.equals((Object)attPd.getType()) || (atts = (Attachments)entity.getValue(attPd)) == null) continue;
            for (Attachment att : atts) {
                attachments.add(att);
            }
            if (imgProperty == null || !imgProperty.equals(attPd)) continue;
            imgAtt = atts.getPrimaryImage();
        }
        AttachmentEntities attEntities = new AttachmentEntities();
        attEntities.entities = new ArrayList<MaltegoEntity>();
        int entityNum = 0;
        for (Attachment att : attachments) {
            GenericEntity attEntity = new GenericEntity(EntityID.create(), "maltego.File");
            PropertyDescriptor sourcePd = new PropertyDescriptor(FastURL.class, "source", "Source");
            attEntity.setValue(sourcePd, (Object)att.getSource());
            PropertyDescriptor filePd = new PropertyDescriptor(InternalFile.class, "file", "File");
            attEntity.setValue(filePd, (Object)new InternalFile(att.getId()));
            attEntity.setImageExpression(filePd.getName());
            attEntities.entities.add((MaltegoEntity)attEntity);
            if (att.equals((Object)imgAtt)) {
                attEntities.imgIndex = entityNum;
            }
            ++entityNum;
        }
        return attEntities;
    }

    private static class AttachmentEntities {
        public List<MaltegoEntity> entities;
        public Integer imgIndex;

        private AttachmentEntities() {
        }
    }
}

