/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.imex;

import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.util.XMLEscapeUtils;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import y.io.graphml.input.GraphMLParseException;
import y.io.graphml.output.XmlWriter;

class IOHelper {
    IOHelper() {
    }

    public static Element findElement(Node parent, String name) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !name.equals(child.getLocalName())) continue;
            return (Element)child;
        }
        return null;
    }

    public static String getRequiredAttribute(Node node, String name) throws GraphMLParseException {
        String s;
        Node n;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n = attrs.getNamedItem(name)) != null && (s = n.getTextContent()) != null) {
            return s;
        }
        throw new GraphMLParseException("Mandatory attribute does not exist: " + name);
    }

    public static String getOptionalAttribute(Node node, String name, String defaultValue) {
        String s;
        Node n;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n = attrs.getNamedItem(name)) != null && (s = n.getTextContent()) != null) {
            return s;
        }
        return defaultValue;
    }

    public static boolean getBooleanAttribute(Node node, String name, boolean defaultValue) {
        String s;
        Node n;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n = attrs.getNamedItem(name)) != null && (s = n.getTextContent()) != null) {
            return s.toLowerCase().equals("true");
        }
        return defaultValue;
    }

    public static String getStringAttribute(Node node, String name) {
        Node n;
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null && (n = attrs.getNamedItem(name)) != null) {
            return n.getTextContent();
        }
        return null;
    }

    public static String getValue(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"Value".equals(child.getLocalName())) continue;
            return child.getTextContent();
        }
        return null;
    }

    public static String findCData(Node node) {
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 4) continue;
            String str = XMLEscapeUtils.unescapeUnicode((String)child.getNodeValue());
            return str != null ? str : "";
        }
        return null;
    }

    public static void writeProperty(XmlWriter writer, MaltegoPart<? extends Guid> part, PropertyDescriptor pd) {
        writer.writeStartElement("mtg", "Property", "http://maltego.paterva.com/xml/mtgx");
        Object value = part.getValue(pd);
        writer.writeAttribute("name", pd.getName());
        TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
        writer.writeAttribute("type", td.getTypeName());
        writer.writeAttribute("nullable", pd.isNullable());
        writer.writeAttribute("hidden", pd.isHidden());
        writer.writeAttribute("readonly", pd.isReadonly());
        writer.writeAttribute("displayName", pd.getDisplayName());
        writer.writeStartElement("mtg", "Value", "http://maltego.paterva.com/xml/mtgx");
        String text = td.convert(value);
        writer.writeText(text != null ? text : "");
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static void writeProperty(XMLStreamWriter writer, MaltegoPart<? extends Guid> part, PropertyDescriptor pd) throws XMLStreamException {
        writer.writeStartElement("mtg", "Property", "http://maltego.paterva.com/xml/mtgx");
        Object value = part.getValue(pd);
        writer.writeAttribute("displayName", pd.getDisplayName());
        writer.writeAttribute("hidden", Boolean.toString(pd.isHidden()));
        writer.writeAttribute("name", pd.getName());
        writer.writeAttribute("nullable", Boolean.toString(pd.isNullable()));
        writer.writeAttribute("readonly", Boolean.toString(pd.isReadonly()));
        TypeDescriptor td = TypeRegistry.getDefault().getType(pd.getType());
        writer.writeAttribute("type", td.getTypeName());
        writer.writeStartElement("mtg", "Value", "http://maltego.paterva.com/xml/mtgx");
        String text = td.convert(value);
        writer.writeCharacters(text != null ? text : "");
        writer.writeEndElement();
        writer.writeEndElement();
    }
}

