/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.find;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.ViewControlAdapter;
import com.paterva.maltego.ui.graph.find.FindBar;
import com.paterva.maltego.ui.graph.find.SearchProvider;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.paterva.maltego.util.ListMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import org.openide.util.NbPreferences;
import y.base.GraphEvent;
import y.base.GraphListener;
import y.view.Graph2D;
import y.view.Graph2DCanvas;
import y.view.Graph2DView;

public class ShowFindBarAction
extends AbstractAction {
    public static final String PROP_ENTITY_TYPE = "type";
    public static final String PROP_DISPLAY_INFO = "displayInfo";
    public static final String PROP_NOTES = "notes";
    public static final String PROP_ALL_PROPS = "allProperties";
    public static final String PROP_BOOKMARK = "bookmark";
    public static final String PROP_ZOOM_TO_RESULT = "zoomToResult";
    public static final String PROP_FIND_ENTITIES = "findEntities";
    private final ViewControlAdapter _control;
    private FindBar _findBar;
    private final SearchProvider _cb;
    private final GraphEntityTypesListener _typeListener = new GraphEntityTypesListener();

    public ShowFindBarAction(ViewControlAdapter control, SearchProvider cb) {
        this._control = control;
        this._cb = cb;
    }

    public void fireAndInitialise(char c) {
        this.actionPerformed(null);
        this._findBar.setText(String.valueOf(c));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FindBar bar = this.getFindBar();
        this.updateTypes();
        this.loadPreferences();
        this._control.getViewCallback().showSideBar(bar, "south");
        bar.flash();
    }

    private void updateTypes() {
        FindBar bar = this.getFindBar();
        Object selectedOption = bar.getSelectedOption();
        GraphID graphID = this._control.getGraphID();
        EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
        Set<String> typeNames = GraphUtils.getTypeNames(graphID, registry);
        List<MaltegoEntitySpec> sortedSpecs = GraphUtils.getSortedSpecs(registry, typeNames);
        Object[] options = new Object[sortedSpecs.size() + 1];
        options[0] = "All";
        int i = 0;
        for (MaltegoEntitySpec spec : sortedSpecs) {
            options[++i] = spec;
        }
        bar.setOptions(options);
        for (Object option : options) {
            if (!option.equals(selectedOption)) continue;
            bar.setSelectedOption(selectedOption);
            break;
        }
    }

    private synchronized FindBar getFindBar() {
        if (this._findBar == null) {
            this._findBar = new FindBar(new FindAction(), new CloseAction());
            GraphID graphID = this._control.getGraphID();
            Graph2D viewGraph = GraphViewManager.getDefault().getViewGraph(graphID);
            viewGraph.addGraphListener((GraphListener)this._typeListener);
        }
        return this._findBar;
    }

    private void loadPreferences() {
        Preferences prefs = NbPreferences.forModule(FindBar.class);
        this._findBar.setIncludeDisplayInfo(prefs.getBoolean(PROP_DISPLAY_INFO, false));
        this._findBar.setIncludeNotes(prefs.getBoolean(PROP_NOTES, false));
        this._findBar.setIncludeFields(prefs.getBoolean(PROP_ALL_PROPS, false));
        this._findBar.setBookmarkResults(prefs.getBoolean(PROP_BOOKMARK, false));
        this._findBar.setZoomToResult(prefs.getBoolean(PROP_ZOOM_TO_RESULT, true));
        this._findBar.setFindEntities(prefs.getBoolean(PROP_FIND_ENTITIES, true));
    }

    private void savePreferences() {
        Preferences prefs = NbPreferences.forModule(FindBar.class);
        prefs.putBoolean(PROP_DISPLAY_INFO, this._findBar.isIncludeDisplayInfo());
        prefs.putBoolean(PROP_NOTES, this._findBar.isIncludeNotes());
        prefs.putBoolean(PROP_ALL_PROPS, this._findBar.isIncludeFields());
        prefs.putBoolean(PROP_BOOKMARK, this._findBar.isBookmarkResults());
        prefs.putBoolean(PROP_ZOOM_TO_RESULT, this._findBar.isZoomToResult());
        prefs.putBoolean(PROP_FIND_ENTITIES, this._findBar.isFindEntities());
    }

    private class GraphEntityTypesListener
    implements GraphListener {
        private int _block = 0;
        private boolean _update = false;

        private GraphEntityTypesListener() {
        }

        public void onGraphEvent(GraphEvent ge) {
            if (12 == ge.getType()) {
                ++this._block;
            } else if (13 == ge.getType()) {
                --this._block;
                this.update();
            } else if (0 == ge.getType() || 3 == ge.getType()) {
                this._update = true;
                this.update();
            }
        }

        private void update() {
            if (this._block == 0 && this._update) {
                ShowFindBarAction.this.updateTypes();
                this._update = false;
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowFindBarAction.this._control.getViewCallback().hideSideBar("south");
            ShowFindBarAction.this.savePreferences();
            GraphID graphID = ShowFindBarAction.this._control.getGraphID();
            Graph2D viewGraph = GraphViewManager.getDefault().getViewGraph(graphID);
            viewGraph.removeGraphListener((GraphListener)ShowFindBarAction.this._typeListener);
            ShowFindBarAction.this._findBar = null;
            JComponent viewControl = ShowFindBarAction.this._control.getViewControl();
            if (viewControl instanceof Graph2DView) {
                for (Component component : viewControl.getComponents()) {
                    if (!(component instanceof Graph2DCanvas)) continue;
                    component.requestFocus();
                    break;
                }
            }
        }
    }

    private class FindAction
    extends AbstractAction {
        private FindAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ShowFindBarAction.this._findBar != null) {
                MaltegoEntitySpec spec = null;
                Object option = ShowFindBarAction.this._findBar.getSelectedOption();
                if (option instanceof MaltegoEntitySpec) {
                    spec = (MaltegoEntitySpec)option;
                }
                ShowFindBarAction.this.savePreferences();
                ListMap map = new ListMap();
                map.put((Object)ShowFindBarAction.PROP_ENTITY_TYPE, (Object)spec);
                map.put((Object)ShowFindBarAction.PROP_DISPLAY_INFO, (Object)ShowFindBarAction.this._findBar.isIncludeDisplayInfo());
                map.put((Object)ShowFindBarAction.PROP_NOTES, (Object)ShowFindBarAction.this._findBar.isIncludeNotes());
                map.put((Object)ShowFindBarAction.PROP_ALL_PROPS, (Object)ShowFindBarAction.this._findBar.isIncludeFields());
                map.put((Object)ShowFindBarAction.PROP_BOOKMARK, (Object)ShowFindBarAction.this._findBar.isBookmarkResults());
                map.put((Object)ShowFindBarAction.PROP_ZOOM_TO_RESULT, (Object)ShowFindBarAction.this._findBar.isZoomToResult());
                map.put((Object)ShowFindBarAction.PROP_FIND_ENTITIES, (Object)ShowFindBarAction.this._findBar.isFindEntities());
                ShowFindBarAction.this._cb.search(ShowFindBarAction.this._findBar.getSearchText(), (Map<String, Object>)map);
            }
        }
    }
}

