/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.edit;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.GraphUser;
import com.paterva.maltego.ui.graph.ModifiedHelper;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.edit.DetailedEditPanel;
import com.paterva.maltego.ui.graph.transacting.GraphTransactorRegistry;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionBatch;
import com.paterva.maltego.ui.graph.transactions.GraphTransactionHelper;
import com.paterva.maltego.ui.graph.transactions.TransactionBatchFactory;
import com.paterva.maltego.util.SimilarStrings;
import com.paterva.maltego.util.ui.components.PanelWithMatteBorderAllSides;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.LayoutManager;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import y.view.Graph2D;

public class DetailedNodeEditor
extends NodeEditor {
    @Override
    public boolean edit(GraphID graphID, EntityID entityID) {
        return this.edit(graphID, entityID, false);
    }

    @Override
    public boolean edit(GraphID graphID, EntityID entityID, boolean showAttachmentTab) {
        MaltegoEntity entity = GraphStoreHelper.getEntity((GraphID)graphID, (EntityID)entityID);
        return this.edit(graphID, (MaltegoPart<? extends Guid>)entity, showAttachmentTab);
    }

    @Override
    public boolean edit(GraphID graphID, LinkID linkID) {
        MaltegoLink link = GraphStoreHelper.getLink((GraphID)graphID, (LinkID)linkID);
        if (link != null) {
            return this.edit(graphID, (MaltegoPart<? extends Guid>)link, false);
        }
        return true;
    }

    private boolean edit(GraphID graphID, MaltegoPart<? extends Guid> part, boolean showAttachmentTab) {
        boolean result;
        MaltegoPart<? extends Guid> oldPart = this.clonePart(part);
        part = this.clonePart(part);
        DetailedEditPanel editor = new DetailedEditPanel(graphID, part);
        if (showAttachmentTab) {
            editor.switchToAttachmentPanel();
        }
        PanelWithMatteBorderAllSides outerPanel = new PanelWithMatteBorderAllSides((LayoutManager)new BorderLayout());
        outerPanel.add(editor);
        DialogDescriptor dd = new DialogDescriptor((Object)outerPanel, "Details");
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        Graph2D viewGraph = GraphViewManager.getDefault().getViewGraph(graphID);
        if (viewGraph != null) {
            viewGraph.updateViews();
        }
        boolean bl = result = dd.getValue() == DialogDescriptor.OK_OPTION;
        if (result) {
            this.update(graphID, part, oldPart);
        }
        return result;
    }

    private MaltegoPart<? extends Guid> clonePart(MaltegoPart<? extends Guid> part) {
        if (part instanceof MaltegoEntity) {
            return ((MaltegoEntity)part).createClone();
        }
        return ((MaltegoLink)part).createClone();
    }

    private void update(GraphID graphID, MaltegoPart part, MaltegoPart oldPart) {
        if (!part.isCopy(oldPart)) {
            GraphTransactionBatch batch = null;
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            String user = GraphUser.getUser(graphID);
            if (part instanceof MaltegoEntity) {
                MaltegoEntity oldEntity = (MaltegoEntity)oldPart;
                MaltegoEntity newEntity = (MaltegoEntity)part;
                if (wrapper.getEntity((EntityID)newEntity.getID()) != null) {
                    ModifiedHelper.updateModified(user, (MaltegoPart<? extends Guid>)newEntity);
                    String descriptionStr = "Modify " + GraphTransactionHelper.getDescriptionForEntity(graphID, oldEntity, true);
                    SimilarStrings description = new SimilarStrings(descriptionStr);
                    batch = TransactionBatchFactory.createEntityUpdateBatch(description, oldEntity, newEntity);
                }
            } else {
                MaltegoLink oldLink = (MaltegoLink)oldPart;
                MaltegoLink newLink = (MaltegoLink)part;
                if (wrapper.getLink((LinkID)newLink.getID()) != null) {
                    ModifiedHelper.updateModified(user, (MaltegoPart<? extends Guid>)newLink);
                    String descriptionStr = "Modify " + GraphTransactionHelper.getDescriptionForLink(graphID, oldLink, true);
                    SimilarStrings description = new SimilarStrings(descriptionStr);
                    batch = TransactionBatchFactory.createLinkUpdateBatch(description, oldLink, newLink);
                }
            }
            if (batch != null && !batch.isEmpty()) {
                GraphTransactorRegistry.getDefault().get(graphID).doTransactions(batch);
            }
        }
    }
}

