/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.edit;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.imgfactory.parts.LinkImageFactory;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorEnumeration;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.HighlightStyle;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.typing.descriptor.TypeSpec;
import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.editing.ComponentFactories;
import com.paterva.maltego.typing.editing.controls.AttachmentsEditorPanel;
import com.paterva.maltego.typing.types.Attachment;
import com.paterva.maltego.typing.types.Attachments;
import com.paterva.maltego.ui.graph.edit.BookmarkButton;
import com.paterva.maltego.ui.graph.edit.NotesPanel;
import com.paterva.maltego.ui.graph.edit.SummaryImageStripModel;
import com.paterva.maltego.ui.graph.edit.SummaryImageStripRenderer;
import com.paterva.maltego.ui.graph.nodes.AddAttachmentsAction;
import com.paterva.maltego.ui.graph.nodes.SpecActionMenuFactory;
import com.paterva.maltego.util.FileStore;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ImageCallback;
import com.paterva.maltego.util.ImageUtils;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.CustomButton;
import com.paterva.maltego.util.ui.LinkLabel;
import com.paterva.maltego.util.ui.WindowUtil;
import com.paterva.maltego.util.ui.image.ImageClickListener;
import com.paterva.maltego.util.ui.image.ImageStrip;
import com.paterva.maltego.util.ui.image.ImageStripModel;
import com.paterva.maltego.util.ui.image.ImageStripRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class DetailedEditPanel
extends JPanel {
    private final int WEST_PANEL_SIZE = 405;
    private final int PROP_MAX = 5;
    private static final int ICON_SIZE_MEDIUM_32 = IconSize.MEDIUM.getSize();
    private static final int ICON_SIZE_LARGE_48 = IconSize.LARGE.getSize();
    private static final Dimension ICON_DIMENSION_MEDIUM = new Dimension(ICON_SIZE_MEDIUM_32, ICON_SIZE_MEDIUM_32);
    private final int THUMBNAIL_SIZE_X = 240;
    private int THUMBNAIL_SIZE_Y;
    private GraphID _graphID;
    private MaltegoPart<? extends Guid> _part;
    private AttachmentsEditorPanel _filesPanel;
    private PropertyChangeListener _listener;
    private NotesPanel _notesPanel;
    private SummaryImageStripModel _imageStripModel;
    private SummaryImageStripRenderer _imageStripRenderer;
    private Component _propertiesEditControl;
    private LinkLabel _morePropertiesLabel;
    private JPanel _actionsPanel;
    private JButton _addAttachmentsButton;
    private JButton _bookmarkButton;
    private JPanel _centerPanel;
    private JLabel _displayNameLabel;
    private JPanel _headerPanel;
    private JLabel _imageLabel;
    private JPanel _imagePanel;
    private JPanel _imageStripPanel;
    private JPanel _notesSummaryPanel;
    private JPanel _propertiesSummaryPanel;
    private JButton _resetButton;
    private JPanel _southPanel;
    private JPanel _summaryPanel;
    private JPanel _summaryTabPanel;
    private JTabbedPane _tabbedPane;
    private JPanel _thumbnailButtonsPanel;
    private JLabel _typeDisplayLabel;
    private JLabel _typeImageLabel;
    private JPanel _typeImagePanel;
    private JLabel _typeLabel;
    private JPanel _typePanel;
    private JPanel _westPanel;
    private JLabel jLabel1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DetailedEditPanel(GraphID graphID, MaltegoPart<? extends Guid> part) {
        WindowUtil.showWaitCursor();
        try {
            this._graphID = graphID;
            this._part = part;
            this.initComponents();
            if (this._part instanceof MaltegoEntity) {
                this._filesPanel = new AttachmentsEditorPanel(this._part, false);
                this._filesPanel.setPropertyBag(this._part);
                this._tabbedPane.addTab(this.getAttachmentsTabTitle(), (Component)this._filesPanel);
                this._notesPanel = new NotesPanel(this._part);
                this._tabbedPane.addTab("Notes", this._notesPanel);
            }
            this.initProperties();
            this._resetButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/edit/reset_normal.png")));
            this._resetButton.setRolloverIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/edit/reset_hover.png")));
            this._addAttachmentsButton.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/edit/add_normal.png")));
            this._addAttachmentsButton.setRolloverIcon(new ImageIcon(ImageUtilities.loadImage((String)"com/paterva/maltego/ui/graph/edit/add_hover.png")));
            ((BookmarkButton)this._bookmarkButton).setColor(BookmarkFactory.getDefault().getColor(Integer.valueOf(this._part.getBookmark())));
            if (this._part instanceof MaltegoEntity) {
                this._imageStripModel = new SummaryImageStripModel();
                this._imageStripRenderer = new SummaryImageStripRenderer();
                this._imageStripPanel.setLayout(new BorderLayout());
                ImageStrip imageStrip = new ImageStrip((ImageStripModel)this._imageStripModel, (ImageStripRenderer)this._imageStripRenderer);
                this._imageStripPanel.add((Component)imageStrip);
                imageStrip.addListener((ImageClickListener)new MyImageClickListener());
            } else {
                this._southPanel.setVisible(false);
            }
            this._notesSummaryPanel.add(new NotesPanel(part));
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            Color darkerBg = laf.getColor("summary-view-panel-darker-bg");
            DetailedEditPanel.setPanelColor(this._westPanel, darkerBg);
            if (this._morePropertiesLabel != null) {
                this._morePropertiesLabel.setHighlightColor(laf.getColor("summary-view-label-fg-highlight"));
            }
            this._bookmarkButton.setBackground(new JPanel().getBackground());
            this.updateActionsButton();
            this.updateTypeImage();
            this.updateThumbnail();
            this.updateHeader();
            this.updateImageStrip();
            this._listener = new MyPropertyChangeListener();
            this._part.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this._listener, this._part));
        }
        finally {
            WindowUtil.hideWaitCursor();
        }
    }

    public void switchToAttachmentPanel() {
        this._tabbedPane.setSelectedComponent((Component)this._filesPanel);
    }

    public static void setPanelColor(Container parent, Color color) {
        for (Component c : parent.getComponents()) {
            if (!(c instanceof Container) || c instanceof JTabbedPane) continue;
            if (c instanceof JPanel) {
                c.setBackground(color);
            }
            DetailedEditPanel.setPanelColor((Container)c, color);
        }
    }

    private SpecRegistry<? extends TypeSpec> getRegistry() {
        LinkRegistry registry = null;
        if (this._part instanceof MaltegoEntity) {
            if (this._graphID != null) {
                registry = EntityRegistry.forGraphID((GraphID)this._graphID);
            }
        } else if (this._part instanceof MaltegoLink) {
            registry = LinkRegistry.getDefault();
        }
        return registry;
    }

    private void initProperties() {
        SpecRegistry<? extends TypeSpec> registry = this.getRegistry();
        DisplayDescriptorCollection summaryProperties = this.getSummaryProperties();
        this.removeAttachmentsProperties(summaryProperties);
        DisplayDescriptorCollection allEditableProperties = this.getAllProperties(summaryProperties);
        this.removeAttachmentsProperties(allEditableProperties);
        this.updateHighlighting(registry, allEditableProperties);
        GroupDefinitions groups = InheritanceHelper.getAggregatedPropertyGroups(registry, (String)this._part.getTypeName());
        Component propertyEditor = ComponentFactories.form().createEditingComponent(this._part, (DisplayDescriptorEnumeration)summaryProperties, groups);
        if (propertyEditor instanceof JComponent) {
            ((JComponent)propertyEditor).setAlignmentX(1.0f);
        }
        this._propertiesSummaryPanel.add(propertyEditor);
        this._propertiesEditControl = ComponentFactories.form((boolean)true).createEditingComponent(this._part, (DisplayDescriptorEnumeration)allEditableProperties, groups);
        this._tabbedPane.addTab("Properties (" + allEditableProperties.size() + ")", this._propertiesEditControl);
        if (allEditableProperties.size() > summaryProperties.size()) {
            this._morePropertiesLabel = new LinkLabel();
            this._morePropertiesLabel.setAlignmentX(1.0f);
            this._morePropertiesLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
            this._morePropertiesLabel.setText("More...");
            this._morePropertiesLabel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DetailedEditPanel.this._tabbedPane.setSelectedComponent(DetailedEditPanel.this._propertiesEditControl);
                }
            });
            this._propertiesSummaryPanel.add((Component)this._morePropertiesLabel);
        }
        this.THUMBNAIL_SIZE_Y = 405 - this._propertiesSummaryPanel.getPreferredSize().height;
        this._propertiesSummaryPanel.add(new Box.Filler(new Dimension(0, 0), new Dimension(1000, 1000), new Dimension(1000, 1000)));
    }

    private DisplayDescriptorCollection getSummaryProperties() {
        PropertyDescriptor valuePd;
        SpecRegistry<? extends TypeSpec> registry = this.getRegistry();
        DisplayDescriptorList summaryProperties = new DisplayDescriptorList();
        PropertyDescriptor displayValuePd = InheritanceHelper.getDisplayValueProperty(registry, this._part).orElse(null);
        if (displayValuePd instanceof DisplayDescriptor) {
            summaryProperties.add((DisplayDescriptor)displayValuePd);
        }
        if ((valuePd = InheritanceHelper.getValueProperty(registry, this._part, (boolean)true)) instanceof DisplayDescriptor && !displayValuePd.equals(valuePd)) {
            summaryProperties.add((DisplayDescriptor)valuePd);
        }
        DisplayDescriptorCollection properties = InheritanceHelper.getAggregatedProperties(registry, (String)this._part.getTypeName());
        this.addDependantProperties(displayValuePd, properties, (DisplayDescriptorCollection)summaryProperties);
        if (!displayValuePd.equals(valuePd)) {
            this.addDependantProperties(valuePd, properties, (DisplayDescriptorCollection)summaryProperties);
        }
        return summaryProperties;
    }

    private DisplayDescriptorCollection getAllProperties(DisplayDescriptorCollection summaryProperties) {
        SpecRegistry<? extends TypeSpec> registry = this.getRegistry();
        DisplayDescriptorList allEditableProperties = new DisplayDescriptorList((Iterable)summaryProperties);
        DisplayDescriptorCollection specProperties = InheritanceHelper.getAggregatedProperties(registry, (String)this._part.getTypeName());
        for (DisplayDescriptor dd : specProperties) {
            if (dd.isHidden() || allEditableProperties.contains(dd.getName())) continue;
            allEditableProperties.add(dd);
        }
        PropertyDescriptorCollection partPds = this._part.getProperties();
        for (PropertyDescriptor pd : partPds) {
            if (pd.isHidden() || allEditableProperties.contains(pd.getName())) continue;
            DisplayDescriptor dd = pd instanceof DisplayDescriptor ? new DisplayDescriptor((DisplayDescriptor)pd) : new DisplayDescriptor(pd);
            allEditableProperties.add(dd);
        }
        return allEditableProperties;
    }

    private void addDependantProperties(PropertyDescriptor displayValuePd, DisplayDescriptorCollection properties, DisplayDescriptorCollection editProperties) {
        List linkedProperties = displayValuePd.getLinkedProperties();
        block0: for (PropertyDescriptor pd : linkedProperties) {
            if (editProperties.size() >= 5) {
                return;
            }
            for (DisplayDescriptor dd : properties) {
                if (!dd.equals(pd)) continue;
                if (editProperties.contains(dd)) continue block0;
                editProperties.add(dd);
                continue block0;
            }
        }
    }

    private void removeAttachmentsProperties(DisplayDescriptorCollection properties) {
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            DisplayDescriptor dd = (DisplayDescriptor)it.next();
            if (!Attachments.class.equals((Object)dd.getType())) continue;
            it.remove();
        }
    }

    private void updateHighlighting(SpecRegistry<? extends TypeSpec> registry, DisplayDescriptorCollection properties) {
        PropertyDescriptor valueProperty = InheritanceHelper.getValueProperty(registry, this._part, (boolean)true);
        PropertyDescriptor displayValueProperty = InheritanceHelper.getDisplayValueProperty(registry, this._part).orElse(null);
        for (DisplayDescriptor dd : properties) {
            if (dd.equals(displayValueProperty)) {
                dd.setHighlight(HighlightStyle.Medium);
            }
            if (!dd.equals(valueProperty)) continue;
            dd.setHighlight(HighlightStyle.High);
        }
    }

    private void updateActionsButton() {
        MaltegoEntity entity = null;
        if (this._part instanceof MaltegoEntity) {
            entity = (MaltegoEntity)this._part;
        }
        this._actionsPanel.removeAll();
        if (entity != null) {
            EntityRegistry registry = (EntityRegistry)this.getRegistry();
            ArrayList<MaltegoEntity> entities = new ArrayList<MaltegoEntity>();
            entities.add(entity);
            List<Action> actions = new SpecActionMenuFactory().getActions(registry, entities);
            UIDefaults laf = UIManager.getLookAndFeelDefaults();
            for (Action action : actions) {
                LinkLabel ll = new LinkLabel();
                ll.setForeground(laf.getColor("summary-view-label-fg"));
                ll.setHighlightColor(laf.getColor("summary-view-label-fg-highlight"));
                ll.addActionListener((ActionListener)action);
                Object name = action.getValue("Name");
                if (name instanceof String) {
                    ll.setText((String)name);
                } else {
                    ll.setText("Unnamed Action");
                }
                this._actionsPanel.add(Box.createVerticalStrut(5));
                this._actionsPanel.add((Component)ll);
            }
        }
    }

    private void updateHeader() {
        TypeSpec spec;
        String type;
        String displayName = InheritanceHelper.getDisplayString(this.getRegistry(), this._part);
        if (StringUtilities.isNullOrEmpty((String)displayName)) {
            displayName = "<empty>";
        }
        this._displayNameLabel.setText(displayName);
        String displayType = type = this._part.getTypeName();
        SpecRegistry<? extends TypeSpec> registry = this.getRegistry();
        if (registry != null && (spec = registry.get(type)) != null) {
            displayType = spec.getDisplayName();
        }
        this._typeLabel.setText("[" + type + "]");
        this._typeDisplayLabel.setText(displayType);
    }

    private void updateTypeImage() {
        this._typeImageLabel.setText("");
        Image image = null;
        if (this._part instanceof MaltegoEntity) {
            EntityImageFactory factory = EntityImageFactory.forGraph((GraphID)this._graphID);
            image = factory.getTypeImage(this._part.getTypeName(), ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48, null);
        } else if (this._part instanceof MaltegoLink) {
            MaltegoLinkSpec spec = (MaltegoLinkSpec)LinkRegistry.forGraphID((GraphID)this._graphID).get(((MaltegoLink)this._part).getTypeName());
            image = LinkImageFactory.getImage((MaltegoLinkSpec)spec, (int)ICON_SIZE_LARGE_48);
        }
        this._typeImageLabel.setIcon(ImageUtils.toIcon(image));
    }

    private void updateThumbnail() {
        this._imageLabel.setText("");
        Image image = null;
        if (this._part instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)this._part;
            EntityImageFactory factory = EntityImageFactory.forGraph((GraphID)this._graphID);
            image = factory.hasImage(entity) ? factory.getImageMax(entity, 240, this.THUMBNAIL_SIZE_Y, (ImageCallback)new ThumbnailImageCallback()) : factory.getTypeImage(entity.getTypeName(), null);
        } else if (this._part instanceof MaltegoLink) {
            MaltegoLinkSpec spec = (MaltegoLinkSpec)LinkRegistry.forGraphID((GraphID)this._graphID).get(((MaltegoLink)this._part).getTypeName());
            image = LinkImageFactory.getImage((MaltegoLinkSpec)spec, (int)ICON_SIZE_LARGE_48);
        }
        this._imageLabel.setIcon(ImageUtils.toIcon(image));
    }

    private void updateImageStrip() {
        if (this._part instanceof MaltegoEntity) {
            List atts = AttachmentUtils.getImageAttachments(this._part);
            this._imageStripModel.setAttachments(atts);
            Attachment imageAtt = AttachmentUtils.getEntityImageAttachment((MaltegoEntity)((MaltegoEntity)this._part));
            this._imageStripModel.setSelected(imageAtt);
        }
    }

    private void initComponents() {
        this._tabbedPane = new JTabbedPane();
        this._summaryTabPanel = new JPanel();
        this._headerPanel = new JPanel();
        this._summaryPanel = new JPanel();
        this._displayNameLabel = new JLabel();
        this._typePanel = new JPanel();
        this._typeDisplayLabel = new JLabel();
        this._typeLabel = new JLabel();
        this._bookmarkButton = new BookmarkButton();
        this._actionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this._typeImagePanel = new JPanel();
        this._typeImageLabel = new JLabel();
        this._southPanel = new JPanel();
        this._thumbnailButtonsPanel = new JPanel();
        this._resetButton = new CustomButton(ICON_SIZE_MEDIUM_32, ICON_SIZE_MEDIUM_32);
        this._addAttachmentsButton = new CustomButton(ICON_SIZE_MEDIUM_32, ICON_SIZE_MEDIUM_32);
        this._imageStripPanel = new JPanel();
        this._centerPanel = new JPanel();
        this._notesSummaryPanel = new JPanel();
        this._westPanel = new JPanel();
        this._propertiesSummaryPanel = new JPanel();
        this._imagePanel = new JPanel();
        this._imageLabel = new JLabel();
        this.setPreferredSize(new Dimension(800, 700));
        this.setLayout(new BorderLayout());
        this._summaryTabPanel.setLayout(new BorderLayout());
        this._headerPanel.setLayout(new BorderLayout());
        this._summaryPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 6, 6));
        this._summaryPanel.setLayout(new BorderLayout());
        this._displayNameLabel.setFont(UIManager.getLookAndFeelDefaults().getFont("summary-view-notes-font"));
        this._displayNameLabel.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._displayNameLabel.text"));
        this._summaryPanel.add((Component)this._displayNameLabel, "Center");
        this._typePanel.setLayout(new GridBagLayout());
        this._typeDisplayLabel.setFont(this._typeDisplayLabel.getFont().deriveFont((float)this._typeDisplayLabel.getFont().getSize() + 3.0f));
        this._typeDisplayLabel.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-description-foreground"));
        this._typeDisplayLabel.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._typeDisplayLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 0, 3, 10);
        this._typePanel.add((Component)this._typeDisplayLabel, gridBagConstraints);
        this._typeLabel.setFont(this._typeLabel.getFont().deriveFont((float)this._typeLabel.getFont().getSize() - 1.0f));
        this._typeLabel.setForeground(UIManager.getLookAndFeelDefaults().getColor("7-description-foreground"));
        this._typeLabel.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._typeLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 5, 10);
        this._typePanel.add((Component)this._typeLabel, gridBagConstraints);
        this._bookmarkButton.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._bookmarkButton.text"));
        this._bookmarkButton.setMaximumSize(ICON_DIMENSION_MEDIUM);
        this._bookmarkButton.setMinimumSize(ICON_DIMENSION_MEDIUM);
        this._bookmarkButton.setPreferredSize(ICON_DIMENSION_MEDIUM);
        this._bookmarkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailedEditPanel.this._bookmarkButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 0.5;
        this._typePanel.add((Component)this._bookmarkButton, gridBagConstraints);
        this._summaryPanel.add((Component)this._typePanel, "South");
        this._headerPanel.add((Component)this._summaryPanel, "Center");
        this._actionsPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 10));
        this._actionsPanel.setLayout(new BoxLayout(this._actionsPanel, 1));
        this.jLabel1.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel.jLabel1.text"));
        this._actionsPanel.add(this.jLabel1);
        this._headerPanel.add((Component)this._actionsPanel, "East");
        this._typeImagePanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
        this._typeImagePanel.setLayout(new GridBagLayout());
        this._typeImageLabel.setHorizontalAlignment(0);
        this._typeImageLabel.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._typeImageLabel.text"));
        this._typeImageLabel.setAlignmentX(0.5f);
        this._typeImagePanel.add((Component)this._typeImageLabel, new GridBagConstraints());
        this._headerPanel.add((Component)this._typeImagePanel, "West");
        this._summaryTabPanel.add((Component)this._headerPanel, "North");
        this._southPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._southPanel.setLayout(new BorderLayout());
        this._thumbnailButtonsPanel.setLayout(new GridBagLayout());
        this._resetButton.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._resetButton.text"));
        this._resetButton.setToolTipText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._resetButton.toolTipText"));
        this._resetButton.setMaximumSize(ICON_DIMENSION_MEDIUM);
        this._resetButton.setMinimumSize(ICON_DIMENSION_MEDIUM);
        this._resetButton.setPreferredSize(ICON_DIMENSION_MEDIUM);
        this._resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailedEditPanel.this._resetButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this._thumbnailButtonsPanel.add((Component)this._resetButton, gridBagConstraints);
        this._addAttachmentsButton.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._addAttachmentsButton.text"));
        this._addAttachmentsButton.setToolTipText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._addAttachmentsButton.toolTipText"));
        this._addAttachmentsButton.setMaximumSize(ICON_DIMENSION_MEDIUM);
        this._addAttachmentsButton.setMinimumSize(ICON_DIMENSION_MEDIUM);
        this._addAttachmentsButton.setPreferredSize(ICON_DIMENSION_MEDIUM);
        this._addAttachmentsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailedEditPanel.this._addAttachmentsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this._thumbnailButtonsPanel.add((Component)this._addAttachmentsButton, gridBagConstraints);
        this._southPanel.add((Component)this._thumbnailButtonsPanel, "West");
        this._imageStripPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this._imageStripPanel.setMinimumSize(new Dimension(0, 50));
        this._imageStripPanel.setPreferredSize(new Dimension(676, 50));
        GroupLayout _imageStripPanelLayout = new GroupLayout(this._imageStripPanel);
        this._imageStripPanel.setLayout(_imageStripPanelLayout);
        _imageStripPanelLayout.setHorizontalGroup(_imageStripPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 733, Short.MAX_VALUE));
        _imageStripPanelLayout.setVerticalGroup(_imageStripPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 84, Short.MAX_VALUE));
        this._southPanel.add((Component)this._imageStripPanel, "Center");
        this._summaryTabPanel.add((Component)this._southPanel, "South");
        this._centerPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 10));
        this._centerPanel.setLayout(new BorderLayout());
        this._notesSummaryPanel.setBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeelDefaults().getColor("darculaMod.borderColor")));
        this._notesSummaryPanel.setLayout(new BorderLayout());
        this._centerPanel.add((Component)this._notesSummaryPanel, "Center");
        this._westPanel.setMinimumSize(new Dimension(300, 500));
        this._westPanel.setPreferredSize(new Dimension(300, 500));
        this._westPanel.setLayout(new BorderLayout());
        this._propertiesSummaryPanel.setLayout(new BoxLayout(this._propertiesSummaryPanel, 1));
        this._westPanel.add((Component)this._propertiesSummaryPanel, "Center");
        this._imagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._imagePanel.setLayout(new BoxLayout(this._imagePanel, 1));
        this._imageLabel.setHorizontalAlignment(0);
        this._imageLabel.setText(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._imageLabel.text"));
        this._imageLabel.setAlignmentX(0.5f);
        this._imageLabel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this._imagePanel.add(this._imageLabel);
        this._westPanel.add((Component)this._imagePanel, "North");
        this._centerPanel.add((Component)this._westPanel, "West");
        this._summaryTabPanel.add((Component)this._centerPanel, "Center");
        this._tabbedPane.addTab(NbBundle.getMessage(DetailedEditPanel.class, (String)"DetailedEditPanel._summaryTabPanel.TabConstraints.tabTitle"), this._summaryTabPanel);
        this.add((Component)this._tabbedPane, "Center");
    }

    private void _resetButtonActionPerformed(ActionEvent evt) {
        if (this._part instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)this._part;
            entity.setImageExpression("");
        }
    }

    private void _addAttachmentsButtonActionPerformed(ActionEvent evt) {
        if (this._part instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)this._part;
            AddAttachmentsAction action = (AddAttachmentsAction)SystemAction.get(AddAttachmentsAction.class);
            action.perform(entity);
        }
    }

    private void _bookmarkButtonActionPerformed(ActionEvent evt) {
        if (this._part instanceof MaltegoEntity) {
            MaltegoEntity entity = (MaltegoEntity)this._part;
            int oldBookmark = entity.getBookmark();
            int newBookmark = BookmarkFactory.getDefault().getNext(oldBookmark);
            entity.setBookmark(Integer.valueOf(newBookmark));
            ((BookmarkButton)this._bookmarkButton).setColor(BookmarkFactory.getDefault().getColor(Integer.valueOf(newBookmark)));
        }
    }

    private String getAttachmentsTabTitle() {
        return "Attachments (" + AttachmentUtils.getAttachmentCount(this._part) + ")";
    }

    private class MyImageClickListener
    implements ImageClickListener {
        private boolean _wasDoubleClick = false;

        private MyImageClickListener() {
        }

        public void onClick(Object image, int clicks) {
            if (DetailedEditPanel.this._part instanceof MaltegoEntity) {
                Attachment att = (Attachment)image;
                if (clicks == 2) {
                    this._wasDoubleClick = true;
                    this.openExternal(att);
                } else if (clicks == 1) {
                    this.selectAttachment((MaltegoEntity)DetailedEditPanel.this._part, att);
                }
            }
        }

        private void selectAttachment(MaltegoEntity entity, Attachment att) {
            AttachmentUtils.setAttachmentAsEntityImage((MaltegoEntity)entity, (Attachment)att);
            DetailedEditPanel.this._imageStripModel.setSelected(att);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void openExternal(Attachment att) {
            Cursor cursor = DetailedEditPanel.this.getCursor();
            DetailedEditPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            Desktop desktop = Desktop.getDesktop();
            try {
                File file = FileStore.getDefault().get(att.getId());
                try {
                    desktop.open(file);
                }
                catch (IOException ex) {
                    this.showCouldNotOpen(ex, file.getName());
                }
            }
            catch (FileNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            finally {
                DetailedEditPanel.this.setCursor(cursor);
            }
        }

        private void showCouldNotOpen(IOException ex, String filename) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The JVM was unable to find an application associated with the \"Open\" command for the file: " + filename), 0);
            msg.setTitle("Could not open file");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
        }

        private /* synthetic */ void lambda$onClick$0(Attachment att, ActionEvent __) {
            if (this._wasDoubleClick) {
                this._wasDoubleClick = false;
            } else {
                this.selectAttachment((MaltegoEntity)DetailedEditPanel.this._part, att);
            }
        }
    }

    private class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            DetailedEditPanel.this.updateThumbnail();
            DetailedEditPanel.this.updateHeader();
            DetailedEditPanel.this.updateImageStrip();
            DetailedEditPanel.this.updateActionsButton();
            if (DetailedEditPanel.this._part instanceof MaltegoEntity) {
                DetailedEditPanel.this._tabbedPane.setTitleAt(1, DetailedEditPanel.this.getAttachmentsTabTitle());
            }
        }
    }

    private class ThumbnailImageCallback
    implements ImageCallback {
        private ThumbnailImageCallback() {
        }

        public void imageReady(Image image) {
            DetailedEditPanel.this._imageLabel.setIcon(this.toIcon(image));
        }
    }
}

