/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.ui.graph.data.RecentFiles;
import com.pinkmatter.spi.flamingo.RibbonDefaultRolloverProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.JPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButtonPanel;

public class RecentFilesRolloverProvider
extends RibbonDefaultRolloverProvider {
    public void menuEntryActivated(JPanel panel) {
        panel.removeAll();
        JCommandButtonPanel openHistoryPanel = new JCommandButtonPanel(CommandButtonDisplayState.MEDIUM);
        String groupName = "Recent Documents";
        openHistoryPanel.addButtonGroup(groupName);
        for (final String s : RecentFiles.getInstance().getMRUFileList()) {
            try {
                final File file = Utilities.toFile((URI)URI.create(s));
                JCommandButton historyButton = new JCommandButton(file.getName());
                historyButton.setHorizontalAlignment(2);
                openHistoryPanel.addButtonToLastGroup((AbstractCommandButton)historyButton);
                historyButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileObject fo = FileUtil.toFileObject((File)file);
                        if (fo == null) {
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)("The file was not found:\n" + file.getAbsolutePath()), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                            RecentFiles.getInstance().removeFile(s);
                        } else {
                            try {
                                DataObject dao = DataObject.find((FileObject)fo);
                                if (dao != null) {
                                    OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                                    open.open();
                                }
                            }
                            catch (DataObjectNotFoundException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        openHistoryPanel.setMaxButtonColumns(1);
        panel.setLayout(new BorderLayout());
        panel.add((Component)openHistoryPanel, "Center");
    }
}

