/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.data;

import com.paterva.maltego.archive.mtz.GraphFileType;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphLifeCycleManager;
import com.paterva.maltego.graph.metadata.GraphMetadataManager;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStore;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.undo.UndoRedoManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.data.GraphEditorSupport;
import com.paterva.maltego.ui.graph.data.GraphNameSuffixProvider;
import com.paterva.maltego.util.HtmlUtils;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.model.ZipParameters;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public abstract class GraphDataObject
extends MultiDataObject
implements GraphCookie {
    public static final String PROP_CAN_FREEZE = "canFreezeGraph";
    private GraphID _graphID = GraphID.create();
    private SaveCookie _saveCookie;
    private PropertyChangeListener _listener;
    private String _password;
    private boolean _isNew = false;
    private GraphEditorSupport _editor;
    private Color _displayNameColor = null;
    private boolean _canFreeze = true;
    private GraphFileType _fileType = GraphFileType.PANDORA;
    private boolean _loaded = false;
    private RenameListener _renameListener;

    public GraphDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.initialize();
    }

    @Override
    public void setGraphID(GraphID graphID) {
        this._graphID = graphID;
    }

    private void initialize() {
        GraphEditorSupport editor;
        this._renameListener = new RenameListener();
        this.getPrimaryFile().addFileChangeListener((FileChangeListener)this._renameListener);
        this._editor = editor = new GraphEditorSupport(this.getPrimaryEntry());
        this._saveCookie = new SaveCookieImpl();
        this.getCookieSet().add((Node.Cookie)editor);
        this.updateDisplayName();
    }

    public void setNew(boolean isNew) {
        this._isNew = isNew;
    }

    protected Node createNodeDelegate() {
        return new DataNode((DataObject)this, Children.LEAF, this.getLookup());
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    @Override
    public synchronized GraphID getOrLoadGraph() {
        if (!this._loaded) {
            GraphLifeCycleManager.getDefault().fireGraphOpening(this._graphID);
            GraphLifeCycleManager.getDefault().fireGraphLoading(this._graphID);
            try {
                this.loadGraphImpl(this._graphID);
                this.onGraphLoaded();
            }
            catch (IOException ex) {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
                nd.setTitle("Error loading graph");
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                NormalException.logStackTrace((Throwable)ex);
                SwingUtilities.invokeLater(() -> this._editor.close());
                return null;
            }
        }
        return this._graphID;
    }

    @Override
    public boolean isLoaded() {
        return this._loaded;
    }

    @Override
    public synchronized GraphID getGraphID() {
        return this._graphID;
    }

    @Override
    public void onGraphLoaded() {
        this.initGraph();
        this._loaded = true;
        GraphLifeCycleManager.getDefault().fireGraphLoaded(this._graphID);
    }

    @Override
    public void onGraphClosed() {
        this.getPrimaryFile().removeFileChangeListener((FileChangeListener)this._renameListener);
        this._renameListener = null;
        try {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphDataStore dataStore = graphStore.getGraphDataStore();
            GraphStructureStore structureStore = graphStore.getGraphStructureStore();
            GraphLayoutStore layoutStore = graphStore.getGraphLayoutStore();
            dataStore.removePropertyChangeListener(this._listener);
            structureStore.removePropertyChangeListener(this._listener);
            layoutStore.removePropertyChangeListener(this._listener);
            graphStore.close(true);
            this._listener = null;
        }
        catch (GraphStoreException ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        GraphLifeCycleManager.getDefault().fireGraphClosed(this._graphID);
        this._loaded = false;
    }

    private void initGraph() {
        try {
            UndoRedoManager undoRedoManager;
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(this._graphID);
            GraphDataStore dataStore = graphStore.getGraphDataStore();
            GraphStructureStore structureStore = graphStore.getGraphStructureStore();
            GraphLayoutStore layoutStore = graphStore.getGraphLayoutStore();
            this._listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    GraphDataObject.this.setModified(true);
                }
            };
            dataStore.addPropertyChangeListener(this._listener);
            structureStore.addPropertyChangeListener(this._listener);
            layoutStore.addPropertyChangeListener(this._listener);
            if (this._isNew) {
                GraphMetadataManager.getDefault().get(this._graphID).setCreated(new Date());
                this._isNew = false;
            }
            if ((undoRedoManager = UndoRedoManager.getDefault()).get(this._graphID) == null) {
                undoRedoManager.create(this._graphID);
            }
            this.setModified(false);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void setModified(boolean modified) {
        if (this.isModified() != modified) {
            super.setModified(modified);
            if (modified) {
                this.addSaveCookie();
            } else {
                this.removeSaveCookie();
            }
            this.updateDisplayName();
        }
    }

    private void addSaveCookie() {
        if (this.getSaveCookie() == null) {
            this.getCookieSet().add((Node.Cookie)this._saveCookie);
        }
    }

    private void removeSaveCookie() {
        SaveCookie save = this.getSaveCookie();
        if (save != null) {
            this.getCookieSet().remove((Node.Cookie)save);
            this.setModified(false);
        }
    }

    private SaveCookie getSaveCookie() {
        return (SaveCookie)this.getLookup().lookup(SaveCookie.class);
    }

    public void addCookie(Node.Cookie cookie) {
        this.getCookieSet().add(cookie);
    }

    public void removeCookie(Node.Cookie cookie) {
        this.getCookieSet().remove(cookie);
    }

    protected abstract void loadGraphImpl(GraphID var1) throws IOException;

    public abstract void saveGraph(GraphID var1, OutputStream var2, ProgressHandle var3, AtomicBoolean var4, GraphFileType var5) throws IOException;

    public abstract void saveGraph(GraphID var1, ZipFile var2, ZipParameters var3, ProgressHandle var4, AtomicBoolean var5, GraphFileType var6) throws IOException;

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public GraphFileType getFileType() {
        return this._fileType;
    }

    public void setFileType(GraphFileType fileType) {
        this._fileType = fileType;
    }

    public void setDisplayNameColor(Color color) {
        if (!Utilities.compareObjects((Object)color, (Object)this._displayNameColor)) {
            this._displayNameColor = color;
            this.updateDisplayName();
        }
    }

    public Color getDisplayNameColor() {
        return this._displayNameColor;
    }

    public String getHTMLDisplayName() {
        String htmlTitle = this.getName();
        Collection suffixProviders = this.getLookup().lookupAll(GraphNameSuffixProvider.class);
        for (GraphNameSuffixProvider suffixProvider : suffixProviders) {
            String suffix = suffixProvider.getGraphNameSuffix();
            if (StringUtilities.isNullOrEmpty((String)suffix)) continue;
            htmlTitle = String.format("%s - %s", htmlTitle, suffix);
        }
        if (this.isModified()) {
            htmlTitle = HtmlUtils.makeBold((String)htmlTitle);
        }
        if (this._displayNameColor != null) {
            htmlTitle = HtmlUtils.addColor((String)htmlTitle, (Color)this._displayNameColor);
        }
        htmlTitle = HtmlUtils.addSkeleton((String)htmlTitle);
        return htmlTitle;
    }

    public void updateDisplayName() {
        this._editor.updateHTMLTitle(this.getHTMLDisplayName());
    }

    public boolean canFreeze() {
        return this._canFreeze;
    }

    public void setCanFreeze(boolean canFreeze) {
        if (this._canFreeze != canFreeze) {
            this._canFreeze = canFreeze;
            this.firePropertyChange(PROP_CAN_FREEZE, !this._canFreeze, this._canFreeze);
        }
    }

    public String renamePrimaryFile(String name, boolean findFreeName) throws IOException {
        FileObject primaryFile = this.getPrimaryFile();
        String freeName = name;
        try (FileLock lock = primaryFile.lock();){
            if (lock != null) {
                FileObject parent = primaryFile.getParent();
                String ext = this.getFileType().getExtension();
                if (findFreeName) {
                    freeName = FileUtil.findFreeFileName((FileObject)parent, (String)name, (String)ext);
                }
                primaryFile.rename(lock, freeName, ext);
            }
        }
        return freeName;
    }

    protected FileObject handleRename(String name) throws IOException {
        try (FileLock lock = this.getPrimaryEntry().takeLock();){
            if (lock != null) {
                String ext = this.getFileType().getExtension();
                FileObject primaryFile = this.getPrimaryFile();
                String oldNameExt = primaryFile.getNameExt();
                String newNameExt = name + "." + ext;
                if (!newNameExt.equals(oldNameExt)) {
                    this.getPrimaryFile().rename(lock, name, ext);
                }
            }
        }
        return this.getPrimaryFile();
    }

    private class RenameListener
    extends FileChangeAdapter {
        private RenameListener() {
        }

        public void fileRenamed(FileRenameEvent fe) {
            GraphDataObject.this.updateDisplayName();
        }
    }

    private class SaveCookieImpl
    implements SaveCookie {
        private SaveCookieImpl() {
        }

        public void save() throws IOException {
            if (GraphDataObject.this.isModified()) {
                GraphDataObject.this._editor.save();
            }
        }

        public String toString() {
            return GraphDataObject.this.getPrimaryFile().getName();
        }
    }
}

