/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.clipboard;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.layout.GraphLayoutReader;
import com.paterva.maltego.graph.store.layout.GraphLayoutStore;
import com.paterva.maltego.graph.store.layout.GraphLayoutWriter;
import com.paterva.maltego.ui.graph.actions.MouseGraphUtils;
import com.paterva.maltego.ui.graph.clipboard.AbstractGraphMLPasteAction;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.util.Exceptions;

public abstract class MouseLocationGraphPasteAction
extends AbstractGraphMLPasteAction {
    @Override
    protected void prePasteGraph(GraphID targetGraphID, GraphID graphToPasteID) {
        Point2D.Double pastePoint = MouseGraphUtils.getMouseOrCenterPoint();
        if (pastePoint != null) {
            try {
                GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphToPasteID);
                GraphLayoutStore layoutStore = graphStore.getGraphLayoutStore();
                GraphLayoutReader layoutReader = layoutStore.getLayoutReader();
                Map<EntityID, Point> centers = layoutReader.getAllCenters();
                Map<LinkID, List<Point>> paths = layoutReader.getAllPaths();
                Point average = this.getAverage(centers);
                Point translateDistance = average == null ? new Point((int)pastePoint.x, (int)pastePoint.y) : new Point((int)pastePoint.x - average.x, (int)pastePoint.y - average.y);
                centers = this.translateCenters(centers, translateDistance);
                paths = this.translatePaths(paths, translateDistance);
                GraphLayoutWriter layoutWriter = layoutStore.getLayoutWriter();
                layoutWriter.setCenters(centers);
                layoutWriter.setPaths(paths);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private Map<EntityID, Point> translateCenters(Map<EntityID, Point> centers, Point distance) {
        HashMap<EntityID, Point> newCenters = new HashMap<EntityID, Point>(centers.size());
        for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
            EntityID entityID = entry.getKey();
            Point center = entry.getValue();
            center = center == null ? new Point(distance.x, distance.y) : new Point(center.x + distance.x, center.y + distance.y);
            newCenters.put(entityID, center);
        }
        return newCenters;
    }

    private Map<LinkID, List<Point>> translatePaths(Map<LinkID, List<Point>> paths, Point distance) {
        HashMap<LinkID, List<Point>> newPaths = new HashMap<LinkID, List<Point>>();
        for (Map.Entry<LinkID, List<Point>> entry : paths.entrySet()) {
            LinkID linkID = entry.getKey();
            List<Point> path = entry.getValue();
            if (path == null || path.size() <= 2) continue;
            ArrayList<Point> newPath = new ArrayList<Point>(path.size());
            for (int i = 0; i < path.size(); ++i) {
                Point point = path.get(i);
                if (i != 0 && i != path.size() - 1) {
                    point = new Point(point.x + distance.x, point.y + distance.y);
                }
                newPath.add(point);
            }
            newPaths.put(linkID, newPath);
        }
        return newPaths;
    }

    private Point getAverage(Map<EntityID, Point> centers) {
        long x = 0L;
        long y = 0L;
        long count = 0L;
        for (Map.Entry<EntityID, Point> entry : centers.entrySet()) {
            Point center = entry.getValue();
            if (center == null) continue;
            x += (long)center.x;
            y += (long)center.y;
            ++count;
        }
        return count == 0L ? null : new Point((int)(x / count), (int)(y / count));
    }
}

