/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;

public class ZoomToAction
extends TopGraphAction
implements RibbonPresenter.Button {
    private JCommandButton _zoomLevel;
    private static final String[] LEVELS = new String[]{"200%", "150%", "100%", "75%", "50%", "25%", "10%"};
    private static final double[] FACTORS = new double[]{2.0, 1.5, 1.0, 0.75, 0.5, 0.25, 0.1};

    private static double getZoomLevel(String s) {
        for (int i = 0; i < LEVELS.length; ++i) {
            if (!LEVELS[i].equals(s)) continue;
            return FACTORS[i];
        }
        return -1.0;
    }

    private void setZoom(double zoom) {
        GraphViewCookie cookie = this.getTopGraphViewCookie();
        if (zoom > 0.0 && cookie != null) {
            cookie.getGraphView().setZoom(zoom);
        }
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    public String getName() {
        return "Zoom to";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/Zoom.png";
    }

    private String tooltipIcon() {
        return "com/paterva/maltego/ui/graph/actions/Zoom48.png";
    }

    @Override
    protected void actionPerformed(TopComponent tc) {
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._zoomLevel == null) {
            ActionListener popupListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCommandMenuButton button = (JCommandMenuButton)e.getSource();
                    double zoom = ZoomToAction.getZoomLevel(button.getText());
                    ZoomToAction.this.setZoom(zoom);
                }
            };
            final JCommandPopupMenu zoomLevelMenu = new JCommandPopupMenu();
            for (String level : LEVELS) {
                JCommandMenuButton b = new JCommandMenuButton(level, null);
                b.addActionListener(popupListener);
                zoomLevelMenu.addMenuButton(b);
            }
            this._zoomLevel = new JCommandButton("Zoom to", ResizableIcons.fromResource((String)this.iconResource()));
            this._zoomLevel.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            RichTooltip zoomLevelTooltip = new RichTooltip("Set Zoom level", "Zoom to a preset zoom level");
            zoomLevelTooltip.setMainImage(ImageUtilities.loadImage((String)this.tooltipIcon()));
            zoomLevelTooltip.addFooterSection("Click the help button to get more help on Maltego features");
            zoomLevelTooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._zoomLevel.setActionRichTooltip(zoomLevelTooltip);
            this._zoomLevel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ZoomToAction.this.setZoom(1.0);
                }
            });
            this._zoomLevel.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return zoomLevelMenu;
                }
            });
        }
        return this._zoomLevel;
    }
}

