/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.TopGraphViewRegistry;
import com.paterva.maltego.ui.graph.util.GraphViewStorageUtility;
import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import y.view.Graph2D;

public abstract class TopGraphAction
extends SystemAction {
    private final TopGraphViewRegistry _registry = TopGraphViewRegistry.getDefault();
    private final GraphSelectionContext selectionContext = GraphSelectionContext.instance();
    private GraphViewCookie _graphViewCookie = null;

    public TopGraphAction() {
        this._registry.addPropertyChangeListener(evt -> {
            if ("topGraphViewChanged".equals(evt.getPropertyName())) {
                this.onTopGraphChanged();
            }
        });
        this.setEnabled(false);
    }

    protected abstract void actionPerformed(TopComponent var1);

    protected boolean isEnabled(TopComponent tc) {
        GraphID topGraphID;
        if (tc != null && (topGraphID = this.getTopGraphID()) != null) {
            try {
                return GraphStoreRegistry.getDefault().isExistingAndOpen(topGraphID);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    protected TopComponent getTopComponent() {
        return GraphEditorRegistry.getDefault().getTopmost();
    }

    protected GraphViewCookie getTopGraphViewCookie() {
        return this._graphViewCookie;
    }

    protected GraphView getTopGraphView() {
        return this._graphViewCookie == null ? null : this._graphViewCookie.getGraphView();
    }

    protected Graph2D getTopViewGraph() {
        GraphView graphView = this.getTopGraphView();
        return graphView == null ? null : graphView.getViewGraph();
    }

    protected GraphID getTopGraphID() {
        Graph2D graph = this.getTopViewGraph();
        if (graph != null) {
            return GraphIDProvider.forGraph((Graph2D)graph);
        }
        return this.selectionContext.getTopGraphID();
    }

    public void actionPerformed(ActionEvent ev) {
        TopComponent topComponent = this.getTopComponent();
        this.actionPerformed(topComponent);
        SwingUtilities.invokeLater(() -> {
            if (topComponent != null) {
                topComponent.requestActive();
            }
        });
    }

    protected void onTopGraphChanged() {
        GraphID graphID;
        this._graphViewCookie = null;
        TopComponent tc = this.getTopComponent();
        if (tc != null && (graphID = this.getTopGraphID()) != null) {
            this._graphViewCookie = GraphViewStorageUtility.getGraphViewCookie(graphID);
            if (this._graphViewCookie == null) {
                this._graphViewCookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class);
                GraphViewStorageUtility.putGraphViewCookie(graphID, this._graphViewCookie);
            }
        }
        this.setEnabled(this.isEnabled(tc));
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

