/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.GraphStructureUtils;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import com.pinkmatter.api.flamingo.RibbonPresenters;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class SelectionToggleAction
extends CallableSystemAction
implements RibbonPresenter.Button {
    private static final int ICON_SIZE_LARGE_48 = IconSize.LARGE.getSize();
    private AbstractCommandButton _ribbonPresenter;
    private ResizableIcon _linkIcon;
    private ResizableIcon _entityIcon;
    private ResizableIcon _tooltipLinkIcon;
    private ResizableIcon _tooltipEntityIcon;

    public SelectionToggleAction() {
        SelectionMode.addPropertyChangeListener(new SelectionModeListener());
    }

    public String getName() {
        return "Selection mode";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectionToggleEntity.png";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction() {
        SelectionMode.setNextMode();
        SwingUtilities.invokeLater(() -> {
            TopComponent topComponent = GraphEditorRegistry.getDefault().getTopmost();
            if (topComponent != null) {
                topComponent.requestActive();
            }
        });
    }

    private String getText() {
        if (SelectionMode.isEntities()) {
            return "Entity Selection";
        }
        if (SelectionMode.isLinks()) {
            return "Link Selection";
        }
        return "Unknown Selection";
    }

    private ResizableIcon getResizableIconForTooltip() {
        if (SelectionMode.isEntities()) {
            if (this._tooltipEntityIcon == null) {
                this._tooltipEntityIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/actions/SelectionToggleEntity.png");
            }
            return this._tooltipEntityIcon;
        }
        if (SelectionMode.isLinks()) {
            if (this._tooltipLinkIcon == null) {
                this._tooltipLinkIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/actions/SelectionToggleLink.png");
            }
            return this._tooltipLinkIcon;
        }
        return ResizableIcons.fromResource((String)this.iconResource());
    }

    private ResizableIcon getResizableIcon() {
        if (SelectionMode.isEntities()) {
            if (this._entityIcon == null) {
                this._entityIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/actions/SelectionToggleEntity.png");
            }
            return this._entityIcon;
        }
        if (SelectionMode.isLinks()) {
            if (this._linkIcon == null) {
                this._linkIcon = ResizableIcons.fromResource((String)"com/paterva/maltego/ui/graph/actions/SelectionToggleLink.png");
            }
            return this._linkIcon;
        }
        return ResizableIcons.fromResource((String)this.iconResource());
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._ribbonPresenter == null) {
            this._ribbonPresenter = RibbonPresenters.createCommandButton((Action)((Object)this), (String)this.getText(), (ResizableIcon)this.getResizableIcon());
            this._ribbonPresenter.setActionRichTooltip(this.getTooltip());
        }
        return this._ribbonPresenter;
    }

    private RichTooltip getTooltip() {
        ResizableIcon resizableIcon = this.getResizableIconForTooltip();
        resizableIcon.setDimension(new Dimension(ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48));
        BufferedImage iconImage = new BufferedImage(ICON_SIZE_LARGE_48, ICON_SIZE_LARGE_48, 2);
        resizableIcon.paintIcon((Component)this._ribbonPresenter, (Graphics)iconImage.createGraphics(), 0, 0);
        String shortcut = StringUtilities.getCtrlShortcut((String)"M");
        String descr = "Set the selection mode to either Entity Selection or Link Selection. (" + shortcut + ")";
        RichTooltip tooltip = new RichTooltip("Selection Mode", descr);
        tooltip.addFooterSection("Click the help button to get more help on Maltego features");
        tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
        tooltip.setMainImage((Image)iconImage);
        return tooltip;
    }

    protected boolean asynchronous() {
        return false;
    }

    private class SelectionModeListener
    implements PropertyChangeListener {
        private SelectionModeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("propertyModeChanged".equals(evt.getPropertyName())) {
                SelectionToggleAction.this._ribbonPresenter.setIcon(SelectionToggleAction.this.getResizableIcon());
                SelectionToggleAction.this._ribbonPresenter.setText(SelectionToggleAction.this.getText());
                SelectionToggleAction.this._ribbonPresenter.setActionRichTooltip(SelectionToggleAction.this.getTooltip());
                GraphID graphID = GraphSelectionContext.instance().getTopGraphID();
                if (graphID != null) {
                    GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
                    if (SelectionMode.isEntities()) {
                        Set links = selection.getSelectedModelLinks();
                        Set<EntityID> entities = GraphStructureUtils.getAttachedEntities(graphID, links);
                        selection.setSelectedModelEntities(entities);
                    } else {
                        Set entities = selection.getSelectedModelEntities();
                        Set<LinkID> links = GraphStructureUtils.getLinksBetween(graphID, entities);
                        selection.setSelectedModelLinks(links);
                    }
                }
            }
        }
    }
}

