/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.SelectLinks;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import com.paterva.maltego.util.StringUtilities;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import y.view.Graph2D;

public class SelectLinksAction
extends TopGraphSelectionContextAction
implements RibbonPresenter.Button {
    private JCommandButton _button;

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    public String getName() {
        return "Select Links";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/actions/SelectLinks.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_POPUP);
            RichTooltip tooltip = new RichTooltip(this.getName(), "Select incoming and outgoing links for the selected entities");
            tooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource().replace(".png", "48.png")));
            tooltip.addFooterSection("Click the help button to get more help on Maltego features");
            tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip(tooltip);
            this._button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectLinksAction.this.select(0);
                }
            });
            this._button.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton commandButton) {
                    return SelectLinksAction.this.createPopup();
                }
            });
        }
        return this._button;
    }

    private JCommandPopupMenu createPopup() {
        JCommandPopupMenu menu = new JCommandPopupMenu();
        this.addMenuButton(menu, "Outgoing & Incoming (" + StringUtilities.getCtrlShortcut((String)"L") + ")", 0);
        this.addMenuButton(menu, "Outgoing (" + StringUtilities.getCtrlShortcut((String)"End") + ")", 1);
        this.addMenuButton(menu, "Incoming (" + StringUtilities.getCtrlShortcut((String)"Home") + ")", 2);
        return menu;
    }

    private void addMenuButton(JCommandPopupMenu menu, String actionName, final int mode) {
        JCommandMenuButton b = new JCommandMenuButton(actionName, null);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectLinksAction.this.select(mode);
            }
        });
        menu.addMenuButton(b);
    }

    @Override
    protected void actionPerformed(GraphView graphView) {
    }

    public void select(int mode) {
        TopComponent activated = this.getTopComponent();
        GraphID graphID = this.getTopGraphID();
        Set entities = GraphSelection.forGraph((GraphID)graphID).getSelectedModelEntities();
        SelectLinks.selectLinks(graphID, entities, mode);
        this.activateTopComponent(activated);
    }

    private void activateTopComponent(final TopComponent activated) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                activated.requestActive();
            }
        });
    }

    @Override
    protected boolean isEnabled(Graph2D viewGraph) {
        return super.isEnabled(viewGraph) && viewGraph.selectedNodes().size() > 0;
    }
}

