/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.ui.graph.GraphView;
import com.paterva.maltego.ui.graph.actions.TopGraphSelectionContextAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.view2d.ZoomAndFlasher;
import java.util.HashSet;
import java.util.Set;
import org.openide.util.Exceptions;
import org.openide.util.actions.SystemAction;
import y.view.Graph2D;

public abstract class SelectFamilyAction
extends TopGraphSelectionContextAction {
    public static final int PARENTS = 1;
    public static final int CHILDREN = 2;
    private final boolean _keepSelection;
    private final int _selectWhat;

    public SelectFamilyAction(int selectWhat, boolean keepSelection) {
        this._selectWhat = selectWhat;
        this._keepSelection = keepSelection;
    }

    @Override
    protected void actionPerformed(GraphView graphView) {
        try {
            GraphID graphID = GraphIDProvider.forGraph((Graph2D)graphView.getViewGraph());
            this.updateNodeSelection(graphID);
            this.updateEdgeSelection(graphID);
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void updateNodeSelection(GraphID graphID) throws GraphStoreException {
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set selectedModelEntities = selection.getSelectedModelEntities();
        HashSet<EntityID> newSelection = new HashSet<EntityID>();
        for (EntityID modelEntity : selectedModelEntities) {
            if (this._keepSelection) {
                newSelection.add(modelEntity);
            }
            if ((this._selectWhat & 1) != 0) {
                this.addParents(graphID, modelEntity, newSelection);
            }
            if ((this._selectWhat & 2) == 0) continue;
            this.addChildren(graphID, modelEntity, newSelection);
        }
        selection.setSelectedModelEntities(newSelection);
        if (newSelection.size() == 1) {
            EntityID entityID = (EntityID)newSelection.iterator().next();
            ZoomAndFlasher.instance().zoomAndFlash(graphID, entityID);
        } else {
            ((ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class)).zoomToSelection();
        }
    }

    private void updateEdgeSelection(GraphID graphID) throws GraphStoreException {
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        Set selectedModelLinks = selection.getSelectedModelLinks();
        HashSet<LinkID> newSelection = new HashSet<LinkID>();
        for (LinkID modelLink : selectedModelLinks) {
            if (this._keepSelection) {
                newSelection.add(modelLink);
            }
            if (this._selectWhat == 3) {
                this.addNeighbours(graphID, modelLink, newSelection);
                continue;
            }
            if (this._selectWhat == 1) {
                this.addParents(graphID, modelLink, newSelection);
                continue;
            }
            if (this._selectWhat != 2) continue;
            this.addChildren(graphID, modelLink, newSelection);
        }
    }

    private void addChildren(GraphID graphID, EntityID modelEntity, Set<EntityID> newSelection) throws GraphStoreException {
        GraphStructureReader structureReader = this.getStructureReader(graphID);
        newSelection.addAll(structureReader.getChildren(modelEntity));
    }

    private void addParents(GraphID graphID, EntityID modelEntity, Set<EntityID> newSelection) throws GraphStoreException {
        GraphStructureReader structureReader = this.getStructureReader(graphID);
        newSelection.addAll(structureReader.getParents(modelEntity));
    }

    private void addChildren(GraphID graphID, LinkID modelLink, Set<LinkID> newSelection) throws GraphStoreException {
        GraphStructureReader structureReader = this.getStructureReader(graphID);
        EntityID targetID = structureReader.getTarget(modelLink);
        Set outgoingLinks = structureReader.getOutgoing(targetID);
        newSelection.addAll(outgoingLinks);
    }

    private void addParents(GraphID graphID, LinkID modelLink, Set<LinkID> newSelection) throws GraphStoreException {
        GraphStructureReader structureReader = this.getStructureReader(graphID);
        EntityID sourceID = structureReader.getSource(modelLink);
        Set incomingLinks = structureReader.getIncoming(sourceID);
        newSelection.addAll(incomingLinks);
    }

    private void addNeighbours(GraphID graphID, LinkID modelLink, Set<LinkID> newSelection) throws GraphStoreException {
        GraphStructureReader structureReader = this.getStructureReader(graphID);
        EntityID sourceID = structureReader.getSource(modelLink);
        Set outgoingLinks = structureReader.getOutgoing(sourceID);
        for (LinkID outgoingLink : outgoingLinks) {
            if (outgoingLink.equals((Object)modelLink)) continue;
            newSelection.add(outgoingLink);
        }
    }

    private GraphStructureReader getStructureReader(GraphID graphID) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        return structureReader;
    }
}

