/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.MaltegoEntitySpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphDataStoreReader;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import com.paterva.maltego.imgfactory.parts.EntityImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.actions.TopGraphAction;
import com.paterva.maltego.ui.graph.actions.ZoomToSelectionAction;
import com.paterva.maltego.ui.graph.util.GraphUtils;
import com.pinkmatter.api.flamingo.ResizableIcons;
import com.pinkmatter.api.flamingo.RibbonPresenter;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.RichTooltip;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;

public class SelectByTypeAction
extends TopGraphAction
implements RibbonPresenter.Button {
    private static final Logger LOG = Logger.getLogger(SelectByTypeAction.class.getName());
    private JCommandButton _button;

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.getRibbonButtonPresenter().setEnabled(value);
    }

    public String getName() {
        return "Select by Type";
    }

    protected String iconResource() {
        return "com/paterva/maltego/ui/graph/impl/Unknown.png";
    }

    public AbstractCommandButton getRibbonButtonPresenter() {
        if (this._button == null) {
            this._button = new JCommandButton(this.getName(), ResizableIcons.fromResource((String)this.iconResource()));
            this._button.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            RichTooltip tooltip = new RichTooltip(this.getName(), "Select entities by type");
            tooltip.setMainImage(ImageUtilities.loadImage((String)this.iconResource().replace(".png", "48.png")));
            tooltip.addFooterSection("Click the help button to get more help on Maltego features");
            tooltip.setFooterImage(ImageUtilities.loadImage((String)"com/paterva/maltego/welcome/resources/Help.png"));
            this._button.setActionRichTooltip(tooltip);
            this._button.setPopupCallback(ignored -> this.createPopup());
        }
        return this._button;
    }

    private JCommandPopupMenu createPopup() {
        JCommandPopupMenu specMenu = new JCommandPopupMenu();
        specMenu.setMaxVisibleMenuButtons(20);
        GraphID graphID = this.getTopGraphID();
        if (graphID != null) {
            LOG.log(Level.FINE, "Create popup for {0}", graphID);
            EntityRegistry registry = EntityRegistry.forGraphID((GraphID)graphID);
            EntityImageFactory imageFactory = EntityImageFactory.forGraph((GraphID)graphID);
            Set<String> typeNames = GraphUtils.getTypeNames(graphID, registry);
            LOG.log(Level.FINE, "Type names: {0}", typeNames);
            List<MaltegoEntitySpec> sortedSpecs = GraphUtils.getSortedSpecs(registry, typeNames);
            DefaultMutableTreeNode baseEntity = this.createTreeStructure(sortedSpecs, registry);
            if (LOG.isLoggable(Level.FINE)) {
                Enumeration<TreeNode> e = baseEntity.preorderEnumeration();
                LOG.fine("Tree");
                while (e.hasMoreElements()) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                    TreeNode[] path = node.getPath();
                    LOG.log(Level.FINE, "   {0} {1}", new Object[]{path.length - 1, path[path.length - 1]});
                }
            }
            this.addTreeItems(baseEntity, specMenu, registry, imageFactory);
            List<String> sortedUnknownTypes = this.getSortedUnknownTypes(registry, typeNames);
            LOG.log(Level.FINE, "Sorted unknown types: {0}", sortedUnknownTypes);
            for (String typeName : sortedUnknownTypes) {
                this.addMenuButton(specMenu, typeName, false, registry, imageFactory);
            }
        }
        if (specMenu.getMenuComponents().isEmpty()) {
            JCommandMenuButton button = new JCommandMenuButton("Graph is empty...", null);
            button.setEnabled(false);
            specMenu.addMenuButton(button);
        }
        return specMenu;
    }

    private DefaultMutableTreeNode createTreeStructure(List<MaltegoEntitySpec> sortedSpecs, EntityRegistry registry) {
        DefaultMutableTreeNode rootEntity = new DefaultMutableTreeNode("Unknown");
        HashSet<String> typesPresent = new HashSet<String>();
        for (MaltegoEntitySpec spec : sortedSpecs) {
            List specInheritance = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)spec.getTypeName());
            DefaultMutableTreeNode currentNode = rootEntity;
            typesPresent.add(spec.getTypeName());
            for (int i = specInheritance.size() - 2; i >= 0; --i) {
                String specTypeName = (String)specInheritance.get(i);
                int childIndex = this.getTreeNodeChildIndex(currentNode, specTypeName);
                if (childIndex < 0) {
                    DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(specTypeName);
                    currentNode.add(newNode);
                    currentNode = newNode;
                    continue;
                }
                currentNode = (DefaultMutableTreeNode)currentNode.getChildAt(childIndex);
            }
        }
        return this.sortTreeStructure(this.fillSelfNodes(rootEntity, typesPresent), registry);
    }

    private DefaultMutableTreeNode fillSelfNodes(DefaultMutableTreeNode root, Set<String> typesPresent) {
        String name = root.toString();
        Enumeration<TreeNode> children = root.children();
        boolean hasChildren = false;
        while (children.hasMoreElements()) {
            this.fillSelfNodes((DefaultMutableTreeNode)children.nextElement(), typesPresent);
            hasChildren = true;
        }
        if (typesPresent.contains(name) && hasChildren) {
            root.add(new DefaultMutableTreeNode(name));
        }
        return root;
    }

    private int getTreeNodeChildIndex(DefaultMutableTreeNode node, String nodeName) {
        boolean found = false;
        int index = -1;
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements() && !found) {
            if (children.nextElement().toString().equals(nodeName)) {
                found = true;
            }
            ++index;
        }
        return found ? index : -1;
    }

    private DefaultMutableTreeNode sortTreeStructure(DefaultMutableTreeNode entity, EntityRegistry registry) {
        int i;
        for (i = 1; i < entity.getChildCount(); ++i) {
            for (int j = 0; j < entity.getChildCount() - i; ++j) {
                DefaultMutableTreeNode prevNode;
                String nodeTemp2;
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)entity.getChildAt(j + 1);
                String nodeTemp1 = this.getDisplayName(child.getUserObject().toString(), registry);
                if (nodeTemp1.compareToIgnoreCase(nodeTemp2 = this.getDisplayName((prevNode = (DefaultMutableTreeNode)entity.getChildAt(j)).getUserObject().toString(), registry)) >= 0) continue;
                entity.insert(child, j);
                entity.insert(prevNode, j + 1);
            }
        }
        for (i = 0; i < entity.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)entity.getChildAt(i);
            if (child.getChildCount() <= 0) continue;
            this.sortTreeStructure(child, registry);
        }
        return entity;
    }

    private String getDisplayName(String typeName, EntityRegistry registry) {
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
        return spec != null ? spec.getDisplayName() : typeName;
    }

    private void addTreeItems(DefaultMutableTreeNode entity, JCommandPopupMenu specMenu, EntityRegistry registry, EntityImageFactory imageFactory) {
        Enumeration<TreeNode> entityChildren = entity.children();
        while (entityChildren.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)entityChildren.nextElement();
            JCommandMenuButton button = this.addMenuButton(specMenu, node.toString(), node.getChildCount() == 0, registry, imageFactory);
            if (node.getChildCount() == 0) continue;
            button.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
            button.setPopupOrientationKind(JCommandButton.CommandButtonPopupOrientationKind.SIDEWARD);
            button.setPopupCallback(ignored -> {
                JCommandPopupMenu subMenu = new JCommandPopupMenu();
                specMenu.setMaxVisibleMenuButtons(20);
                this.addTreeItems(node, subMenu, registry, imageFactory);
                return subMenu;
            });
        }
    }

    private JCommandMenuButton addMenuButton(JCommandPopupMenu specMenu, String typeName, boolean isLeafNode, EntityRegistry registry, EntityImageFactory imageFactory) {
        Image image;
        String name = typeName;
        MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
        if (spec != null) {
            name = spec.getDisplayName();
        }
        JCommandMenuButton b = new JCommandMenuButton(name, (image = imageFactory.getSmallTypeImage(typeName, null)) == null ? null : ResizableIcons.fromImage((Image)image));
        b.addActionListener(ignored -> {
            try {
                this.selectByType(registry, typeName, isLeafNode);
            }
            catch (GraphStoreException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        });
        specMenu.addMenuButton(b);
        return b;
    }

    private List<String> getSortedUnknownTypes(EntityRegistry registry, Set<String> typeNames) {
        ArrayList<String> unknownTypeNames = new ArrayList<String>();
        for (String typeName : typeNames) {
            MaltegoEntitySpec spec = (MaltegoEntitySpec)registry.get(typeName);
            if (spec != null) continue;
            unknownTypeNames.add(typeName);
        }
        Collections.sort(unknownTypeNames);
        return unknownTypeNames;
    }

    @Override
    protected void actionPerformed(TopComponent tc) {
    }

    private void selectByType(EntityRegistry registry, String typeName, boolean isLeafNode) throws GraphStoreException {
        GraphID graphID = this.getTopGraphID();
        if (graphID != null && registry != null && typeName != null) {
            GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
            GraphDataStoreReader dataReader = graphStore.getGraphDataStore().getDataStoreReader();
            Set entityIDs = GraphStoreHelper.getEntityIDs((GraphID)graphID);
            HashSet<EntityID> toSelect = new HashSet<EntityID>();
            for (EntityID entityID : entityIDs) {
                String type = dataReader.getEntityType(entityID);
                if (isLeafNode) {
                    if (!type.equals(typeName)) continue;
                    toSelect.add(entityID);
                    continue;
                }
                List inheritedSpecs = InheritanceHelper.getInheritanceList((SpecRegistry)registry, (String)type);
                if (inheritedSpecs == null || !inheritedSpecs.contains(typeName)) continue;
                toSelect.add(entityID);
            }
            GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
            selection.setSelectedModelEntities(toSelect);
            ZoomToSelectionAction zoomAction = (ZoomToSelectionAction)SystemAction.get(ZoomToSelectionAction.class);
            if (zoomAction != null) {
                zoomAction.zoomToSelection();
            }
            TopComponent topComponent = this.getTopComponent();
            SwingUtilities.invokeLater(() -> topComponent.requestActive());
        }
    }
}

