/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.bookmarks.ui.BookmarkFactory;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.BookmarkUtils;
import com.paterva.maltego.ui.graph.GraphEditorRegistry;
import com.paterva.maltego.ui.graph.GraphSelectionContext;
import com.paterva.maltego.ui.graph.GraphViewCookie;
import com.paterva.maltego.ui.graph.actions.BookmarkAction;
import com.paterva.maltego.util.ui.slide.SlideWindow;
import com.paterva.maltego.util.ui.slide.SlideWindowManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.openide.windows.TopComponent;
import y.view.Graph2DView;
import y.view.View;

public class SelectBookmarkAction
extends AbstractAction {
    private final GraphSelectionContext selectionContext = GraphSelectionContext.instance();

    @Override
    public void actionPerformed(final ActionEvent e) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int bookmark = Integer.MAX_VALUE;
                String actionCommand = e.getActionCommand();
                if (actionCommand != null) {
                    TopComponent tc;
                    SlideWindow slideWindow;
                    try {
                        actionCommand = actionCommand.replaceAll("[^\\d]", "");
                        bookmark = Integer.parseInt(actionCommand);
                        --bookmark;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (bookmark >= -1 && bookmark < BookmarkFactory.getDefault().getBookmarkCount() && (slideWindow = SlideWindowManager.getDefault().getActive()) == null && (tc = GraphEditorRegistry.getDefault().getTopmost()) != null) {
                        GraphID graphID = null;
                        Graph2DView view = SelectBookmarkAction.this.getGraph2DView(tc);
                        if (view == null) {
                            graphID = SelectBookmarkAction.this.selectionContext.getTopGraphID();
                            View currentView = GraphViewManager.getDefault().getViewGraph(graphID).getCurrentView();
                            if (currentView instanceof Graph2DView) {
                                view = (Graph2DView)currentView;
                            }
                        }
                        if (view != null && !SelectBookmarkAction.this.isLabelEditorOpen(view) && !BookmarkAction.doesTextComponentHaveFocus()) {
                            BookmarkUtils.selectBookmarked(tc, graphID, bookmark, false);
                        }
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private boolean isLabelEditorOpen(Graph2DView g2dv) {
        int modeCount = 0;
        Iterator viewModes = g2dv.getViewModes();
        while (viewModes.hasNext()) {
            viewModes.next();
            ++modeCount;
        }
        return modeCount < 3;
    }

    private Graph2DView getGraph2DView(TopComponent tc) {
        JComponent viewControl;
        GraphViewCookie viewCookie;
        if (tc != null && (viewCookie = (GraphViewCookie)tc.getLookup().lookup(GraphViewCookie.class)) != null && (viewControl = viewCookie.getGraphView().getViewControl()) instanceof Graph2DView) {
            return (Graph2DView)viewControl;
        }
        return null;
    }
}

