/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.actions;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.graph.GraphViewManager;
import com.paterva.maltego.ui.graph.GraphCookie;
import com.paterva.maltego.ui.graph.actions.CookieAction;
import com.paterva.maltego.ui.graph.view2d.layout.MaltegoLabelLayouter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import y.base.Edge;
import y.base.EdgeCursor;
import y.base.Graph;
import y.base.Node;
import y.base.NodeCursor;
import y.layout.GraphLayout;
import y.layout.Layouter;
import y.layout.NodeLabelLayout;
import y.layout.NodeLabelModel;
import y.util.GraphCopier;
import y.view.Graph2D;
import y.view.Graph2DCopyFactory;
import y.view.Graph2DLayoutExecutor;
import y.view.NodeLabel;
import y.view.NodeRealizer;

public class PlaceLabelsAction
extends CookieAction<GraphCookie> {
    private boolean _isRunning = false;

    public PlaceLabelsAction() {
        super(GraphCookie.class);
    }

    public String getName() {
        return "Re-arrange labels";
    }

    @Override
    protected void performAction(GraphCookie cookie) {
        if (cookie != null) {
            GraphID graphID = cookie.getGraphID();
            Graph2D graph = GraphViewManager.getDefault().getViewGraph(graphID);
            if (graph instanceof Graph2D) {
                this.perform(graph, null);
            }
        }
    }

    public void perform(final Graph2D graph2D, final Runnable callback) {
        if (this._isRunning || graph2D.nodeCount() + graph2D.edgeCount() > 1000) {
            if (callback != null) {
                callback.run();
            }
            return;
        }
        this._isRunning = true;
        MaltegoLabelLayouter labelLayouter = new MaltegoLabelLayouter();
        final HashMap nodeMap = new HashMap();
        final HashMap edgeMap = new HashMap();
        Graph2DLayoutExecutor executer = new Graph2DLayoutExecutor(5){

            protected void applyGraphLayout(Graph2D gd, GraphLayout gl) {
                SwingUtilities.invokeLater(new GraphLayoutApplyer(graph2D, gl, nodeMap, edgeMap));
            }
        };
        GraphCopier copier = new GraphCopier((GraphCopier.CopyFactory)new Graph2DCopyFactory(){

            public Edge copyEdge(Graph graph, Node node, Node node1, Edge edge) {
                Edge copyEdge = super.copyEdge(graph, node, node1, edge);
                edgeMap.put(edge, copyEdge);
                return copyEdge;
            }

            public Node copyNode(Graph graph, Node node) {
                Node copyNode = super.copyNode(graph, node);
                nodeMap.put(node, copyNode);
                return copyNode;
            }
        });
        Graph2D copy = (Graph2D)copier.copy((Graph)graph2D);
        executer.doLayout(copy, (Layouter)labelLayouter, new Runnable(){

            @Override
            public void run() {
                PlaceLabelsAction.this._isRunning = false;
                graph2D.getCurrentView().getComponent().repaint();
                if (callback != null) {
                    callback.run();
                }
            }
        }, null);
    }

    private static boolean areEqual(NodeLabelModel left, NodeLabelModel right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (right == null) {
            return false;
        }
        return left.getClass().equals(right.getClass());
    }

    private static class GraphLayoutApplyer
    implements Runnable {
        private final Graph2D _graph2D;
        private final GraphLayout _graphLayout;
        private Map<Node, Node> _nodeMap;
        private Map<Edge, Edge> _edgeMap;

        public GraphLayoutApplyer(Graph2D gd, GraphLayout gl, Map<Node, Node> nodeMap, Map<Edge, Edge> edgeMap) {
            this._graph2D = gd;
            this._graphLayout = gl;
            this._nodeMap = nodeMap;
            this._edgeMap = edgeMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                NodeLabel label;
                NodeRealizer realizer;
                NodeLabelLayout labelLayout;
                int i;
                NodeLabelLayout[] labelLayouts;
                NodeCursor nodes = this._graph2D.nodes();
                while (nodes.ok()) {
                    Node node = nodes.node();
                    Node copiedNode = this._nodeMap.get(node);
                    if (copiedNode != null && (labelLayouts = this._graphLayout.getNodeLabelLayout((Object)copiedNode)) != null) {
                        for (i = 0; i < labelLayouts.length; ++i) {
                            NodeLabelModel layoutLabelModel;
                            NodeLabelModel labelModel;
                            labelLayout = labelLayouts[i];
                            if (labelLayout == null || (realizer = this._graph2D.getRealizer(node)) == null || realizer.labelCount() <= i || (label = realizer.getLabel(i)) == null || !PlaceLabelsAction.areEqual(labelModel = label.getLabelModel(), layoutLabelModel = labelLayout.getLabelModel())) continue;
                            label.setModelParameter(labelLayout.getModelParameter());
                        }
                    }
                    nodes.next();
                }
                EdgeCursor edges = this._graph2D.edges();
                while (edges.ok()) {
                    Edge edge = edges.edge();
                    Edge copiedEdge = this._edgeMap.get(edge);
                    if (copiedEdge != null && (labelLayouts = this._graphLayout.getEdgeLabelLayout((Object)copiedEdge)) != null) {
                        for (i = 0; i < labelLayouts.length; ++i) {
                            labelLayout = labelLayouts[i];
                            if (labelLayout == null || (realizer = this._graph2D.getRealizer(edge)) == null || realizer.labelCount() <= i || (label = realizer.getLabel(i)) == null || !Utilities.compareObjects((Object)label.getLabelModel(), (Object)labelLayout.getLabelModel())) continue;
                            label.setModelParameter(labelLayout.getModelParameter());
                        }
                    }
                    edges.next();
                }
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }
}

